#!/bin/sh

#
# NOTE:
#  This is a wrapper for GNU's join under galaxy
#  not ment to be used from command line (if you're using the command line, simply run 'join' directly...)
#
# All parameters must be supplied.
# the join_tool.xml file takes care of that.

JOINTYPE="$1"
OUTPUT_FORMAT="$2"
EMPTY_STRING="$3"
DELIMITER="$4"
IGNORE_CASE="$5"

INPUT1="$6"
COLUMN1="$7"
INPUT2="$8"
COLUMN2="$9"
OUTPUT="${10}"

if [ "$OUTPUT" == "" ]; then	
	echo "This script is part of galaxy. Don't run it manually.\n" >&2
	exit 1;
fi

#This a TAB hack for galaxy (which can't transfer a "\t" as a parameter)
[ "$DELIMITER" == "tab" ] && DELIMITER="	"

#Remove spaces from the output format (if the user entered any)
OUTPUT_FORMAT=${OUTPUT_FORMAT// /}
[ "$OUTPUT_FORMAT" != "" ] && OUTPUT_FORMAT="-o $OUTPUT_FORMAT"

echo join $OUTPUT_FORMAT -t "$DELIMITER" -e "$EMPTY_STRING" $IGNORE_CASE $JOINTYPE -1 "$COLUMN1" -2 "$COLUMN2" 
#echo join $OUTPUT_FORMAT -t "$DELIMITER" -e "$EMPTY_STRING" $IGNORE_CASE $JOINTYPE -1 "$COLUMN1" -2 "$COLUMN2" "$INPUT1" "$INPUT2" \> "$OUTPUT" 
join $OUTPUT_FORMAT -t "$DELIMITER" -e "$EMPTY_STRING" $JOINTYPE -1 "$COLUMN1" -2 "$COLUMN2" "$INPUT1" "$INPUT2" > "$OUTPUT" || exit 1
