/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.accc.db.rdf.crawler.dataStructure.sparql;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.ArrayList;
import org.apache.jena.riot.RDFDataMgr;

public class JenaModelGenerator {
    String endpointURI = null;
    String[] graphURIs = null;
    Model model = null;
    Dataset dataset = null;

    public static void main(String[] args) throws Exception {
        JenaModelGenerator jmg = new JenaModelGenerator("c:\\temp\\allie.ttl");
    }

    public JenaModelGenerator(String file) throws Exception {
        this.readCrawlerRdfFile(file);
    }

    public void readCrawlerRdfFile(String file) throws Exception {
        this.model = RDFDataMgr.loadModel((String)file);
        Property endpointPro = this.model.getProperty("http://www.w3.org/ns/sparql-service-description#endpoint");
        NodeIterator nit = this.model.listObjectsOfProperty(endpointPro);
        int cnt = 0;
        Resource endPointRes = null;
        while (nit.hasNext()) {
            if (cnt == 0) {
                RDFNode endPointNode = nit.next();
                endPointRes = endPointNode.asResource();
                this.endpointURI = endPointRes.getURI();
            }
            ++cnt;
        }
        Property hasGraphPro = this.model.getProperty("http://sparqlbuilder.org/hasGraph");
        NodeIterator nodeit = this.model.listObjectsOfProperty(endPointRes, hasGraphPro);
        ArrayList<String> graphURIList = new ArrayList<String>();
        while (nodeit.hasNext()) {
            Resource graphRes = nodeit.nextNode().asResource();
            String graphURI = graphRes.getURI();
            graphURIList.add(graphURI);
        }
        this.graphURIs = graphURIList.toArray(new String[0]);
    }

    public Model getModel() {
        return this.model;
    }

    public String getEndpointURI() {
        return this.endpointURI;
    }

    public String[] getGraphURIs() {
        return this.graphURIs;
    }
}

