/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.accc.db.rdf.jena.test;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sdb.SDBFactory;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.StoreDesc;
import com.hp.hpl.jena.sdb.sql.JDBC;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.store.DatabaseType;
import com.hp.hpl.jena.sdb.store.LayoutType;
import com.hp.hpl.jena.util.PrintUtil;

public class ModelTester {
    public static void main(String[] args) throws Exception {
        String rdfFile = "c:/Temp/pubmed12n0684.xml.gz.nt";
        Model model = null;
        model = ModelTester.createModelOnMemory();
        model.read(rdfFile);
        System.out.println("Size: " + model.size());
    }

    public static Model createModelOnMemory() throws Exception {
        return ModelFactory.createDefaultModel();
    }

    public static Model createModelOnFileSystem(String fileName) throws Exception {
        ModelMaker modelMaker = ModelFactory.createFileModelMaker((String)fileName);
        return modelMaker.createFreshModel();
    }

    public static Model createModelOnMySQL(String db_url, String db_user, String db_passwd) throws Exception {
        StoreDesc storeDesc = new StoreDesc(LayoutType.LayoutTripleNodesHash, DatabaseType.MySQL);
        try {
            JDBC.loadDriverMySQL();
            System.out.println("JDBC driver load successfully!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SDBConnection sdbConnection = new SDBConnection(db_url, db_user, db_passwd);
        Store store = SDBFactory.connectStore((SDBConnection)sdbConnection, (StoreDesc)storeDesc);
        Dataset dataset = SDBFactory.connectDataset((Store)store);
        return dataset.getDefaultModel();
    }

    private static void printStatements(Model m, Resource s, Property p, Resource o) {
        int cnt = 0;
        StmtIterator iter = m.listStatements(s, p, (RDFNode)o);
        while (iter.hasNext()) {
            Statement stmt = (Statement)iter.next();
            System.out.println(" - " + PrintUtil.print((Statement)stmt));
            ++cnt;
        }
        System.out.println(String.valueOf(cnt) + " statements");
    }
}

