/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.accc.db.rdf.crawler.dataStructure.sparql;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import jp.riken.accc.db.rdf.crawler.dataStructure.SchemaCategory;
import jp.riken.accc.db.rdf.crawler.dataStructure.sparql.RDFsCrawler;

public class RDFsCrawlerImpl
implements RDFsCrawler {
    String endpointURI = null;
    String[] graphURIs = null;
    String[] graphURIFilter = new String[]{"http://www.openlinksw.com/", "http://www.w3.org/"};

    public static void main(String[] args) throws Exception {
        String endPURI = "http://data.allie.dbcls.jp/sparql";
        long start = System.currentTimeMillis();
        RDFsCrawlerImpl impl = new RDFsCrawlerImpl(endPURI);
        String[] graphURIs = impl.getGraphURIs();
        impl.setGraphURIs(graphURIs);
        System.out.println("SPARQL Endpoint: " + endPURI);
        String[] stringArray = graphURIs;
        int n = graphURIs.length;
        int n2 = 0;
        while (n2 < n) {
            String graphURI = stringArray[n2];
            System.out.println("graph: " + graphURI);
            ++n2;
        }
        SchemaCategory schema = impl.determineSchemaCategory();
        schema.write2File("c:/temp/allie.xml", "RDF/XML-ABBREV");
        schema.write2File("c:/temp/allie.ttl", "Turtle");
        System.out.println("Category:" + schema.category);
        long end = System.currentTimeMillis();
        System.out.println(String.valueOf(end - start) + " msec.");
    }

    public void setGraphURIs(String[] graphURIs) {
        this.graphURIs = graphURIs;
    }

    public String[] getGraphURIs() throws Exception {
        StringBuffer queryBuffer = new StringBuffer();
        queryBuffer.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
        queryBuffer.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
        queryBuffer.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
        queryBuffer.append("SELECT DISTINCT ?g\n");
        queryBuffer.append("WHERE{\n");
        queryBuffer.append(" GRAPH ?g{ ?s ?p ?o.}\n");
        queryBuffer.append("}");
        String queryString = queryBuffer.toString();
        Query query = QueryFactory.create((String)queryString);
        QueryExecution qexec = null;
        ResultSet results = null;
        try {
            qexec = QueryExecutionFactory.sparqlService((String)this.endpointURI, (Query)query);
            results = qexec.execSelect();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        ArrayList<String> graphList = new ArrayList<String>();
        while (results.hasNext()) {
            QuerySolution sol = results.next();
            Resource graph = sol.getResource("g");
            if (this.uriFilter(graph.getURI(), this.graphURIFilter) == null) continue;
            graphList.add(graph.getURI());
        }
        qexec.close();
        return graphList.toArray(new String[0]);
    }

    public SchemaCategory determineSchemaCategory() throws Exception {
        Date start = new Date();
        String[] res1 = this.getRDFProperties();
        String[] res3 = this.getDeclaredRDFsClasses();
        System.out.println("#Class(total): " + res3.length);
        System.out.println("#Property(total): " + res1.length);
        Model model = null;
        model = ModelFactory.createDefaultModel();
        Property endpointPro = model.createProperty("http://www.w3.org/ns/sparql-service-description#endpoint");
        Resource serviceRes = model.createResource("http://www.w3.org/ns/sparql-service-description#Service");
        Resource endpointRes = model.createResource(this.endpointURI);
        Property typePro = model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        Resource thisRes = model.createResource("");
        thisRes.addProperty(typePro, (RDFNode)serviceRes);
        thisRes.addProperty(endpointPro, (RDFNode)endpointRes);
        Schema schema = null;
        if (res1.length != 0 && res3.length != 0) {
            schema = this.getPropertySchema(model, res1);
            if (schema.propertyCategory == 4) {
                schema.classCategory = 4;
            } else {
                schema = this.getClassSchema(schema, res3);
            }
        } else {
            schema = new Schema(model, 4, null, 3, 4, 0, null);
        }
        model = schema.model;
        int category = 0;
        category = schema.propertyCategory == 1 && schema.classCategory == 1 ? 1 : (schema.propertyCategory == 2 && schema.classCategory == 1 ? 2 : (schema.propertyCategory == 4 || schema.classCategory == 3 ? 4 : 3));
        Resource endP = model.createResource(this.endpointURI);
        Property catPro = model.createProperty("http://sparqlbuilder.org/schemaCategory");
        endP.addLiteral(catPro, (long)schema.category);
        Property clsCatPro = model.createProperty("http://sparqlbuilder.org/classCategory");
        endP.addLiteral(clsCatPro, (long)schema.category);
        Property proCatPro = model.createProperty("http://sparqlbuilder.org/propertyCategory");
        endP.addLiteral(proCatPro, (long)schema.category);
        Property numTriplesPro = model.createProperty("http://sparqlbuilder.org/numberOfTriples");
        endP.addLiteral(numTriplesPro, (long)schema.numTriples);
        Property crawlStartTimePro = model.createProperty("http://sparqlbuilder.org/crawlStartTime");
        endP.addLiteral(crawlStartTimePro, (Object)start);
        Property crawlEndTimePro = model.createProperty("http://sparqlbuilder.org/crawlEndTime");
        endP.addLiteral(crawlEndTimePro, (Object)new Date());
        if (this.graphURIs != null && this.graphURIs.length != 0) {
            Property hasGraphPro = model.createProperty("http://sparqlbuilder.org/hasGraph");
            String[] stringArray = this.graphURIs;
            int n = this.graphURIs.length;
            int n2 = 0;
            while (n2 < n) {
                String graphURI = stringArray[n2];
                Resource graph = model.createResource(graphURI);
                endP.addProperty(hasGraphPro, (RDFNode)graph);
                ++n2;
            }
        }
        return new SchemaCategory(category, model);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Schema getClassSchema(Schema schema, String[] classURIs) throws Exception {
        filterStrs = new String[]{"http://www.openlinksw", "http://www.w3.org"};
        inferedClasses = schema.inferedClasses;
        classCategory = 1;
        cnt = 0;
        var10_7 = classURIs;
        var9_8 = classURIs.length;
        var8_10 = 0;
        while (var8_10 < var9_8) {
            classURI = var10_7[var8_10];
            if (inferedClasses.contains(classURI)) {
                ++cnt;
            }
            ++var8_10;
        }
        classCategory = cnt == inferedClasses.size() ? 1 : (cnt == 0 ? 3 : 2);
        model = schema.model;
        typePro = model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        labelPro = model.createProperty("http://www.w3.org/2000/01/rdf-schema#label");
        clsCls = model.createResource("http://www.w3.org/2000/01/rdf-schema#Class");
        numInstancePro = model.createProperty("http://sparqlbuilder.org/numberOfInstances");
        classList = new ArrayList<Resource>();
        for (String clsURI : inferedClasses) {
            cls = model.createResource(clsURI);
            cls.addProperty(typePro, (RDFNode)clsCls);
            classList.add(cls);
            queryBuffer = new StringBuffer();
            queryBuffer.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
            queryBuffer.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
            queryBuffer.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
            queryBuffer.append("SELECT DISTINCT ?label\n");
            if (this.graphURIs != null && this.graphURIs.length != 0) {
                var20_30 = this.graphURIs;
                var19_29 = this.graphURIs.length;
                var18_26 = 0;
                while (var18_26 < var19_29) {
                    graphURI = var20_30[var18_26];
                    queryBuffer.append("FROM <");
                    queryBuffer.append(graphURI);
                    queryBuffer.append(">\n");
                    ++var18_26;
                }
            }
            queryBuffer.append("WHERE{\n");
            queryBuffer.append("  <" + clsURI + "> rdfs:label ?label.\n");
            queryBuffer.append("}");
            queryString /* !! */  = queryBuffer.toString();
            query = QueryFactory.create((String)queryString /* !! */ );
            qexec = null;
            results = null;
            try {
                qexec = QueryExecutionFactory.sparqlService((String)this.endpointURI, (Query)query);
                results = qexec.execSelect();
                System.out.print(".");
                if (true) ** GOTO lbl73
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
            do {
                if ((labelLiteral = (sol = results.next()).getLiteral("label")) == null) continue;
                label = labelLiteral.getString();
                cls.addLiteral(labelPro, (Object)label);
lbl73:
                // 3 sources

            } while (results.hasNext());
            qexec.close();
            queryBuffer = new StringBuffer();
            queryBuffer.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
            queryBuffer.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
            queryBuffer.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
            queryBuffer.append("SELECT (count(DISTINCT ?i)  AS ?num) \n");
            if (this.graphURIs != null && this.graphURIs.length != 0) {
                var24_39 = this.graphURIs;
                label = this.graphURIs.length;
                labelLiteral = 0;
                while (labelLiteral < label) {
                    graphURI = var24_39[labelLiteral];
                    queryBuffer.append("FROM <");
                    queryBuffer.append(graphURI);
                    queryBuffer.append(">\n");
                    ++labelLiteral;
                }
            }
            queryBuffer.append("WHERE{\n");
            queryBuffer.append("  {?i rdf:type <" + cls.getURI() + ">.}\n");
            queryBuffer.append(" UNION  {[] ?p ?i.  ?p rdfs:range <" + cls.getURI() + ">.}\n");
            queryBuffer.append(" UNION  {?i ?p [].  ?p rdfs:domain <" + cls.getURI() + ">.}\n");
            queryBuffer.append("}");
            queryString /* !! */  = queryBuffer.toString();
            query = QueryFactory.create((String)queryString /* !! */ );
            qexec = null;
            results = null;
            try {
                qexec = QueryExecutionFactory.sparqlService((String)this.endpointURI, (Query)query);
                results = qexec.execSelect();
                if (true) ** GOTO lbl124
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
            do {
                if ((lit = (sol = results.next()).getLiteral("num")) == null) continue;
                num = lit.getInt();
                cls.addLiteral(numInstancePro, (long)num);
lbl124:
                // 3 sources

            } while (results.hasNext());
            qexec.close();
        }
        queryBuffer = new StringBuffer();
        queryBuffer.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
        queryBuffer.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
        queryBuffer.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
        queryBuffer.append("SELECT DISTINCT ?c ?d \n");
        if (this.graphURIs != null && this.graphURIs.length != 0) {
            queryString /* !! */  = this.graphURIs;
            queryBuffer = this.graphURIs.length;
            cls = 0;
            while (cls < queryBuffer) {
                graphURI = queryString /* !! */ [cls];
                queryBuffer.append("FROM <");
                queryBuffer.append(graphURI);
                queryBuffer.append(">\n");
                ++cls;
            }
        }
        queryBuffer.append("WHERE{\n");
        queryBuffer.append("  ?c rdfs:subclassOf ?d.\n");
        queryBuffer.append("FILTER(! contains(str(?c),\"openlinksw\"))\n");
        queryBuffer.append("}");
        queryString = queryBuffer.toString();
        query = QueryFactory.create((String)queryString);
        qexec = null;
        results = null;
        try {
            qexec = QueryExecutionFactory.sparqlService((String)this.endpointURI, (Query)query);
            results = qexec.execSelect();
            System.out.print(".");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        subClsOf = model.createProperty("http://www.w3.org/2000/01/rdf-schema#subclassOf");
        while (results.hasNext()) {
            sol = results.next();
            cCls = sol.getResource("c");
            pCls = sol.getResource("d");
            if (cCls == null || pCls == null || this.uriFilter(cCls.getURI(), filterStrs) == null) continue;
            cCls = model.createResource(cCls.getURI());
            pCls = model.createResource(pCls.getURI());
            cCls.addProperty(subClsOf, (RDFNode)pCls);
        }
        qexec.close();
        schema.model = model;
        schema.classCategory = classCategory;
        return schema;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public Schema getPropertySchema(Model model, String[] propertyURIs) throws Exception {
        domainPro = model.createProperty("http://www.w3.org/2000/01/rdf-schema#domain");
        rangePro = model.createProperty("http://www.w3.org/2000/01/rdf-schema#range");
        typePro = model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        labelPro = model.createProperty("http://www.w3.org/2000/01/rdf-schema#label");
        clsCls = model.createResource("http://www.w3.org/2000/01/rdf-schema#Class");
        numTriplePro = model.createProperty("http://sparqlbuilder.org/numberOfTriples");
        numStartClsNumInsPro = model.createProperty("http://sparqlbuilder.org/numberOfInstancesOfStartClass");
        numEndClsNumInsPro = model.createProperty("http://sparqlbuilder.org/numberOfInstancesOfEndClass");
        numDomClsNumInsPro = model.createProperty("http://sparqlbuilder.org/numberOfInstancesOfDomainClass");
        numRanClsNumInsPro = model.createProperty("http://sparqlbuilder.org/numberOfInstancesOfRangeClass");
        indCatPro = model.createProperty("http://sparqlbuilder.org/individualPropertyCategory");
        classRelationCls = model.createResource("http://sparqlbuilder.org/ClassRelation");
        startClsPro = model.createProperty("http://sparqlbuilder.org/startClass");
        endClsPro = model.createProperty("http://sparqlbuilder.org/endClass");
        propPro = model.createProperty("http://sparqlbuilder.org/property");
        propProfileCls = model.createResource("http://sparqlbuilder.org/PropertyProfile");
        isDomClsLimPro = model.createProperty("http://sparqlbuilder.org/startClassLimitedQ");
        isRanClsLimPro = model.createProperty("http://sparqlbuilder.org/endClassLimitedQ");
        classURISet = new HashSet<String>();
        wholePropertyCategory = 0;
        totalNumTriples = 0;
        countProperties = new int[4];
        var28_25 = propertyURIs;
        var27_27 = propertyURIs.length;
        var26_28 = 0;
        while (var26_28 < var27_27) {
            block100: {
                propURI = var28_25[var26_28];
                domClassSet = new HashSet<String>();
                ranClassSet = new HashSet<String>();
                queryBuffer = new StringBuffer();
                queryBuffer.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
                queryBuffer.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
                queryBuffer.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
                queryBuffer.append("SELECT DISTINCT ?d\n");
                if (this.graphURIs != null && this.graphURIs.length != 0) {
                    var35_39 = this.graphURIs;
                    var34_38 = this.graphURIs.length;
                    var33_36 = 0;
                    while (var33_36 < var34_38) {
                        graphURI = var35_39[var33_36];
                        queryBuffer.append("FROM <");
                        queryBuffer.append(graphURI);
                        queryBuffer.append(">\n");
                        ++var33_36;
                    }
                }
                queryBuffer.append("WHERE{\n");
                queryBuffer.append(" <" + propURI + "> rdfs:domain ?d.\n");
                queryBuffer.append("}");
                queryString = queryBuffer.toString();
                query = QueryFactory.create((String)queryString);
                qexec = null;
                results = null;
                try {
                    qexec = QueryExecutionFactory.sparqlService((String)this.endpointURI, (Query)query);
                    results = qexec.execSelect();
                    System.out.print(".");
                    if (true) ** GOTO lbl77
                }
                catch (Exception ex) {
                    System.out.println(queryString);
                    ex.printStackTrace();
                    throw ex;
                }
                do {
                    sol = results.next();
                    dom = sol.getResource("d");
                    domClassSet.add(dom.getURI());
lbl77:
                    // 2 sources

                } while (results.hasNext());
                qexec.close();
                queryBuffer = new StringBuffer();
                queryBuffer.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
                queryBuffer.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
                queryBuffer.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
                queryBuffer.append("SELECT DISTINCT ?r\n");
                if (this.graphURIs != null && this.graphURIs.length != 0) {
                    var39_52 = this.graphURIs;
                    var38_45 = this.graphURIs.length;
                    dom = 0;
                    while (dom < var38_45) {
                        graphURI = var39_52[dom];
                        queryBuffer.append("FROM <");
                        queryBuffer.append(graphURI);
                        queryBuffer.append(">\n");
                        ++dom;
                    }
                }
                queryBuffer.append("WHERE{\n");
                queryBuffer.append(" <" + propURI + "> rdfs:range ?r.\n");
                queryBuffer.append("}");
                queryString = queryBuffer.toString();
                query = QueryFactory.create((String)queryString);
                qexec = null;
                results = null;
                try {
                    qexec = QueryExecutionFactory.sparqlService((String)this.endpointURI, (Query)query);
                    results = qexec.execSelect();
                    System.out.print(".");
                    if (true) ** GOTO lbl126
                }
                catch (Exception ex) {
                    System.out.println(queryString);
                    ex.printStackTrace();
                    throw ex;
                }
                do {
                    sol = results.next();
                    ran = sol.getResource("r");
                    ranClassSet.add(ran.getURI());
lbl126:
                    // 2 sources

                } while (results.hasNext());
                qexec.close();
                propDomRanDeclList = new ArrayList<String[]>();
                propDomRanDeclList2 = new ArrayList<PropertyDomainRangeDecl>();
                queryBuffer = new StringBuffer();
                queryBuffer.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
                queryBuffer.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
                queryBuffer.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
                queryBuffer.append("SELECT DISTINCT ?d ?r\n");
                if (this.graphURIs != null && this.graphURIs.length != 0) {
                    var41_62 = this.graphURIs;
                    var40_56 = this.graphURIs.length;
                    var39_53 = 0;
                    while (var39_53 < var40_56) {
                        graphURI = var41_62[var39_53];
                        queryBuffer.append("FROM <");
                        queryBuffer.append(graphURI);
                        queryBuffer.append(">\n");
                        ++var39_53;
                    }
                }
                queryBuffer.append("WHERE{\n");
                queryBuffer.append("   ?i <" + propURI + "> ?o. \n");
                queryBuffer.append("OPTIONAL{ ?i rdf:type ?d.}\n");
                queryBuffer.append("OPTIONAL{ ?o rdf:type ?r.}\n");
                queryBuffer.append("}");
                queryString = queryBuffer.toString();
                query = QueryFactory.create((String)queryString);
                qexec = null;
                results = null;
                try {
                    qexec = QueryExecutionFactory.sparqlService((String)this.endpointURI, (Query)query);
                    results = qexec.execSelect();
                    System.out.print(".");
                    if (true) ** GOTO lbl189
                }
                catch (Exception ex) {
                    System.out.println(queryString);
                    ex.printStackTrace();
                    throw ex;
                }
                do {
                    sol = results.next();
                    dom = sol.getResource("d");
                    ran = sol.getResource("r");
                    domURI = null;
                    if (dom != null) {
                        domURI = dom.getURI();
                    }
                    ranURI = null;
                    if (ran != null) {
                        ranURI = ran.getURI();
                    }
                    pdrd = new PropertyDomainRangeDecl(propURI, domURI, ranURI, 0, 0, 0, false, false);
                    propDomRanDeclList.add(pdrd);
lbl189:
                    // 2 sources

                } while (results.hasNext());
                qexec.close();
                for (PropertyDomainRangeDecl pdrd : propDomRanDeclList) {
                    queryBuffer = new StringBuffer();
                    queryBuffer.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
                    queryBuffer.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
                    queryBuffer.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
                    queryBuffer.append("SELECT (count(?i) AS ?numTriples) (count(DISTINCT ?i) AS ?numDomIns) (count(DISTINCT ?o) AS ?numRanIns)\n");
                    if (this.graphURIs != null && this.graphURIs.length != 0) {
                        pdrd = this.graphURIs;
                        ranURI = this.graphURIs.length;
                        domURI = 0;
                        while (domURI < ranURI) {
                            graphURI = pdrd[domURI];
                            queryBuffer.append("FROM <");
                            queryBuffer.append(graphURI);
                            queryBuffer.append(">\n");
                            ++domURI;
                        }
                    }
                    queryBuffer.append("WHERE{\n");
                    queryBuffer.append("   ?i <" + propURI + "> ?o. \n");
                    if (pdrd.getDomainClass() != null) {
                        queryBuffer.append(" ?i rdf:type <" + pdrd.getDomainClass() + ">.\n");
                    }
                    if (pdrd.getRangeClass() != null) {
                        queryBuffer.append(" ?o rdf:type <" + pdrd.getRangeClass() + ">.\n");
                    }
                    queryBuffer.append("}");
                    queryString = queryBuffer.toString();
                    query = QueryFactory.create((String)queryString);
                    qexec = null;
                    results = null;
                    try {
                        qexec = QueryExecutionFactory.sparqlService((String)this.endpointURI, (Query)query);
                        results = qexec.execSelect();
                        System.out.print(".");
                    }
                    catch (Exception ex) {
                        System.out.println(queryString);
                        ex.printStackTrace();
                        throw ex;
                    }
                    domList = new ArrayList<String>();
                    ranList = new ArrayList<Object>();
                    while (results.hasNext()) {
                        sol = results.next();
                        domURI = pdrd.getDomainClass();
                        if (domURI != null) {
                            domList.add(domURI);
                        }
                        if (domURI == null && domClassSet.size() > 0) {
                            it = domClassSet.iterator();
                            while (it.hasNext()) {
                                domList.add((String)it.next());
                            }
                        }
                        if ((ranURI /* !! */  = pdrd.getRangeClass()) != null) {
                            ranList.add(ranURI /* !! */ );
                        }
                        if (ranURI /* !! */  == null && ranClassSet.size() > 0) {
                            it = ranClassSet.iterator();
                            while (it.hasNext()) {
                                ranList.add((String)it.next());
                            }
                        }
                        lit = sol.getLiteral("numTriples");
                        numTriples = 0;
                        if (lit != null) {
                            numTriples = lit.getInt();
                        }
                        lit = sol.getLiteral("numDomIns");
                        numDomIns = 0;
                        if (lit != null) {
                            numDomIns = lit.getInt();
                        }
                        lit = sol.getLiteral("numRanIns");
                        numRanIns = 0;
                        if (lit != null) {
                            numRanIns = lit.getInt();
                        }
                        for (String domURIs : domList) {
                            for (String ranURIs : ranList) {
                                pdrd2 = new PropertyDomainRangeDecl(propURI, domURIs, ranURIs, numTriples, numDomIns, numRanIns, domURI == null, ranURI /* !! */  == null);
                                propDomRanDeclList2.add(pdrd2);
                            }
                        }
                    }
                    qexec.close();
                }
                numDomIns = 0;
                numRanIns = 0;
                numTriples = 0;
                queryBuffer = new StringBuffer();
                queryBuffer.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
                queryBuffer.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
                queryBuffer.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
                queryBuffer.append("SELECT (count(?i) AS ?numTriples) (count(DISTINCT ?i) AS ?numDomIns) (count(DISTINCT ?o) AS ?numRanIns)\n");
                if (this.graphURIs != null && this.graphURIs.length != 0) {
                    ranURI /* !! */  = this.graphURIs;
                    domURI = this.graphURIs.length;
                    sol = 0;
                    while (sol < domURI) {
                        graphURI = ranURI /* !! */ [sol];
                        queryBuffer.append("FROM <");
                        queryBuffer.append(graphURI);
                        queryBuffer.append(">\n");
                        ++sol;
                    }
                }
                queryBuffer.append("WHERE{\n");
                queryBuffer.append("   ?i <" + propURI + "> ?o. \n");
                queryBuffer.append("}");
                queryString = queryBuffer.toString();
                query = QueryFactory.create((String)queryString);
                qexec = null;
                results = null;
                try {
                    qexec = QueryExecutionFactory.sparqlService((String)this.endpointURI, (Query)query);
                    results = qexec.execSelect();
                    System.out.print(".");
                    if (true) ** GOTO lbl337
                }
                catch (Exception ex) {
                    System.out.println(queryString);
                    ex.printStackTrace();
                    throw ex;
                }
                do {
                    if ((lit = (sol = results.next()).getLiteral("numDomIns")) != null) {
                        numDomIns = lit.getInt();
                    }
                    if ((lit = sol.getLiteral("numRanIns")) != null) {
                        numRanIns = lit.getInt();
                    }
                    if ((lit = sol.getLiteral("numTriples")) == null) continue;
                    numTriples = lit.getInt();
lbl337:
                    // 3 sources

                } while (results.hasNext());
                qexec.close();
                numTriplesWithClass = 0;
                numDomInsWithClass = 0;
                numRanInsWithClass = 0;
                if (domClassSet.size() != 0 && ranClassSet.size() != 0) break block100;
                queryBuffer = new StringBuffer();
                queryBuffer.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
                queryBuffer.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
                queryBuffer.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
                queryBuffer.append("SELECT (count(DISTINCT ?i) AS ?numDomIns)\n");
                if (this.graphURIs != null && this.graphURIs.length != 0) {
                    numDomIns = this.graphURIs;
                    numTriples = this.graphURIs.length;
                    lit = 0;
                    while (lit < numTriples) {
                        graphURI = numDomIns[lit];
                        queryBuffer.append("FROM <");
                        queryBuffer.append(graphURI);
                        queryBuffer.append(">\n");
                        ++lit;
                    }
                }
                queryBuffer.append("WHERE{\n");
                queryBuffer.append("   ?i <" + propURI + "> ?o. \n");
                queryBuffer.append("   ?i rdf:type ?d. \n");
                queryBuffer.append("}");
                queryString = queryBuffer.toString();
                query = QueryFactory.create((String)queryString);
                qexec = null;
                results = null;
                try {
                    qexec = QueryExecutionFactory.sparqlService((String)this.endpointURI, (Query)query);
                    results = qexec.execSelect();
                    System.out.print(".");
                    if (true) ** GOTO lbl390
                }
                catch (Exception ex) {
                    System.out.println(queryString);
                    ex.printStackTrace();
                    throw ex;
                }
                do {
                    if ((lit = (sol = results.next()).getLiteral("numDomIns")) == null) continue;
                    numDomInsWithClass = lit.getInt();
lbl390:
                    // 3 sources

                } while (results.hasNext());
                qexec.close();
                queryBuffer = new StringBuffer();
                queryBuffer.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
                queryBuffer.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
                queryBuffer.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
                queryBuffer.append("SELECT (count(DISTINCT ?o) AS ?numRanIns)\n");
                if (this.graphURIs != null && this.graphURIs.length != 0) {
                    numDomIns = this.graphURIs;
                    numTriples = this.graphURIs.length;
                    lit = 0;
                    while (lit < numTriples) {
                        graphURI = numDomIns[lit];
                        queryBuffer.append("FROM <");
                        queryBuffer.append(graphURI);
                        queryBuffer.append(">\n");
                        ++lit;
                    }
                }
                queryBuffer.append("WHERE{\n");
                queryBuffer.append("   ?i <" + propURI + "> ?o. \n");
                queryBuffer.append("   ?o rdf:type ?r. \n");
                queryBuffer.append("}");
                queryString = queryBuffer.toString();
                query = QueryFactory.create((String)queryString);
                qexec = null;
                results = null;
                try {
                    qexec = QueryExecutionFactory.sparqlService((String)this.endpointURI, (Query)query);
                    results = qexec.execSelect();
                    System.out.print(".");
                    if (true) ** GOTO lbl439
                }
                catch (Exception ex) {
                    System.out.println(queryString);
                    ex.printStackTrace();
                    throw ex;
                }
                do {
                    if ((lit = (sol = results.next()).getLiteral("numRanIns")) == null) continue;
                    numRanInsWithClass = lit.getInt();
lbl439:
                    // 3 sources

                } while (results.hasNext());
                qexec.close();
                queryBuffer = new StringBuffer();
                queryBuffer.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
                queryBuffer.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
                queryBuffer.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
                queryBuffer.append("SELECT (count(?i) AS ?numTriples)\n");
                if (this.graphURIs != null && this.graphURIs.length != 0) {
                    numDomIns = this.graphURIs;
                    numTriples = this.graphURIs.length;
                    lit = 0;
                    while (lit < numTriples) {
                        graphURI = numDomIns[lit];
                        queryBuffer.append("FROM <");
                        queryBuffer.append(graphURI);
                        queryBuffer.append(">\n");
                        ++lit;
                    }
                }
                queryBuffer.append("WHERE{\n");
                queryBuffer.append("   ?i <" + propURI + "> ?o. \n");
                if (domClassSet.size() == 0) {
                    queryBuffer.append("   ?i rdf:type ?d. \n");
                }
                if (ranClassSet.size() == 0) {
                    queryBuffer.append("   ?o rdf:type ?r. \n");
                }
                queryBuffer.append("}");
                queryString = queryBuffer.toString();
                query = QueryFactory.create((String)queryString);
                qexec = null;
                results = null;
                try {
                    qexec = QueryExecutionFactory.sparqlService((String)this.endpointURI, (Query)query);
                    results = qexec.execSelect();
                    System.out.print(".");
                    if (true) ** GOTO lbl492
                }
                catch (Exception ex) {
                    System.out.println(queryString);
                    ex.printStackTrace();
                    throw ex;
                }
                do {
                    if ((lit = (sol = results.next()).getLiteral("numTriples")) == null) continue;
                    numTriplesWithClass = lit.getInt();
lbl492:
                    // 3 sources

                } while (results.hasNext());
                qexec.close();
            }
            labelList = new ArrayList<String>();
            queryBuffer = new StringBuffer();
            queryBuffer.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
            queryBuffer.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
            queryBuffer.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
            queryBuffer.append("SELECT ?label\n");
            if (this.graphURIs != null && this.graphURIs.length != 0) {
                numRanIns = this.graphURIs;
                numDomIns = this.graphURIs.length;
                numTriples = 0;
                while (numTriples < numDomIns) {
                    graphURI = numRanIns[numTriples];
                    queryBuffer.append("FROM <");
                    queryBuffer.append(graphURI);
                    queryBuffer.append(">\n");
                    ++numTriples;
                }
            }
            queryBuffer.append("WHERE{\n");
            queryBuffer.append("  <" + propURI + "> rdfs:label ?label. \n");
            queryBuffer.append("}");
            queryString = queryBuffer.toString();
            query = QueryFactory.create((String)queryString);
            qexec = null;
            results = null;
            try {
                qexec = QueryExecutionFactory.sparqlService((String)this.endpointURI, (Query)query);
                results = qexec.execSelect();
                System.out.print(".");
                if (true) ** GOTO lbl543
            }
            catch (Exception ex) {
                System.out.println(queryString);
                ex.printStackTrace();
                throw ex;
            }
            do {
                if ((lit = (sol = results.next()).getLiteral("label")) == null) continue;
                label = lit.getString();
                labelList.add(label);
lbl543:
                // 3 sources

            } while (results.hasNext());
            qexec.close();
            propCategory = 0;
            if (numTriples == 0) {
                propCategory = 4;
            } else if (domClassSet.size() == 0) {
                if (numDomIns - numDomInsWithClass == 0) {
                    propCategory = 2;
                } else if (numDomInsWithClass == 0) {
                    propCategory = 4;
                    numDomIns = 0;
                } else {
                    propCategory = 3;
                    numDomIns = numDomInsWithClass;
                }
            } else {
                propCategory = 1;
            }
            if (numTriples == 0) {
                propCategory = 4;
            } else if (ranClassSet.size() == 0) {
                if (numRanIns - numRanInsWithClass == 0) {
                    if (propCategory == 1) {
                        propCategory = 2;
                    }
                } else if (numRanInsWithClass == 0) {
                    propCategory = 4;
                    numRanIns = 0;
                } else {
                    propCategory = Math.max(propCategory, 3);
                    numRanIns = numRanInsWithClass;
                }
            }
            if (domClassSet.size() == 0 || ranClassSet.size() == 0) {
                numTriples = numTriplesWithClass;
            }
            if (wholePropertyCategory == 0) {
                wholePropertyCategory = propCategory;
            } else if (propCategory == 1) {
                if (wholePropertyCategory == 4) {
                    wholePropertyCategory = 3;
                }
            } else if (propCategory == 2) {
                if (wholePropertyCategory == 1) {
                    wholePropertyCategory = 2;
                } else if (wholePropertyCategory == 4) {
                    wholePropertyCategory = 3;
                }
            } else if (wholePropertyCategory == 1 || wholePropertyCategory == 2) {
                wholePropertyCategory = 3;
            }
            v0 = propCategory - 1;
            countProperties[v0] = countProperties[v0] + 1;
            pro = model.createProperty(propURI);
            for (String label : labelList) {
                pro.addLiteral(labelPro, (Object)label);
            }
            for (PropertyDomainRangeDecl pdrd : propDomRanDeclList) {
                classRelation = model.createResource(AnonId.create());
                classRelation.addProperty(typePro, (RDFNode)classRelationCls);
                classRelation.addProperty(startClsPro, (RDFNode)model.createResource(pdrd.getDomainClass()));
                classRelation.addProperty(endClsPro, (RDFNode)model.createResource(pdrd.getRangeClass()));
                classRelation.addProperty(propPro, (RDFNode)model.createProperty(pdrd.getProperty()));
                classRelation.addLiteral(numTriplePro, (long)pdrd.getNumTriples());
                classRelation.addLiteral(numStartClsNumInsPro, (long)pdrd.getNumDomainInstances());
                classRelation.addLiteral(numEndClsNumInsPro, (long)pdrd.getNumRangeInstances());
                classRelation.addLiteral(isDomClsLimPro, pdrd.isDomainClassLimitedQ());
                classRelation.addLiteral(isRanClsLimPro, pdrd.isRangeClassLimitedQ());
                classURISet.add(pdrd.getDomainClass());
                classURISet.add(pdrd.getRangeClass());
            }
            propProfile = model.createResource(AnonId.create());
            propProfile.addProperty(typePro, (RDFNode)propProfileCls);
            propProfile.addProperty(propPro, (RDFNode)pro);
            propProfile.addLiteral(indCatPro, (long)propCategory);
            for (String domURI : domClassSet) {
                dom = model.createResource(domURI);
                dom.addProperty(typePro, (RDFNode)clsCls);
                pro.addProperty(domainPro, (RDFNode)dom);
                classURISet.add(domURI);
            }
            for (String ranURI : ranClassSet) {
                ran = model.createResource(ranURI);
                ran.addProperty(typePro, (RDFNode)clsCls);
                pro.addProperty(rangePro, (RDFNode)ran);
                classURISet.add(ranURI);
            }
            propProfile.addLiteral(numDomClsNumInsPro, (long)numDomIns);
            propProfile.addLiteral(numRanClsNumInsPro, (long)numRanIns);
            propProfile.addLiteral(numTriplePro, (long)numTriples);
            totalNumTriples += numTriples;
            System.out.println(String.valueOf(propURI) + " (" + propCategory + ")(" + numTriples + ", " + numDomIns + ", " + numRanIns + ")");
            ++var26_28;
        }
        if (countProperties != null) {
            cnt = 1;
            var29_31 = countProperties;
            var28_26 = countProperties.length;
            var27_27 = 0;
            while (var27_27 < var28_26) {
                c = var29_31[var27_27];
                System.out.println("property[" + cnt + "]: " + c);
                ++cnt;
                ++var27_27;
            }
        }
        System.out.println("#Classes: " + classURISet.size());
        System.out.println("#Triples: " + totalNumTriples);
        return new Schema(model, wholePropertyCategory, countProperties, 0, 0, totalNumTriples, classURISet);
    }

    public RDFsCrawlerImpl(String endpointURI) {
        this.endpointURI = endpointURI;
    }

    public RDFsCrawlerImpl(String endpointURI, String[] graphURIs) {
        this.endpointURI = endpointURI;
        this.graphURIs = graphURIs;
    }

    public Model getPropertiesFromInstanceDecls() throws Exception {
        StringBuffer queryBuffer = new StringBuffer();
        queryBuffer.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
        queryBuffer.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
        queryBuffer.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
        queryBuffer.append("SELECT DISTINCT ?p ?d ?r \n");
        if (this.graphURIs != null && this.graphURIs.length != 0) {
            String[] stringArray = this.graphURIs;
            int n = this.graphURIs.length;
            int n2 = 0;
            while (n2 < n) {
                String graphURI = stringArray[n2];
                queryBuffer.append("FROM <");
                queryBuffer.append(graphURI);
                queryBuffer.append(">\n");
                ++n2;
            }
        }
        queryBuffer.append("WHERE{\n");
        queryBuffer.append("  ?i rdf:type ?d.\n");
        queryBuffer.append("  ?j rdf:type ?r.\n");
        queryBuffer.append("  ?i ?p ?j.\n");
        queryBuffer.append("}");
        String queryString = queryBuffer.toString();
        Query query = QueryFactory.create((String)queryString);
        QueryExecution qexec = null;
        ResultSet results = null;
        try {
            qexec = QueryExecutionFactory.sparqlService((String)this.endpointURI, (Query)query);
            results = qexec.execSelect();
            System.out.print(".");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        Model model = ModelFactory.createDefaultModel();
        Property domainPro = model.createProperty("http://www.w3.org/2000/01/rdf-schema#domain");
        Property rangePro = model.createProperty("http://www.w3.org/2000/01/rdf-schema#range");
        String[] filterStrs = new String[]{"http://www.openlinksw"};
        while (results.hasNext()) {
            QuerySolution sol = results.next();
            Resource pro = sol.getResource("p");
            Resource dom = sol.getResource("d");
            Resource ren = sol.getResource("r");
            if (pro == null || this.uriFilter(pro.getURI(), filterStrs) == null) continue;
            pro = model.createResource(pro);
            if (dom != null) {
                dom = model.createResource(dom);
                pro.addProperty(domainPro, (RDFNode)dom);
            }
            if (ren == null) continue;
            ren = model.createResource(ren);
            pro.addProperty(rangePro, (RDFNode)ren);
        }
        qexec.close();
        return model;
    }

    public Model getProperiesFromDomainRangeDecls() throws Exception {
        StringBuffer queryBuffer = new StringBuffer();
        queryBuffer.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
        queryBuffer.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
        queryBuffer.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
        queryBuffer.append("SELECT ?p ?d ?r \n");
        if (this.graphURIs != null && this.graphURIs.length != 0) {
            String[] stringArray = this.graphURIs;
            int n = this.graphURIs.length;
            int n2 = 0;
            while (n2 < n) {
                String graphURI = stringArray[n2];
                queryBuffer.append("FROM <");
                queryBuffer.append(graphURI);
                queryBuffer.append(">\n");
                ++n2;
            }
        }
        queryBuffer.append("WHERE{\n");
        queryBuffer.append("  ?p rdfs:domain ?d.\n");
        queryBuffer.append("  ?p rdfs:range ?r.\n");
        queryBuffer.append("}");
        String queryString = queryBuffer.toString();
        Query query = QueryFactory.create((String)queryString);
        QueryExecution qexec = null;
        ResultSet results = null;
        try {
            qexec = QueryExecutionFactory.sparqlService((String)this.endpointURI, (Query)query);
            results = qexec.execSelect();
            System.out.print(".");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        Model model = ModelFactory.createDefaultModel();
        Property domainPro = model.createProperty("http://www.w3.org/2000/01/rdf-schema#domain");
        Property rangePro = model.createProperty("http://www.w3.org/2000/01/rdf-schema#range");
        String[] filterStrs = new String[]{"http://www.openlinksw"};
        while (results.hasNext()) {
            QuerySolution sol = results.next();
            Resource pro = sol.getResource("p");
            Resource dom = sol.getResource("d");
            Resource ren = sol.getResource("r");
            if (pro == null || this.uriFilter(pro.getURI(), filterStrs) == null) continue;
            pro = model.createResource(pro);
            if (dom != null) {
                dom = model.createResource(dom);
                pro.addProperty(domainPro, (RDFNode)dom);
            }
            if (ren == null) continue;
            ren = model.createResource(ren);
            pro.addProperty(rangePro, (RDFNode)ren);
        }
        qexec.close();
        return model;
    }

    public String[] getDeclaredRDFsClasses() throws Exception {
        String[] filterStrs = new String[]{"http://www.openlinksw", "http://www.w3.org"};
        String[] lines = new String[]{"", "?c rdf:type rdfs:Class.", "[] rdf:type ?c.", "[] rdfs:domain ?c.", "[] rdfs:range ?c.", "?c rdfs:subclassOf [].", "[] rdfs:subclassOf ?c."};
        StringBuffer queryBuffer = new StringBuffer();
        int i = 1;
        while (i < lines.length) {
            if (i != 1) {
                queryBuffer.append(" UNION ");
            }
            queryBuffer.append("{");
            queryBuffer.append(lines[i]);
            queryBuffer.append("}\n");
            ++i;
        }
        lines[0] = queryBuffer.toString();
        HashSet<String> resultClassSet = new HashSet<String>();
        int i2 = 0;
        while (i2 < lines.length) {
            block9: {
                queryBuffer = new StringBuffer();
                queryBuffer.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
                queryBuffer.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
                queryBuffer.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
                queryBuffer.append("SELECT DISTINCT ?c  \n");
                if (this.graphURIs != null && this.graphURIs.length != 0) {
                    String[] stringArray = this.graphURIs;
                    int n = this.graphURIs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String graphURI = stringArray[n2];
                        queryBuffer.append("FROM <");
                        queryBuffer.append(graphURI);
                        queryBuffer.append(">\n");
                        ++n2;
                    }
                }
                queryBuffer.append("WHERE{\n");
                queryBuffer.append(lines[i2]);
                queryBuffer.append("}");
                String queryString = queryBuffer.toString();
                Query query = QueryFactory.create((String)queryString);
                QueryExecution qexec = null;
                ResultSet results = null;
                try {
                    qexec = QueryExecutionFactory.sparqlService((String)this.endpointURI, (Query)query);
                    results = qexec.execSelect();
                    System.out.print(".");
                    while (results.hasNext()) {
                        QuerySolution sol = results.next();
                        Resource res = sol.getResource("c");
                        if (res == null || this.uriFilter(res.getURI(), filterStrs) == null) continue;
                        resultClassSet.add(res.getURI());
                    }
                    qexec.close();
                    if (i2 == 0) {
                        break;
                    }
                }
                catch (Exception ex) {
                    qexec.close();
                    ex.printStackTrace();
                    if (i2 == 0) break block9;
                    throw ex;
                }
            }
            ++i2;
        }
        return resultClassSet.toArray(new String[0]);
    }

    public String[] getInferedRDFsClassesFromInstances() throws Exception {
        StringBuffer queryBuffer = new StringBuffer();
        queryBuffer.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
        queryBuffer.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
        queryBuffer.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
        queryBuffer.append("SELECT DISTINCT ?c  \n");
        if (this.graphURIs != null && this.graphURIs.length != 0) {
            String[] stringArray = this.graphURIs;
            int n = this.graphURIs.length;
            int n2 = 0;
            while (n2 < n) {
                String graphURI = stringArray[n2];
                queryBuffer.append("FROM <");
                queryBuffer.append(graphURI);
                queryBuffer.append(">\n");
                ++n2;
            }
        }
        queryBuffer.append("WHERE{\n  [] rdf:type ?c. \n");
        queryBuffer.append("}");
        String queryString = queryBuffer.toString();
        Query query = QueryFactory.create((String)queryString);
        QueryExecution qexec = null;
        ResultSet results = null;
        try {
            qexec = QueryExecutionFactory.sparqlService((String)this.endpointURI, (Query)query);
            results = qexec.execSelect();
            System.out.print(".");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        ArrayList<String> resultList = new ArrayList<String>();
        String[] filterStrs = new String[]{"http://www.openlinksw", "http://www.w3.org"};
        while (results.hasNext()) {
            QuerySolution sol = results.next();
            Resource res = sol.getResource("c");
            if (res == null || this.uriFilter(res.getURI(), filterStrs) == null) continue;
            resultList.add(res.getURI());
        }
        qexec.close();
        return resultList.toArray(new String[0]);
    }

    public String[] getRDFProperties() throws Exception {
        StringBuffer queryBuffer = new StringBuffer();
        queryBuffer.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
        queryBuffer.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
        queryBuffer.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
        queryBuffer.append("SELECT DISTINCT ?p  \n");
        if (this.graphURIs != null && this.graphURIs.length != 0) {
            String[] stringArray = this.graphURIs;
            int n = this.graphURIs.length;
            int n2 = 0;
            while (n2 < n) {
                String graphURI = stringArray[n2];
                queryBuffer.append("FROM <");
                queryBuffer.append(graphURI);
                queryBuffer.append(">\n");
                ++n2;
            }
        }
        queryBuffer.append("WHERE{\n");
        queryBuffer.append("{  ?s ?p ?o.}\n");
        queryBuffer.append("}");
        String queryString = queryBuffer.toString();
        Query query = QueryFactory.create((String)queryString);
        QueryExecution qexec = null;
        ResultSet results = null;
        try {
            qexec = QueryExecutionFactory.sparqlService((String)this.endpointURI, (Query)query);
            results = qexec.execSelect();
            System.out.print(".");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        ArrayList<String> resultList = new ArrayList<String>();
        String[] filterStrs = new String[]{"http://www.openlinksw", "http://www.w3.org/1999/02/22-rdf-syntax-ns", "http://www.w3.org/2000/01/rdf-schema", "http://www.w3.org/2002/07/owl", "http://www.w3.org/ns/sparql-service-description"};
        while (results.hasNext()) {
            QuerySolution sol = results.next();
            Resource res = sol.getResource("p");
            if (res == null || this.uriFilter(res.getURI(), filterStrs) == null) continue;
            resultList.add(res.getURI());
        }
        qexec.close();
        return resultList.toArray(new String[0]);
    }

    public String[] getDomainRangeDeclaredRDFProperties() throws Exception {
        StringBuffer queryBuffer = new StringBuffer();
        queryBuffer.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
        queryBuffer.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
        queryBuffer.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
        queryBuffer.append("SELECT DISTINCT ?p \n");
        if (this.graphURIs != null && this.graphURIs.length != 0) {
            String[] stringArray = this.graphURIs;
            int n = this.graphURIs.length;
            int n2 = 0;
            while (n2 < n) {
                String graphURI = stringArray[n2];
                queryBuffer.append("FROM <");
                queryBuffer.append(graphURI);
                queryBuffer.append(">\n");
                ++n2;
            }
        }
        queryBuffer.append("WHERE{\n");
        queryBuffer.append("  ?p rdfs:domain ?cs. \n");
        queryBuffer.append("  ?p rdfs:range ?co. \n");
        queryBuffer.append("}");
        String queryString = queryBuffer.toString();
        Query query = QueryFactory.create((String)queryString);
        QueryExecution qexec = null;
        ResultSet results = null;
        try {
            qexec = QueryExecutionFactory.sparqlService((String)this.endpointURI, (Query)query);
            results = qexec.execSelect();
            System.out.print(".");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        ArrayList<String> resultList = new ArrayList<String>();
        String[] filterStrs = new String[]{"http://www.openlinksw"};
        while (results.hasNext()) {
            QuerySolution sol = results.next();
            Resource res = sol.getResource("p");
            if (res == null || this.uriFilter(res.getURI(), filterStrs) == null) continue;
            resultList.add(res.getURI());
        }
        qexec.close();
        return resultList.toArray(new String[0]);
    }

    public String uriFilter(String uriStr, String[] filterStrs) throws Exception {
        if (filterStrs == null || filterStrs.length == 0) {
            return uriStr;
        }
        String[] stringArray = filterStrs;
        int n = filterStrs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (uriStr != null && uriStr.startsWith(str)) {
                return null;
            }
            ++n2;
        }
        return uriStr;
    }

    class PropertyDomainRangeDecl {
        String property = null;
        String domainClass = null;
        String rangeClass = null;
        int numTriples = 0;
        int numDomainInstances = 0;
        int numRangeInstances = 0;
        boolean domainClassLimitedQ = false;
        boolean rangeClassLimitedQ = false;

        public PropertyDomainRangeDecl(String property, String domainClass, String rangeClass, int numTriples, int numDomainInstances, int numRangeInstances, boolean domainClassLimitedQ, boolean rangeClassLimitedQ) {
            this.property = property;
            this.domainClass = domainClass;
            this.rangeClass = rangeClass;
            this.numTriples = numTriples;
            this.numDomainInstances = numDomainInstances;
            this.numRangeInstances = numRangeInstances;
            this.domainClassLimitedQ = domainClassLimitedQ;
            this.rangeClassLimitedQ = rangeClassLimitedQ;
        }

        public String getProperty() {
            return this.property;
        }

        public String getDomainClass() {
            return this.domainClass;
        }

        public String getRangeClass() {
            return this.rangeClass;
        }

        public final int getNumTriples() {
            return this.numTriples;
        }

        public final int getNumDomainInstances() {
            return this.numDomainInstances;
        }

        public final int getNumRangeInstances() {
            return this.numRangeInstances;
        }

        public final boolean isDomainClassLimitedQ() {
            return this.domainClassLimitedQ;
        }

        public final boolean isRangeClassLimitedQ() {
            return this.rangeClassLimitedQ;
        }
    }

    class ResourceNumberPair {
        public Resource resource = null;
        public int number = 0;

        ResourceNumberPair(Resource resource, int number) {
            this.resource = resource;
            this.number = number;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Schema {
        public Model model = null;
        public int propertyCategory = 0;
        public int classCategory = 0;
        public int[] countProperties;
        public int category = 0;
        public int numTriples = 0;
        public HashSet<String> inferedClasses;

        public Schema(Model model, int propertyCategory, int[] countProperties, int classCategory, int category, int numTriples, HashSet<String> inferedClasses) {
            this.model = model;
            this.propertyCategory = propertyCategory;
            this.countProperties = countProperties;
            this.classCategory = classCategory;
            this.category = category;
            this.numTriples = numTriples;
            this.inferedClasses = inferedClasses;
        }
    }
}

