/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.accc.db.sparql;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.io.File;
import java.io.FileWriter;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import jp.riken.accc.db.sparql.EndpointClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointClientImpl
implements EndpointClient {
    private URL endpointURL = null;
    private Model model;

    public EndpointClientImpl(URL endpointURL) {
        this.endpointURL = endpointURL;
    }

    public static void main(String[] args) throws Exception {
        EndpointClientImpl impl = new EndpointClientImpl(new URL("http://virtuoso-01.ad18.riken.go.jp:8890/sparql"));
        String uri = "http://bio2rdf.org/pubmed:11290940";
        Model resultModel = null;
        resultModel = impl.getInstanceTable(URI.create(uri));
        StringBuffer htmlStr = new StringBuffer();
        htmlStr.append("<html>\n\t<head>\n\t\t<title>");
        htmlStr.append(impl.getFilenameWithURIString(uri));
        htmlStr.append("</title>\n\t</head>\n\t<body>\n");
        htmlStr.append(impl.model2HTMLTable(resultModel, URI.create(uri)));
        htmlStr.append("\t</body>\n</html>");
        System.out.println(htmlStr.toString());
        System.out.println("\n\n\n\n-------------------------------------------------------------------------------\n\n\n\n");
        String classuri = "http://bio2rdf.org/pubmed_vocabulary:PubMedRecord";
        StringBuffer htmlStr2 = new StringBuffer();
        htmlStr2.append("<html>\n\t<head>\n\t\t<title>");
        htmlStr2.append(classuri);
        htmlStr2.append("</title>\n\t</head>\n\t<body>\n");
        htmlStr2.append(impl.makeClassTable(URI.create(classuri)));
        htmlStr2.append("\t</body>\n</html>");
        File htmlfile = new File("C:\\Users\\Lenz\\Desktop\\ClassInstanceTable.html");
        htmlfile.createNewFile();
        FileWriter fr = new FileWriter(htmlfile);
        fr.write(htmlStr2.toString());
        fr.close();
    }

    @Override
    public URI[] getGraphURIs() throws Exception {
        StringBuffer queryStr = new StringBuffer();
        queryStr.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
        queryStr.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
        queryStr.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
        queryStr.append("SELECT DISTINCT ?g\nWHERE {\nGRAPH ?g {\n?s ?p ?o }\n}");
        System.out.println(queryStr.toString());
        URI[] uriList = null;
        String var = "g";
        uriList = this.getURIs(queryStr.toString(), var);
        return uriList;
    }

    @Override
    public URI[] getClassURIs(URI[] graphURIs) throws Exception {
        StringBuffer queryStr = new StringBuffer();
        queryStr.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
        queryStr.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
        queryStr.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
        queryStr.append("SELECT DISTINCT ?cls \n");
        if (graphURIs != null) {
            URI[] uRIArray = graphURIs;
            int n = graphURIs.length;
            int n2 = 0;
            while (n2 < n) {
                URI graphURI = uRIArray[n2];
                queryStr.append("FROM <");
                queryStr.append(graphURI.toString());
                queryStr.append(">\n");
                ++n2;
            }
        }
        queryStr.append("WHERE{\n");
        queryStr.append("\t{ ?cls rdf:type rdfs:Class. }\n");
        queryStr.append("\tUNION\n");
        queryStr.append("\t{ ?cls rdf:type owl:Class. }\n");
        queryStr.append("\tUNION\n");
        queryStr.append("\t{ [] rdfs:type ?cls. }\n");
        queryStr.append("\tUNION\n");
        queryStr.append("\t{ [] rdfs:domain ?cls. }\n");
        queryStr.append("\tUNION\n");
        queryStr.append("\t{ [] rdfs:range ?cls. }\n");
        queryStr.append("\tUNION\n");
        queryStr.append("\t{ ?cls rdfs:subclassOf []. }\n");
        queryStr.append("\t?cls rdfs:label ?pLabel.\n");
        queryStr.append("}");
        System.out.println(queryStr.toString());
        URI[] uriList = null;
        String var = "cls";
        uriList = this.getURIs(queryStr.toString(), var);
        return uriList;
    }

    @Override
    public URI[] getClassURIs() throws Exception {
        return this.getClassURIs(null);
    }

    @Override
    public URI[] getURIs(String sparqlQuery, String var) throws Exception {
        Query query = QueryFactory.create((String)sparqlQuery);
        QueryExecution qexec = null;
        ResultSet results = null;
        try {
            long start = System.currentTimeMillis();
            qexec = QueryExecutionFactory.sparqlService((String)this.endpointURL.toString(), (Query)query);
            results = qexec.execSelect();
            long end = System.currentTimeMillis();
            System.out.println("EXEC TIME: " + (end - start));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        ArrayList<URI> uriList = new ArrayList<URI>();
        while (results.hasNext()) {
            QuerySolution sol = results.next();
            Resource res = sol.getResource(var);
            if (res == null) continue;
            String uri = res.getURI();
            uriList.add(URI.create(uri));
        }
        qexec.close();
        return uriList.toArray(new URI[0]);
    }

    @Override
    public Model getInstanceTable(URI subjectURI) throws Exception {
        String subjectURIStr = subjectURI.toString();
        String subjectStr = subjectURI.toString();
        if (subjectStr.startsWith("http://")) {
            subjectStr = "<" + subjectStr + ">";
        }
        StringBuffer queryStr = new StringBuffer();
        queryStr.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
        queryStr.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
        queryStr.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
        queryStr.append("SELECT DISTINCT ?p ?pres ?q ?qres ?pcls ?plabel ?rpcls ?rplabel ?rqcls ?rqlabel ?qcls ?qlabel \n");
        queryStr.append("WHERE{\n");
        queryStr.append("\t{ " + subjectStr + " ?p ?pres.\n");
        queryStr.append("\t\tOPTIONAL{\n");
        queryStr.append("\t\t\t?p rdf:type ?pcls.\n");
        queryStr.append("\t\t}\n");
        queryStr.append("\t\tOPTIONAL{\n");
        queryStr.append("\t\t\t?p rdfs:label ?plabel.\n");
        queryStr.append("\t\t}\n");
        queryStr.append("\t\tOPTIONAL{\n");
        queryStr.append("\t\t\t?pres rdf:type ?rpcls.\n");
        queryStr.append("\t\t}\n");
        queryStr.append("\t\tOPTIONAL{\n");
        queryStr.append("\t\t\t?pres rdfs:label ?rplabel.\n");
        queryStr.append("\t\t}\n");
        queryStr.append("\t}\n");
        queryStr.append("\n");
        queryStr.append("\tUNION\n");
        queryStr.append("\n");
        queryStr.append("\t{ ?qres ?q " + subjectStr + ".\n");
        queryStr.append("\t\tOPTIONAL{\n");
        queryStr.append("\t\t\t?qres rdf:type ?rqcls.\n");
        queryStr.append("\t\t}\n");
        queryStr.append("\t\tOPTIONAL{\n");
        queryStr.append("\t\t\t?qres rdfs:label ?rqlabel.\n");
        queryStr.append("\t\t}\n");
        queryStr.append("\t\tOPTIONAL{\n");
        queryStr.append("\t\t\t?q rdf:type ?qcls.\n");
        queryStr.append("\t\t}\n");
        queryStr.append("\t\tOPTIONAL{\n");
        queryStr.append("\t\t\t?q rdfs:label ?qlabel.\n");
        queryStr.append("\t\t}\n");
        queryStr.append("\t}\n");
        queryStr.append("}");
        System.out.println(queryStr.toString());
        Query query = QueryFactory.create((String)queryStr.toString());
        QueryExecution qexec = null;
        ResultSet results = null;
        try {
            long start = System.currentTimeMillis();
            qexec = QueryExecutionFactory.sparqlService((String)this.endpointURL.toString(), (Query)query);
            results = qexec.execSelect();
            long end = System.currentTimeMillis();
            System.out.println("EXEC TIME: " + (end - start));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        this.model = ModelFactory.createDefaultModel();
        Model queryResultModel = ModelFactory.createDefaultModel();
        Resource sub = this.model.createResource(subjectURIStr);
        Property proForward = null;
        Resource pres = null;
        Literal lpres = null;
        Resource pcls = null;
        Literal plabel = null;
        Resource rpcls = null;
        Literal rplabel = null;
        Property proReverse = null;
        Resource qres = null;
        Resource qcls = null;
        Literal qlabel = null;
        Resource rqcls = null;
        Literal rqlabel = null;
        while (results.hasNext()) {
            Statement st;
            QuerySolution sol = results.next();
            proForward = null;
            pres = null;
            lpres = null;
            pcls = null;
            plabel = null;
            rpcls = null;
            rplabel = null;
            proReverse = null;
            qres = null;
            qcls = null;
            qlabel = null;
            rqcls = null;
            rqlabel = null;
            if (sol.contains("p")) {
                proForward = this.model.createProperty(sol.getResource("p").toString());
            }
            if (sol.contains("pres")) {
                if (sol.get("pres").isResource()) {
                    pres = this.model.createResource(sol.getResource("pres").toString());
                } else {
                    lpres = this.model.createLiteral(sol.getLiteral("pres").toString());
                }
            }
            if (sol.contains("q")) {
                proReverse = this.model.createProperty(sol.getResource("q").toString());
            }
            if (sol.contains("qres")) {
                qres = this.model.createResource(sol.getResource("qres").toString());
            }
            if (sol.contains("pcls")) {
                pcls = this.model.createResource(sol.getResource("pcls").toString());
            }
            if (sol.contains("plabel")) {
                plabel = this.model.createLiteral(sol.getLiteral("plabel").toString());
            }
            if (sol.contains("rpcls")) {
                rpcls = this.model.createResource(sol.getResource("rpcls").toString());
            }
            if (sol.contains("rplabel")) {
                rplabel = this.model.createLiteral(sol.getLiteral("rplabel").toString());
            }
            if (sol.contains("rqcls")) {
                rqcls = this.model.createResource(sol.getResource("rqcls").toString());
            }
            if (sol.contains("rqlabel")) {
                rqlabel = this.model.createLiteral(sol.getLiteral("rqlabel").toString());
            }
            if (sol.contains("qcls")) {
                qcls = this.model.createResource(sol.getResource("qcls").toString());
            }
            if (sol.contains("qlabel")) {
                qlabel = this.model.createLiteral(sol.getLiteral("qlabel").toString());
            }
            if (proForward != null) {
                if (pres != null) {
                    st = this.model.createStatement(sub, proForward, (RDFNode)pres);
                    queryResultModel.add(st);
                } else {
                    st = this.model.createStatement(sub, proForward, (RDFNode)lpres);
                    queryResultModel.add(st);
                }
            }
            if (qres != null && proReverse != null) {
                st = this.model.createStatement(qres, proReverse, (RDFNode)sub);
                queryResultModel.add(st);
            }
            if (pcls != null) {
                st = this.model.createStatement((Resource)proForward, this.model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (RDFNode)pcls);
                queryResultModel.add(st);
            }
            if (plabel != null) {
                st = this.model.createStatement((Resource)proForward, this.model.createProperty("http://www.w3.org/2000/01/rdf-schema#label"), (RDFNode)plabel);
                queryResultModel.add(st);
            }
            if (rpcls != null && pres != null) {
                st = this.model.createStatement(pres, this.model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (RDFNode)rpcls);
                queryResultModel.add(st);
            }
            if (rplabel != null && pres != null) {
                st = this.model.createStatement(pres, this.model.createProperty("http://www.w3.org/2000/01/rdf-schema#label"), (RDFNode)rplabel);
                queryResultModel.add(st);
            }
            if (qcls != null) {
                st = this.model.createStatement((Resource)proReverse, this.model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (RDFNode)qcls);
                queryResultModel.add(st);
            }
            if (qlabel != null) {
                st = this.model.createStatement((Resource)proReverse, this.model.createProperty("http://www.w3.org/2000/01/rdf-schema#label"), (RDFNode)qlabel);
                queryResultModel.add(st);
            }
            if (rqcls != null) {
                st = this.model.createStatement(qres, this.model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (RDFNode)rqcls);
                queryResultModel.add(st);
            }
            if (rqlabel == null) continue;
            st = this.model.createStatement(qres, this.model.createProperty("http://www.w3.org/2000/01/rdf-schema#label"), (RDFNode)rqlabel);
            queryResultModel.add(st);
        }
        qexec.close();
        return queryResultModel;
    }

    @Override
    public String model2HTMLTable(Model modelGraph, URI subjectURI) throws Exception {
        RDFNode selectObject;
        Property selectProperty;
        StringBuffer tableStr = new StringBuffer();
        String append = "";
        Resource selectSubject = this.model.createResource(subjectURI.toString());
        StmtIterator selectInstanceLabel = modelGraph.listStatements(selectSubject, selectProperty = this.model.createProperty("http://www.w3.org/2000/01/rdf-schema#label"), selectObject = null);
        append = selectInstanceLabel.hasNext() ? "\t\t<h1><a href=\"" + subjectURI.toString() + "\">" + selectInstanceLabel.nextStatement().getObject().toString() + "</a></h1>\n" : "\t\t<h1><a href=\"" + subjectURI.toString() + "\">" + subjectURI.toString() + "</a></h1>\n";
        tableStr.append(append);
        tableStr.append("\t\t<table border=\"2\">\n");
        tableStr.append("\t\t\t<th>Property</th><th>Object</th>\n");
        selectProperty = null;
        StmtIterator selectBySubject = modelGraph.listStatements(selectSubject, selectProperty, selectObject);
        while (selectBySubject.hasNext()) {
            Statement st = selectBySubject.nextStatement();
            if (st.getPredicate().toString() == "http://www.w3.org/2000/01/rdf-schema#label") continue;
            tableStr.append("\t\t\t<tr><td>");
            append = "";
            selectSubject = this.model.createResource(st.getPredicate().toString());
            selectProperty = this.model.createProperty("http://www.w3.org/2000/01/rdf-schema#label");
            selectObject = null;
            StmtIterator selectPredicateLabel = modelGraph.listStatements(selectSubject, selectProperty, selectObject);
            append = selectPredicateLabel.hasNext() ? "<a href=\"" + st.getPredicate().toString() + "\">" + this.getFilenameWithURIString(selectPredicateLabel.nextStatement().getObject().toString()) + "</a>" : "<a href=\"" + st.getPredicate().toString() + "\">" + this.getFilenameWithURIString(st.getPredicate().toString()) + "</a>";
            selectProperty = this.model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
            StmtIterator selectPredicateClass = modelGraph.listStatements(selectSubject, selectProperty, selectObject);
            if (selectPredicateClass.hasNext()) {
                String classURI = selectPredicateClass.nextStatement().getObject().toString();
                append = String.valueOf(append) + "<br>Class:<a href=\"" + classURI + "\">" + this.getFilenameWithURIString(classURI) + "</a>";
            }
            tableStr.append(String.valueOf(append) + "</td><td>");
            append = "";
            if (st.getObject().isResource()) {
                selectSubject = this.model.createResource(st.getObject().toString());
                StmtIterator selectObjectLabel = modelGraph.listStatements(selectSubject, selectProperty = this.model.createProperty("http://www.w3.org/2000/01/rdf-schema#label"), selectObject = null);
                append = selectObjectLabel.hasNext() ? "<a href=\"" + st.getObject().toString() + "\">" + this.getFilenameWithURIString(selectObjectLabel.nextStatement().getObject().toString()) + "</a>" : "<a href=\"" + st.getObject().toString() + "\">" + this.getFilenameWithURIString(st.getObject().toString()) + "</a>";
                selectProperty = this.model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
                StmtIterator selectObjectClass = modelGraph.listStatements(selectSubject, selectProperty, selectObject);
                if (selectObjectClass.hasNext()) {
                    String classURI = selectObjectClass.nextStatement().getObject().toString();
                    append = String.valueOf(append) + "<br>Class:<a href=\"" + classURI + "\">" + this.getFilenameWithURIString(classURI) + "</a>";
                }
            } else {
                append = st.getObject().toString();
            }
            tableStr.append(String.valueOf(append) + "</td></tr>\n");
        }
        tableStr.append("\t\t</table>\n");
        return tableStr.toString();
    }

    @Override
    public String getFilenameWithURIString(String baseURI) throws Exception {
        String[] splitStr = baseURI.split("/", 0);
        String filename = splitStr[splitStr.length - 1];
        splitStr = filename.split("#", 0);
        filename = splitStr[splitStr.length - 1];
        return filename;
    }

    @Override
    public String makeClassTable(URI classURI) throws Exception {
        Model classModel = this.getInstanceWithClassURI(classURI);
        ArrayList<String> instanceList = this.getInstanceList(classModel);
        ArrayList<String> propertyList = this.getInstancePropertyList(classModel);
        ArrayList<String> labelList = this.getInstancePropertyLabelList(classModel, propertyList);
        StringBuffer tableStr = new StringBuffer();
        tableStr.append("<table border=\"2\"><tr>");
        tableStr.append("<th>Instance</th>");
        int i = 0;
        while (i < propertyList.size()) {
            tableStr.append("<th><a href=\"" + propertyList.get(i) + "\">" + labelList.get(i) + "</a></th>");
            ++i;
        }
        tableStr.append("</tr>");
        RDFNode selectObject = null;
        int i2 = 0;
        while (i2 < instanceList.size()) {
            String instance = instanceList.get(i2);
            tableStr.append("<tr>");
            tableStr.append("<td>" + instance + "</td>");
            int j = 0;
            while (j < propertyList.size()) {
                Resource selectSubject = this.model.createResource(instance);
                Property selectProperty = this.model.createProperty(propertyList.get(j));
                tableStr.append("<td>");
                StmtIterator selectInstance = classModel.listStatements(selectSubject, selectProperty, selectObject);
                if (selectInstance.hasNext()) {
                    tableStr.append(((Statement)selectInstance.next()).getObject().toString());
                }
                tableStr.append("</td>");
                ++j;
            }
            tableStr.append("</tr>");
            ++i2;
        }
        tableStr.append("</table>");
        return tableStr.toString();
    }

    @Override
    public Model getInstanceWithClassURI(URI classURI) throws Exception {
        String classStr = classURI.toString();
        if (classStr.startsWith("http://")) {
            classStr = "<" + classStr + ">";
        }
        StringBuffer queryStr = new StringBuffer();
        queryStr.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
        queryStr.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
        queryStr.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
        queryStr.append("SELECT DISTINCT ?ins ?insp ?inso ?insl \n");
        queryStr.append("WHERE{\n");
        queryStr.append("\t{ ?ins rdf:type " + classStr + ".\n");
        queryStr.append("\t\tOPTIONAL{\n");
        queryStr.append("\t\t\t?ins ?insp ?inso.\n");
        queryStr.append("\t\t}\n");
        queryStr.append("\t\tOPTIONAL{\n");
        queryStr.append("\t\t\t?insp rdfs:label ?insl.\n");
        queryStr.append("\t\t}\n");
        queryStr.append("\t}\n");
        queryStr.append("}");
        System.out.println(queryStr.toString());
        Query query = QueryFactory.create((String)queryStr.toString());
        QueryExecution qexec = null;
        ResultSet results = null;
        try {
            long start = System.currentTimeMillis();
            qexec = QueryExecutionFactory.sparqlService((String)this.endpointURL.toString(), (Query)query);
            results = qexec.execSelect();
            long end = System.currentTimeMillis();
            System.out.println("EXEC TIME: " + (end - start));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        this.model = ModelFactory.createDefaultModel();
        Model queryResultModel = ModelFactory.createDefaultModel();
        Resource ins = null;
        Property insp = null;
        Resource rinso = null;
        Literal linso = null;
        Literal insl = null;
        while (results.hasNext()) {
            QuerySolution sol = results.next();
            ins = null;
            insp = null;
            rinso = null;
            linso = null;
            if (sol.contains("ins")) {
                ins = this.model.createResource(sol.getResource("ins").toString());
            }
            if (sol.contains("insp")) {
                insp = this.model.createProperty(sol.getResource("insp").toString());
            }
            if (sol.contains("inso")) {
                if (sol.get("inso").isResource()) {
                    rinso = this.model.createResource(sol.getResource("inso").toString());
                } else {
                    linso = this.model.createLiteral(sol.getLiteral("inso").toString());
                }
            }
            if (sol.contains("insl")) {
                insl = this.model.createLiteral(sol.getLiteral("insl").toString());
            }
            if (ins == null) continue;
            Statement st = this.model.createStatement(ins, this.model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (RDFNode)this.model.createResource(classURI.toString()));
            queryResultModel.add(st);
            if (insp != null) {
                if (rinso != null) {
                    st = this.model.createStatement(ins, insp, (RDFNode)rinso);
                    queryResultModel.add(st);
                }
                if (linso != null) {
                    st = this.model.createLiteralStatement(ins, insp, (Object)linso);
                    queryResultModel.add(st);
                }
            }
            if (insl == null) continue;
            st = this.model.createLiteralStatement((Resource)insp, this.model.createProperty("http://www.w3.org/2000/01/rdf-schema#label"), (Object)insl);
        }
        qexec.close();
        return queryResultModel;
    }

    @Override
    public ArrayList<String> getInstanceList(Model modelGraph) throws Exception {
        ArrayList<String> insList = new ArrayList<String>();
        Resource selectSubject = null;
        Property selectProperty = this.model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        RDFNode selectObject = null;
        StmtIterator selectInstance = modelGraph.listStatements(selectSubject, selectProperty, selectObject);
        String next = "";
        while (selectInstance.hasNext()) {
            next = selectInstance.nextStatement().getSubject().toString();
            if (insList.indexOf(next) != -1) continue;
            insList.add(next);
        }
        return insList;
    }

    @Override
    public ArrayList<String> getInstancePropertyList(Model modelGraph) throws Exception {
        ArrayList<String> proList = new ArrayList<String>();
        StmtIterator selectInstanceProperty = modelGraph.listStatements();
        String next = "";
        while (selectInstanceProperty.hasNext()) {
            next = selectInstanceProperty.nextStatement().getPredicate().toString();
            if (proList.indexOf(next) != -1 || next.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) continue;
            proList.add(next);
        }
        return proList;
    }

    @Override
    public ArrayList<String> getInstancePropertyLabelList(Model modelGraph, ArrayList<String> proList) throws Exception {
        ArrayList<String> labelList = new ArrayList<String>();
        Resource selectSubject = null;
        Property selectProperty = this.model.createProperty("http://www.w3.org/2000/01/rdf-schema#label");
        RDFNode selectObject = null;
        int i = 0;
        while (i < proList.size()) {
            selectSubject = this.model.createResource(proList.get(i));
            StmtIterator selectLabel = modelGraph.listStatements(selectSubject, selectProperty, selectObject);
            if (selectLabel.hasNext()) {
                labelList.add(selectLabel.nextStatement().getObject().toString());
            } else {
                labelList.add(this.getFilenameWithURIString(proList.get(i)));
            }
            ++i;
        }
        return labelList;
    }
}

