/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.accc.db.rdf.virtuoso;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import jp.riken.accc.db.rdf.virtuoso.ISQLManager;
import org.apache.jena.iri.IRI;

public class RDFDataUploader {
    private ISQLManager iSQLManager = null;
    private String baseIRIStr = "";

    public int upload(String reference) throws Exception {
        return 0;
    }

    private File[] reference2FileList(String reference) throws Exception {
        File refFile = new File(reference);
        if (!refFile.exists()) {
            throw new Exception("File/Directory not found: " + reference);
        }
        if (refFile.isDirectory()) {
            File[] files = refFile.listFiles();
            ArrayList<File> fileList = new ArrayList<File>();
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.exists() && file.isFile()) {
                    fileList.add(file);
                }
                ++n2;
            }
            return fileList.toArray(new File[0]);
        }
        if (refFile.isFile()) {
            return new File[]{refFile};
        }
        throw new Exception("File Internal Error: " + reference);
    }

    public String upload_NTriple(String reference, IRI graphMetadataIRI) throws Exception {
        File[] fileList = this.reference2FileList(reference);
        return this.addGraph(fileList, "NT", graphMetadataIRI);
    }

    public String addGraph(File[] localDataFiles, String format, IRI graphMetadataIRI) throws Exception {
        String command = this.iSQLManager.getCommandString();
        String pre = null;
        String pro = null;
        if (format.equalsIgnoreCase("RDF/XML")) {
            pre = "DB.DBA.RDF_LOAD_RDFXML_MT(file_to_string_output('";
            pro = "'),'" + this.baseIRIStr + "','" + graphMetadataIRI + "');";
        } else if (format.equalsIgnoreCase("TTL")) {
            pre = "DB.DBA.TTLP_MT(file_to_string_output('";
            pro = "'),'" + this.baseIRIStr + "','" + graphMetadataIRI + "', 255);";
        } else if (format.equalsIgnoreCase("NT")) {
            pre = "DB.DBA.RDF_LOAD_RDFXML_MT(file_to_string_output('";
            pro = "'),'" + this.baseIRIStr + ",''" + graphMetadataIRI + "', 255);";
        } else if (format.equalsIgnoreCase("NQ")) {
            pre = "DB.DBA.RDF_LOAD_RDFXML_MT(file_to_string_output('";
            pro = "'),'" + this.baseIRIStr + "','" + graphMetadataIRI + "', 512);";
        } else {
            throw new Exception("Illegal format: " + format);
        }
        String param1 = "checkpoint;";
        String param2 = "exit;";
        StringBuffer resultSB = new StringBuffer();
        File[] fileArray = localDataFiles;
        int n = localDataFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String buf;
            BufferedReader br;
            ByteArrayInputStream is;
            File file;
            File destinationFile = file = fileArray[n2];
            String filePath = destinationFile.getCanonicalPath();
            int pos = -1;
            pos = filePath.indexOf(":");
            if (pos >= 0) {
                filePath = filePath.substring(pos + 1);
            }
            filePath = filePath.replaceAll("\\\\", "/");
            System.out.println("DataFile: " + filePath);
            String param = String.valueOf(pre) + filePath + pro;
            String[] params = new String[]{param, param1, param2};
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(os);
            ByteArrayOutputStream errOS = new ByteArrayOutputStream();
            PrintWriter errPW = new PrintWriter(errOS);
            System.out.println("ADDGraphExecute: " + param);
            if (errOS.size() != 0) {
                is = new ByteArrayInputStream(errOS.toByteArray());
                br = new BufferedReader(new InputStreamReader(is));
                buf = null;
                StringBuffer errorSB = new StringBuffer();
                while ((buf = br.readLine()) != null) {
                    buf = buf.trim();
                    errorSB.append(buf);
                }
                throw new Exception(errorSB.toString());
            }
            is = new ByteArrayInputStream(os.toByteArray());
            br = new BufferedReader(new InputStreamReader(is));
            buf = null;
            while ((buf = br.readLine()) != null) {
                buf = buf.trim();
                resultSB.append(buf);
                resultSB.append("\n");
            }
            System.out.println("ADDGraphExecute done.");
            ++n2;
        }
        return resultSB.toString();
    }
}

