package org.biohackathon.SPARQLBuilder.OWL;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import jp.riken.accc.db.rdf.crawler.dataStructure.sparql.JenaModelGenerator;

public class RDFSchemaAnalyzerFactory {

	private Map<String, String> acquiredRDFFiles = null;
        private static final String FILENAME = "C:\\cdata";
        
        public RDFSchemaAnalyzerFactory(String fileName){
            try{
                setAcqiredRDFFiles(new File(fileName));
            }catch(Exception e){
                System.err.println(e);
            }
        }

        public RDFSchemaAnalyzerFactory(){
            try{
                setAcqiredRDFFiles(new File(FILENAME));
            }catch(Exception e){
                System.err.println(e);
            }
        }

	private void setAcqiredRDFFiles(String dirFile) throws Exception{
		setAcqiredRDFFiles(new File(dirFile));
	}
	
	private void setAcqiredRDFFiles(File data) throws Exception{
		StructureCrawler sc = new StructureCrawler(data);
		acquiredRDFFiles = sc.getAcquiredStructureFiles();
	}

	public String[] getEndpointURIList(){
		if( acquiredRDFFiles == null ){
			return new String[0];
		}else{
			return acquiredRDFFiles.keySet().toArray(new String[0]);
		}
	}
	
	public RDFSchemaAnalyzer create(String uri) throws Exception{
		if( acquiredRDFFiles == null || !acquiredRDFFiles.containsKey(uri)){
			return new EndpointAnalyzer(uri);
		}else{
			JenaModelGenerator jmGene = new JenaModelGenerator(acquiredRDFFiles.get(uri));
			return new AcquiredStructureAnalyzer(jmGene.getEndpointURI(), jmGene.getGraphURIs(), jmGene.getModel());
		}
	}
}
