package jp.riken.accc.db.rdf.jena.test;


import java.io.File;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sdb.SDBFactory;
import com.hp.hpl.jena.sdb.Store;
import com.hp.hpl.jena.sdb.StoreDesc;
import com.hp.hpl.jena.sdb.sql.JDBC;
import com.hp.hpl.jena.sdb.sql.SDBConnection;
import com.hp.hpl.jena.sdb.store.DatabaseType;
import com.hp.hpl.jena.sdb.store.LayoutType;
import com.hp.hpl.jena.util.PrintUtil;

public class ModelTester {

	static public void main(String[] args) throws Exception{

		String rdfFile = "c:/Temp/pubmed12n0684.xml.gz.nt";
		Model model = null;
		model = createModelOnMemory();
//		model = createModelOnFileSystem("C:/temp");
		
		model.read(rdfFile);
		System.out.println("Size: " + model.size());
//		printStatements(model, null, null, null);
		
		
	}
	
	
	
	static public Model createModelOnMemory() throws Exception {
		return ModelFactory.createDefaultModel();
	}
		

	static public Model createModelOnFileSystem(String fileName) throws Exception{
		ModelMaker modelMaker = ModelFactory.createFileModelMaker(fileName);
		return modelMaker.createFreshModel();
	}

	
	static public Model createModelOnMySQL(String db_url, String db_user, String db_passwd) throws Exception{
		StoreDesc storeDesc = new StoreDesc(LayoutType.LayoutTripleNodesHash, DatabaseType.MySQL);
	    // load database driver
	    try {
	        JDBC.loadDriverMySQL();
	        System.out.println("JDBC driver load successfully!");
	    } catch (Exception e) {
	        e.printStackTrace();
	    }
	    // create SDBConnection
	    SDBConnection sdbConnection = new SDBConnection(db_url, db_user,db_passwd);
	    // connect to store
	    Store store = SDBFactory.connectStore(sdbConnection,storeDesc);
	    // connect store to dataset
	    Dataset dataset = SDBFactory.connectDataset(store);
	    return dataset.getDefaultModel();
	}
	
	
	private static void printStatements(Model m, Resource s, Property p, Resource o) {
		int cnt = 0;
		for (StmtIterator iter = m.listStatements(s, p, o); iter.hasNext();) {
			Statement stmt = iter.next();
			System.out.println(" - " + PrintUtil.print(stmt));
			cnt++;
		}
		System.out.println(cnt + " statements");
	}
}
