package jp.riken.accc.db.sparql;

import java.net.URI;
import java.util.ArrayList;

import com.hp.hpl.jena.rdf.model.Model;

public interface EndpointClient {

	public URI[] getGraphURIs() throws Exception;

	public URI[] getClassURIs(URI[] graphURIs) throws Exception;

	public URI[] getClassURIs() throws Exception;

	URI[] getURIs(String sparqlQuery, String var) throws Exception;

	public Model getInstanceTable(URI subjectURI) throws Exception;

	public String makeClassTable(URI classURI) throws Exception;

	public Model getInstanceWithClassURI(URI classURI) throws Exception;

	public ArrayList<String> getInstanceList(Model modelGraph) throws Exception;

	public ArrayList<String> getInstancePropertyList(Model modelGraph) throws Exception;

	public ArrayList<String> getInstancePropertyLabelList(Model modelGraph, ArrayList<String>proList) throws Exception;

	public String model2HTMLTable(Model modelGraph, URI subjectURI) throws Exception;

	public String getFilenameWithURIString(String baseURI) throws Exception;

}
