package jp.riken.accc.db.rdf.crawler.dataStructure.sparql;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;

import jp.riken.accc.db.rdf.crawler.dataStructure.SchemaCategory;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.AnonId;
//import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
//import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;

public class RDFsCrawlerImpl implements RDFsCrawler {

	String endpointURI = null;
	String[] graphURIs = null;

	String[] graphURIFilter = { "http://www.openlinksw.com/",
			"http://www.w3.org/" };

	public static void main(String[] args) throws Exception {

//		String endPURI = "http://www.ebi.ac.uk/rdf/services/chembl/sparql";
//		 String endPURI = "http://www.ebi.ac.uk/rdf/services/reactome/sparql";
		String endPURI = "http://www.ebi.ac.uk/rdf/services/biomodels/sparql";
//		String endPURI = "http://www.ebi.ac.uk/rdf/services/biosamples/sparql";
//		String endPURI = "http://www.ebi.ac.uk/rdf/services/atlas/sparql";		
//		String endPURI = "http://dbe-rdf.biosciencedbc.jp/sparql";
//		 String endPURI = "http://lsd.dbcls.jp/sparql";
//		String endPURI = "http://data.allie.dbcls.jp/sparql";

		long start = System.currentTimeMillis();
		RDFsCrawlerImpl impl = new RDFsCrawlerImpl(endPURI);
		// graphlist
		String[] graphURIs = impl.getGraphURIs();
		impl.setGraphURIs(graphURIs);

		System.out.println("SPARQL Endpoint: " + endPURI);
		for (String graphURI : graphURIs) {
			System.out.println("graph: " + graphURI);
		}

		SchemaCategory schema = impl.determineSchemaCategory();

		// RDF/XML, RDF/XML-ABBREV, N-TRIPLE, N3, Turtle
		schema.write2File("c:/temp/test.xml", "RDF/XML-ABBREV");
		schema.write2File("c:/temp/test.ttl", "Turtle");
		System.out.println("Category:" + schema.category);
		long end = System.currentTimeMillis();
		System.out.println((end - start) + " msec.");
	}

	public void setGraphURIs(String[] graphURIs) {
		this.graphURIs = graphURIs;
	}

	public String[] getGraphURIs() throws Exception {
		StringBuffer queryBuffer = new StringBuffer();
		queryBuffer.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
		queryBuffer
				.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
		queryBuffer
				.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
		queryBuffer.append("SELECT DISTINCT ?g\n");
		queryBuffer.append("WHERE{\n");
		queryBuffer.append(" GRAPH ?g{ ?s ?p ?o.}\n");
		queryBuffer.append("}");

		String queryString = queryBuffer.toString();

		// System.out.println(queryString);

		Query query = QueryFactory.create(queryString);

		QueryExecution qexec = null;
		ResultSet results = null;
		
		try {
			// long start = System.currentTimeMillis();
			qexec = QueryExecutionFactory.sparqlService(endpointURI, query);
			results = qexec.execSelect();
			// long end = System.currentTimeMillis();
			// System.out.println("EXEC TIME: " + (end - start));
		} catch (Exception ex) {
			ex.printStackTrace();
			throw ex;
		}

		// results
		ArrayList<String> graphList = new ArrayList<String>();
		for (; results.hasNext();) {
			QuerySolution sol = results.next();
			// label
			Resource graph = sol.getResource("g");
			if (uriFilter(graph.getURI(), graphURIFilter) != null) {
				graphList.add(graph.getURI());
			}
		}
		qexec.close();

		return graphList.toArray(new String[0]);
	}

	int endpointAccessCount = 0;

	public SchemaCategory determineSchemaCategory() throws Exception {
		Date start = new Date();
		endpointAccessCount = 0;
		String[] res1 = getRDFProperties();

//		String[] res1 = new String[]{"http://www.biopax.org/release/biopax-level3.owl#id"};
		
		
		String[] datatypes = getDatatypes(res1);
		String[] res3 = getDeclaredRDFsClasses();
		HashSet<String> datatypeSet = new HashSet<String>();
		for( String datatype: datatypes){
			datatypeSet.add(datatype);
		}
		ArrayList<String> tmpStrList = new ArrayList<String>();
		for(String uri: res3){
			if( !datatypeSet.contains(uri)){
				tmpStrList.add(uri);
			}
		}
		res3 = tmpStrList.toArray(new String[0]);
		
		System.out.println("\n#Datatype(total): " + datatypes.length);
		System.out.println("#Class(total): " + res3.length);
		System.out.println("#Property(total): " + res1.length);

		Model model = null;
		model = ModelFactory.createDefaultModel();
		Property endpointPro = model
				.createProperty("http://www.w3.org/ns/sparql-service-description#endpoint");
		Resource serviceRes = model
				.createResource("http://www.w3.org/ns/sparql-service-description#Service");
		Resource endpointRes = model.createResource(endpointURI);
		Property typePro = model
				.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
		Resource thisRes = model.createResource("");
		thisRes.addProperty(typePro, serviceRes);
		thisRes.addProperty(endpointPro, endpointRes);
		Schema schema = null;
		if (res1.length != 0 && res3.length != 0) {
			schema = getPropertySchema(model, res1, datatypeSet);
			if (schema.propertyCategory == 4) {
				schema.classCategory = 4;
			} else {
				schema = getClassSchema(schema, res3);
			}
		} else {
			schema = new Schema(model, 4, null, 3, 4, 0, null);
		}
		model = schema.model;
		int category = 0;
		if (schema.propertyCategory == 1 && schema.classCategory == 1) {
			category = 1;
		} else {
			if (schema.propertyCategory == 2 && schema.classCategory == 1) {
				category = 2;
			} else {
				if (schema.propertyCategory == 4 || schema.classCategory == 3) {
					category = 4;
				} else {
					category = 3;
				}
			}
		}

		Resource endP = model.createResource(endpointURI);
		Property catPro = model
				.createProperty("http://sparqlbuilder.org/schemaCategory");
		endP.addLiteral(catPro, schema.category);
		Property clsCatPro = model
				.createProperty("http://sparqlbuilder.org/classCategory");
		endP.addLiteral(clsCatPro, schema.category);
		Property proCatPro = model
				.createProperty("http://sparqlbuilder.org/propertyCategory");
		endP.addLiteral(proCatPro, schema.category);
		Property numTriplesPro = model
				.createProperty("http://sparqlbuilder.org/numberOfTriples");
		endP.addLiteral(numTriplesPro, schema.numTriples);
		Property crawlStartTimePro = model
				.createProperty("http://sparqlbuilder.org/crawlStartTime");
		endP.addLiteral(crawlStartTimePro, start);
		Property crawlEndTimePro = model
				.createProperty("http://sparqlbuilder.org/crawlEndTime");
		endP.addLiteral(crawlEndTimePro, new Date());

		if (graphURIs != null && graphURIs.length != 0) {
			Property hasGraphPro = model
					.createProperty("http://sparqlbuilder.org/hasGraph");
			for (String graphURI : graphURIs) {
				Resource graph = model.createResource(graphURI);
				endP.addProperty(hasGraphPro, graph);
			}
		}
		System.out.println("#EndpointAccess: " + endpointAccessCount);
		
		return new SchemaCategory(category, model);
	}

	
	
	
	public Schema getClassSchema(Schema schema, String[] classURIs)
			throws Exception {
		String[] filterStrs = { "http://www.openlinksw", "http://www.w3.org" };
//		String[] unfilterStrs = { "http://www.w3.org" };

		HashSet<String> inferedClasses = schema.inferedClasses;
		int classCategory = 1;
		int cnt = 0;
		for (String classURI : classURIs) {
			if (inferedClasses.contains(classURI)) {
				cnt++;
			}
		}
		if (cnt == inferedClasses.size()) {
			classCategory = 1;
		} else {
			if (cnt == 0) {
				classCategory = 3;
			} else {
				classCategory = 2;
			}
		}

		Model model = schema.model;
		// create model
		Property typePro = model
				.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
		Property labelPro = model
				.createProperty("http://www.w3.org/2000/01/rdf-schema#label");
		Resource clsCls = model
				.createResource("http://www.w3.org/2000/01/rdf-schema#Class");
		// count instances
		Property numInstancePro = model
				.createProperty("http://sparqlbuilder.org/numberOfInstances");
		ArrayList<Resource> classList = new ArrayList<Resource>();

		// for each class, obtains its labels
		for (String clsURI : inferedClasses) {
			Resource cls = model.createResource(clsURI);
			cls.addProperty(typePro, clsCls);
			classList.add(cls);

			StringBuffer queryBuffer = new StringBuffer();
			queryBuffer
					.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
			queryBuffer
					.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
			queryBuffer
					.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
			queryBuffer.append("SELECT DISTINCT ?label\n");
			if (graphURIs != null && graphURIs.length != 0) {
				for (String graphURI : graphURIs) {
					queryBuffer.append("FROM <");
					queryBuffer.append(graphURI);
					queryBuffer.append(">\n");
				}
			}
			queryBuffer.append("WHERE{\n");
			queryBuffer.append("  <" + clsURI + "> rdfs:label ?label.\n");
			queryBuffer.append("}");

			String queryString = queryBuffer.toString();

			// System.out.println(queryString);

			Query query = QueryFactory.create(queryString);

			QueryExecution qexec = null;
			ResultSet results = null;
			try {
				// long start = System.currentTimeMillis();
				qexec = QueryExecutionFactory.sparqlService(endpointURI, query);
				endpointAccessCount++;
				results = qexec.execSelect();
				// long end = System.currentTimeMillis();
				// System.out.println("EXEC TIME: " + (end - start));
				System.out.print(".");
			} catch (Exception ex) {
				ex.printStackTrace();
				System.out.println(queryString);
				throw ex;
			}

			for (; results.hasNext();) {
				QuerySolution sol = results.next();
				// label
				Literal labelLiteral = sol.getLiteral("label");
				if (labelLiteral != null) {
					String label = labelLiteral.getString();
					cls.addLiteral(labelPro, label);
				}
			}
			qexec.close();

			queryBuffer = new StringBuffer();
			queryBuffer
					.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
			queryBuffer
					.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
			queryBuffer
					.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
			queryBuffer.append("SELECT (count(DISTINCT ?i)  AS ?num) \n");
			if (graphURIs != null && graphURIs.length != 0) {
				for (String graphURI : graphURIs) {
					queryBuffer.append("FROM <");
					queryBuffer.append(graphURI);
					queryBuffer.append(">\n");
				}
			}
			queryBuffer.append("WHERE{\n");
			queryBuffer.append("  {?i rdf:type <" + cls.getURI() + ">.}\n");
			queryBuffer.append(" UNION  {[] ?p ?i.  ?p rdfs:range <"
					+ cls.getURI() + ">.}\n");
			queryBuffer.append(" UNION  {?i ?p [].  ?p rdfs:domain <"
					+ cls.getURI() + ">.}\n");
			queryBuffer.append("}");

			queryString = queryBuffer.toString();

			// System.out.println(queryString);

			query = QueryFactory.create(queryString);

			qexec = null;
			results = null;
			try {
				// long start = System.currentTimeMillis();
				qexec = QueryExecutionFactory.sparqlService(endpointURI, query);
				endpointAccessCount++;
				results = qexec.execSelect();
				// long end = System.currentTimeMillis();
				// System.out.println("EXEC TIME: " + (end - start));
			} catch (Exception ex) {
				ex.printStackTrace();
				System.out.println(queryString);
				throw ex;
			}

			// create model
			for (; results.hasNext();) {
				QuerySolution sol = results.next();
				Literal lit = sol.getLiteral("num");
				if (lit != null) {
					int num = lit.getInt();
					cls.addLiteral(numInstancePro, num);
				}
			}
			qexec.close();
		}

		// subclassOf
		StringBuffer queryBuffer = new StringBuffer();
		queryBuffer.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
		queryBuffer
				.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
		queryBuffer
				.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
		queryBuffer.append("SELECT DISTINCT ?c ?d \n");
		if (graphURIs != null && graphURIs.length != 0) {
			for (String graphURI : graphURIs) {
				queryBuffer.append("FROM <");
				queryBuffer.append(graphURI);
				queryBuffer.append(">\n");
			}
		}
		queryBuffer.append("WHERE{\n");
		queryBuffer.append("  ?c rdfs:subclassOf ?d.\n");
//		queryBuffer.append("FILTER(! contains(str(?c),\"openlinksw\"))\n");
		queryBuffer.append("}");

		String queryString = queryBuffer.toString();

		// System.out.println(queryString);

		Query query = QueryFactory.create(queryString);

		QueryExecution qexec = null;
		ResultSet results = null;
		try {
			// long start = System.currentTimeMillis();
			qexec = QueryExecutionFactory.sparqlService(endpointURI, query);
			endpointAccessCount++;
			results = qexec.execSelect();
			// long end = System.currentTimeMillis();
			// System.out.println("EXEC TIME: " + (end - start));
			System.out.print(".");
		} catch (Exception ex) {
			ex.printStackTrace();
			throw ex;
		}

		Property subClsOf = model
				.createProperty("http://www.w3.org/2000/01/rdf-schema#subclassOf");
		for (; results.hasNext();) {
			QuerySolution sol = results.next();
			Resource cCls = sol.getResource("c");
			Resource pCls = sol.getResource("d");
			if (cCls != null && pCls != null
					&& uriFilter(cCls.getURI(), filterStrs) != null) {
				cCls = model.createResource(cCls.getURI());
				pCls = model.createResource(pCls.getURI());
				cCls.addProperty(subClsOf, pCls);
				// TODO

			}
		}
		qexec.close();
		schema.model = model;
		schema.classCategory = classCategory;
		return schema;
	}

	class ResourceNumberPair {
		public Resource resource = null;
		public int number = 0;

		ResourceNumberPair(Resource resource, int number) {
			this.resource = resource;
			this.number = number;
		}
	}

	
	
	
	
	public Schema getPropertySchema(Model model, String[] propertyURIs, HashSet<String> datatypeSet)
			throws Exception {
		// String[] filterStrs = { "http://www.openlinksw" };

		// create model
		Property domainPro = model
				.createProperty("http://www.w3.org/2000/01/rdf-schema#domain");
		Property rangePro = model
				.createProperty("http://www.w3.org/2000/01/rdf-schema#range");

		// Property inferedDomainPro = model
		// .createProperty("http://sparqlbuilder.org/inferedDomain");
		// Property inferedRangePro = model
		// .createProperty("http://sparqlbuilder.org/inferedRange");

		Property typePro = model
				.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
		Property labelPro = model
				.createProperty("http://www.w3.org/2000/01/rdf-schema#label");
		Resource clsCls = model
				.createResource("http://www.w3.org/2000/01/rdf-schema#Class");

		Property numTriplePro = model
				.createProperty("http://sparqlbuilder.org/numberOfTriples");
		Property numStartClsNumInsPro = model
				.createProperty("http://sparqlbuilder.org/numberOfInstancesOfStartClass");
		Property numEndClsNumInsPro = model
				.createProperty("http://sparqlbuilder.org/numberOfInstancesOfEndClass");
		Property numDomClsNumInsPro = model
				.createProperty("http://sparqlbuilder.org/numberOfInstancesOfDomainClass");
		Property numRanClsNumInsPro = model
				.createProperty("http://sparqlbuilder.org/numberOfInstancesOfRangeClass");
		Property indCatPro = model
				.createProperty("http://sparqlbuilder.org/individualPropertyCategory");

		Resource classRelationCls = model
				.createResource("http://sparqlbuilder.org/ClassRelation");
		Property startClsPro = model
				.createProperty("http://sparqlbuilder.org/startClass");
		Property endClsPro = model
				.createProperty("http://sparqlbuilder.org/endClass");
		Property endDatatypePro = model
				.createProperty("http://sparqlbuilder.org/endDatatype");
		Property propPro = model
				.createProperty("http://sparqlbuilder.org/property");
		Resource propProfileCls = model
				.createResource("http://sparqlbuilder.org/PropertyProfile");
		Property isDomClsLimPro = model
				.createProperty("http://sparqlbuilder.org/startClassLimitedQ");
		Property isRanClsLimPro = model
				.createProperty("http://sparqlbuilder.org/endClassLimitedQ");

		HashSet<String> classURISet = new HashSet<String>();
		int wholePropertyCategory = 0;
		int totalNumTriples = 0;
		int[] countProperties = new int[4];
		for (String propURI : propertyURIs) {
			HashSet<String> domClassSet = new HashSet<String>();
			HashSet<String> ranClassSet = new HashSet<String>();
			HashSet<String> literalDatatypeSet = new HashSet<String>();

			
			StringBuffer queryBuffer = new StringBuffer();
			queryBuffer
					.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
			queryBuffer
					.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
			queryBuffer
					.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
			queryBuffer.append("SELECT DISTINCT ?d\n");
			if (graphURIs != null && graphURIs.length != 0) {
				for (String graphURI : graphURIs) {
					queryBuffer.append("FROM <");
					queryBuffer.append(graphURI);
					queryBuffer.append(">\n");
				}
			}
			queryBuffer.append("WHERE{\n");
			queryBuffer.append(" <" + propURI + "> rdfs:domain ?d.\n");
			queryBuffer.append("}");
			String queryString = queryBuffer.toString();
			// System.out.println(queryString);
			Query query = QueryFactory.create(queryString);

			QueryExecution qexec = null;
			ResultSet results = null;
			try {
				// long start = System.currentTimeMillis();
				qexec = QueryExecutionFactory.sparqlService(endpointURI, query);
				endpointAccessCount++;
				results = qexec.execSelect();
				// long end = System.currentTimeMillis();
				// System.out.println("EXEC TIME: " + (end - start));
				System.out.print("d");
			} catch (Exception ex) {
				System.out.println(queryString);
				ex.printStackTrace();
				throw ex;
			}
			for (; results.hasNext();) {
				QuerySolution sol = results.next();
				Resource dom = sol.getResource("d");
				if( dom != null && dom.getURI() != null ){
					domClassSet.add(dom.getURI());
				}
			}
			qexec.close();

			
			// range
			queryBuffer = new StringBuffer();
			queryBuffer
					.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
			queryBuffer
					.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
			queryBuffer
					.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
			queryBuffer.append("SELECT DISTINCT ?r\n");
			if (graphURIs != null && graphURIs.length != 0) {
				for (String graphURI : graphURIs) {
					queryBuffer.append("FROM <");
					queryBuffer.append(graphURI);
					queryBuffer.append(">\n");
				}
			}
			queryBuffer.append("WHERE{\n");
			queryBuffer.append(" <" + propURI + "> rdfs:range ?r.\n");
			queryBuffer.append("}");
			queryString = queryBuffer.toString();
			// System.out.println(queryString);
			query = QueryFactory.create(queryString);

			qexec = null;
			results = null;
			try {
				// long start = System.currentTimeMillis();
				qexec = QueryExecutionFactory.sparqlService(endpointURI, query);
				endpointAccessCount++;
				results = qexec.execSelect();
				// long end = System.currentTimeMillis();
				// System.out.println("EXEC TIME: " + (end - start));
				System.out.print("r");
			} catch (Exception ex) {
				System.out.println(queryString);
				ex.printStackTrace();
				throw ex;
			}
			for (; results.hasNext();) {
				QuerySolution sol = results.next();
				Resource ran = sol.getResource("r");
				if( ran != null && ran.getURI() != null ){
					// remove rdfs:literal
					if( !ran.getURI().equals("http://www.w3.org/2000/01/rdf-schema#Literal")){
						if( !datatypeSet.contains(ran.getURI())){
							ranClassSet.add(ran.getURI());
						}
					}
				}
			}
			qexec.close();

			
			
			// inference
			ArrayList<PropertyDomainRangeDecl> propDomRanDeclList = new ArrayList<PropertyDomainRangeDecl>();
			ArrayList<PropertyDomainRangeDecl> propDomRanDeclList2 = new ArrayList<PropertyDomainRangeDecl>();
			queryBuffer = new StringBuffer();
			queryBuffer
					.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
			queryBuffer
					.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
			queryBuffer
					.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
			// queryBuffer
			// .append("SELECT ?d ?r (count(?i) AS ?numTriples) (count(DISTINCT ?i) AS ?numDomIns) (count(DISTINCT ?o) AS ?numRanIns)\n");
			queryBuffer.append("SELECT DISTINCT ?d ?r\n");

			if (graphURIs != null && graphURIs.length != 0) {
				for (String graphURI : graphURIs) {
					queryBuffer.append("FROM <");
					queryBuffer.append(graphURI);
					queryBuffer.append(">\n");
				}
			}
			queryBuffer.append("WHERE{\n");
			queryBuffer.append("   ?i <" + propURI + "> ?o. \n");
			queryBuffer.append("OPTIONAL{ ?i rdf:type ?d.}\n");
			queryBuffer.append("OPTIONAL{ ?o rdf:type ?r.}\n");
			queryBuffer.append("}");
			queryString = queryBuffer.toString();
			// System.out.println(queryString);
			query = QueryFactory.create(queryString);

			qexec = null;
			results = null;
			try {
				// long start = System.currentTimeMillis();
				qexec = QueryExecutionFactory.sparqlService(endpointURI, query);
				endpointAccessCount++;
				qexec.setTimeout(-1);
				results = qexec.execSelect();
				// long end = System.currentTimeMillis();
				// System.out.println("EXEC TIME: " + (end - start));
				System.out.print("i");
			} catch (Exception ex) {
				System.out.println(queryString);
				ex.printStackTrace();
				throw ex;
			}

		
			// domain-range pair
			for (; results.hasNext();) {
				QuerySolution sol = results.next();
				Resource dom = sol.getResource("d");
				Resource ran = sol.getResource("r");
				String domURI = null;
				if (dom != null) {
					domURI = dom.getURI();
				}
				String ranURI = null;
				if (ran != null) {
					if( !ran.getURI().equals("http://www.w3.org/2000/01/rdf-schema#Literal") && !datatypeSet.contains(ran.getURI())){
						ranURI = ran.getURI();
					}
				}

//				System.out.println(domURI + "--" + ranURI);
if( dom == null && ran == null ){
	System.out.println("NullNull");
}
				
				
				PropertyDomainRangeDecl pdrd = new PropertyDomainRangeDecl(
						propURI, domURI, ranURI, null, 0, 0, 0, false, false);
				propDomRanDeclList.add(pdrd);
			}
			qexec.close();


			// literal
			queryBuffer = new StringBuffer();
			queryBuffer
					.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
			queryBuffer
					.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
			queryBuffer
					.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
			// queryBuffer
			// .append("SELECT ?d ?r (count(?i) AS ?numTriples) (count(DISTINCT ?i) AS ?numDomIns) (count(DISTINCT ?o) AS ?numRanIns)\n");
			queryBuffer.append("SELECT DISTINCT ?d (datatype(?o) AS ?ldt)\n");

			if (graphURIs != null && graphURIs.length != 0) {
				for (String graphURI : graphURIs) {
					queryBuffer.append("FROM <");
					queryBuffer.append(graphURI);
					queryBuffer.append(">\n");
				}
			}
			queryBuffer.append("WHERE{\n");
			queryBuffer.append("   ?i <" + propURI + "> ?o. \n");
			queryBuffer.append("OPTIONAL{ ?i rdf:type ?d.}\n");
			queryBuffer.append("}");
			queryString = queryBuffer.toString();
			// System.out.println(queryString);
			query = QueryFactory.create(queryString);

			qexec = null;
			results = null;
			try {
				// long start = System.currentTimeMillis();
				qexec = QueryExecutionFactory.sparqlService(endpointURI, query);
				qexec.setTimeout(-1);
				endpointAccessCount++;
				results = qexec.execSelect();
				// long end = System.currentTimeMillis();
				// System.out.println("EXEC TIME: " + (end - start));
				System.out.print("i");
			} catch (Exception ex) {
				System.out.println(queryString);
				ex.printStackTrace();
				throw ex;
			}

			for (; results.hasNext();) {
				QuerySolution sol = results.next();
				Resource dom = sol.getResource("d");
				Literal lit = sol.getLiteral("ldt");
				if( lit != null ){
					String ranRef = lit.getString();
					literalDatatypeSet.add(ranRef);
//					System.out.println(ranRef);

					String domURI = null;
					if (dom != null) {
						domURI = dom.getURI();
					}
//				String ranURI = null;
//				if (ran != null) {
//					ranURI = ran.getURI();
//				}

//				System.out.println(domURI + "--" + ranURI);

				PropertyDomainRangeDecl pdrd = new PropertyDomainRangeDecl(
						propURI, domURI, null, ranRef, 0, 0, 0, false, false);
				propDomRanDeclList.add(pdrd);
				}
			}
			qexec.close();

// debug
//			for (PropertyDomainRangeDecl pdrd : propDomRanDeclList) {
//				System.out.println(pdrd.getProperty() + " (" + pdrd.getDomainClass() 
//							+ ",{"+ pdrd.getRangeClass() + ","+pdrd.getLiteralDataType()+"})");
//			}	
			
			
			for (PropertyDomainRangeDecl pdrd : propDomRanDeclList) {
				queryBuffer = new StringBuffer();
				queryBuffer
						.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
				queryBuffer
						.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
				queryBuffer
						.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
				queryBuffer
						.append("SELECT (count(?i) AS ?numTriples) (count(DISTINCT ?i) AS ?numDomIns) (count(DISTINCT ?o) AS ?numRanIns)\n");

				if (graphURIs != null && graphURIs.length != 0) {
					for (String graphURI : graphURIs) {
						queryBuffer.append("FROM <");
						queryBuffer.append(graphURI);
						queryBuffer.append(">\n");
					}
				}
				queryBuffer.append("WHERE{\n");
				queryBuffer.append("   ?i <" + propURI + "> ?o. \n");
				if (pdrd.getDomainClass() != null) {
					queryBuffer.append(" ?i rdf:type <" + pdrd.getDomainClass()
							+ ">.\n");
				}
				if (pdrd.getRangeClass() != null) {
					queryBuffer.append("?o rdf:type <" + pdrd.getRangeClass()
							+ ">.\n");
				}else{
					if( pdrd.getLiteralDataType() != null ){
						queryBuffer.append("FILTER( datatype(?o) = <"+ pdrd.getLiteralDataType()+ ">)\n");
					}
				}	
				queryBuffer.append("}");
				queryString = queryBuffer.toString();
				// System.out.println(queryString);
				query = QueryFactory.create(queryString);

				qexec = null;
				results = null;
				try {
					// long start = System.currentTimeMillis();
					qexec = QueryExecutionFactory.sparqlService(endpointURI,
							query);
					qexec.setTimeout(-1);
					endpointAccessCount++;
					results = qexec.execSelect();
					// long end = System.currentTimeMillis();
					// System.out.println("EXEC TIME: " + (end - start));
					System.out.print(".");
				} catch (Exception ex) {
					System.out.println(queryString);
					ex.printStackTrace();
					throw ex;
				}

				ArrayList<String> domList = new ArrayList<String>();
				ArrayList<String> ranList = new ArrayList<String>();
				String literalDataType = null;

				for (; results.hasNext();) {
					QuerySolution sol = results.next();
					String domURI = pdrd.getDomainClass();
					if (domURI != null) {
						domList.add(domURI);
					}
					if (domURI == null && domClassSet.size() > 0) {
						Iterator<String> it = domClassSet.iterator();
						while (it.hasNext()) {
							domList.add(it.next());
						}
					}

					String ranURI = pdrd.getRangeClass();
					if (ranURI != null) {
						ranList.add(ranURI);
					}
					if( ranURI == null ){
						if( pdrd.getLiteralDataType() != null ){
							literalDataType = pdrd.getLiteralDataType();
						}else{
							if (ranClassSet.size() > 0) {
								Iterator<String> it = ranClassSet.iterator();
								while (it.hasNext()) {
									ranList.add(it.next());
								}
							}
						}
					}


					Literal lit = sol.getLiteral("numTriples");
					int numTriples = 0;
					if (lit != null) {
						numTriples = lit.getInt();
					}
					lit = sol.getLiteral("numDomIns");
					int numDomIns = 0;
					if (lit != null) {
						numDomIns = lit.getInt();
					}
					lit = sol.getLiteral("numRanIns");
					int numRanIns = 0;
					if (lit != null) {
						numRanIns = lit.getInt();
					}

					for (String domURIs : domList) {
						for (String ranURIs : ranList) {
							PropertyDomainRangeDecl pdrd2 = new PropertyDomainRangeDecl(
									propURI, domURIs, ranURIs, null, numTriples,
									numDomIns, numRanIns, (domURI == null),
									(ranURI == null && literalDataType == null));
							propDomRanDeclList2.add(pdrd2);
						}
						if(literalDataType != null ){
							PropertyDomainRangeDecl pdrd2 = new PropertyDomainRangeDecl(
									propURI, domURIs, null, literalDataType, numTriples,
									numDomIns, numRanIns, (domURI == null),
									false );
							propDomRanDeclList2.add(pdrd2);
						}
					}
				}
				qexec.close();
			} // end of for pdrd



// DEBUG
//			for (PropertyDomainRangeDecl pdrd : propDomRanDeclList2) {
//				System.out.println(pdrd.getProperty() + " (" + pdrd.getDomainClass() 
//							+ ",{"+ pdrd.getRangeClass() + ","+pdrd.getLiteralDataType()+"})");
//			}	
			
			
			// numbers of triples, dom instances and ran instances
			int numDomIns = 0;
			int numRanIns = 0;
			int numTriples = 0;
			queryBuffer = new StringBuffer();
			queryBuffer
					.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
			queryBuffer
					.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
			queryBuffer
					.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
			queryBuffer
					.append("SELECT (count(?i) AS ?numTriples) (count(DISTINCT ?i) AS ?numDomIns) (count(DISTINCT ?o) AS ?numRanIns)\n");
			if (graphURIs != null && graphURIs.length != 0) {
				for (String graphURI : graphURIs) {
					queryBuffer.append("FROM <");
					queryBuffer.append(graphURI);
					queryBuffer.append(">\n");
				}
			}
			queryBuffer.append("WHERE{\n");
			queryBuffer.append("   ?i <" + propURI + "> ?o. \n");
			queryBuffer.append("}");
			queryString = queryBuffer.toString();
			// System.out.println(queryString);
			query = QueryFactory.create(queryString);

			qexec = null;
			results = null;
			try {
				// long start = System.currentTimeMillis();
				qexec = QueryExecutionFactory.sparqlService(endpointURI, query);
				endpointAccessCount++;
				results = qexec.execSelect();
				// long end = System.currentTimeMillis();
				// System.out.println("EXEC TIME: " + (end - start));
				System.out.print("n");
			} catch (Exception ex) {
				System.out.println(queryString);
				ex.printStackTrace();
				throw ex;
			}
			if( results.hasNext()) {
				QuerySolution sol = results.next();
				Literal lit = sol.getLiteral("numDomIns");
				if (lit != null) {
					numDomIns = lit.getInt();
				}
				lit = sol.getLiteral("numRanIns");
				if (lit != null) {
					numRanIns = lit.getInt();
				}
				lit = sol.getLiteral("numTriples");
				if (lit != null) {
					numTriples = lit.getInt();
				}
			}
			qexec.close();


			
			int numTriplesWithBothClass = 0;
			int numDomInsWithClass = 0;
			int numTriplesWithDomClass = 0;
			int numRanInsWithClass = 0;
			int numTriplesWithRanClass = 0;

//			if (domClassSet.size() == 0 || (ranClassSet.size() == 0 && literalDatatypeSet.size() == 0) ) {

				// �N���X�����Ă�����C���X�^���X�̐��𐔂���
				queryBuffer = new StringBuffer();
				queryBuffer
						.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
				queryBuffer
						.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
				queryBuffer
						.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
				queryBuffer
						.append("SELECT (count(DISTINCT ?i) AS ?numDomIns) (count(?i) AS ?numTriplesWithDom)\n");
				if (graphURIs != null && graphURIs.length != 0) {
					for (String graphURI : graphURIs) {
						queryBuffer.append("FROM <");
						queryBuffer.append(graphURI);
						queryBuffer.append(">\n");
					}
				}
				queryBuffer.append("WHERE{\n");
				queryBuffer.append("   ?i <" + propURI + "> ?o. \n");
				queryBuffer.append("   ?i rdf:type ?d. \n");
				queryBuffer.append("}");
				queryString = queryBuffer.toString();
				// System.out.println(queryString);
				query = QueryFactory.create(queryString);

				qexec = null;
				results = null;
				try {
					// long start = System.currentTimeMillis();
					qexec = QueryExecutionFactory.sparqlService(endpointURI,
							query);
					endpointAccessCount++;
					results = qexec.execSelect();
					// long end = System.currentTimeMillis();
					// System.out.println("EXEC TIME: " + (end - start));
					System.out.print(".");
				} catch (Exception ex) {
					System.out.println(queryString);
					ex.printStackTrace();
					throw ex;
				}
				if( results.hasNext()) {
					QuerySolution sol = results.next();
					Literal lit = sol.getLiteral("numDomIns");
					if (lit != null) {
						numDomInsWithClass = lit.getInt();
					}
					lit = sol.getLiteral("numTriplesWithDom");
					if( lit != null ){
						numTriplesWithDomClass = lit.getInt();
					}
				}
				qexec.close();

				// range
				queryBuffer = new StringBuffer();
				queryBuffer
						.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
				queryBuffer
						.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
				queryBuffer
						.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
				queryBuffer
						.append("SELECT (count(DISTINCT ?o) AS ?numRanIns) (count(?o) AS ?numTriplesWithRan)\n");
				if (graphURIs != null && graphURIs.length != 0) {
					for (String graphURI : graphURIs) {
						queryBuffer.append("FROM <");
						queryBuffer.append(graphURI);
						queryBuffer.append(">\n");
					}
				}
				queryBuffer.append("WHERE{\n");
				queryBuffer.append("   ?i <" + propURI + "> ?o. \n");
				queryBuffer.append("   ?o rdf:type ?r. \n");
	//			queryBuffer.append("UNION{  FILTER(isLiteral(?o)) }\n");
				queryBuffer.append("}");
				queryString = queryBuffer.toString();
				// System.out.println(queryString);
				query = QueryFactory.create(queryString);

				qexec = null;
				results = null;
				try {
					// long start = System.currentTimeMillis();
					qexec = QueryExecutionFactory.sparqlService(endpointURI,
							query);
					endpointAccessCount++;
					results = qexec.execSelect();
					// long end = System.currentTimeMillis();
					// System.out.println("EXEC TIME: " + (end - start));
					System.out.print(".");
				} catch (Exception ex) {
					System.out.println(queryString);
					ex.printStackTrace();
					throw ex;
				}
				if( results.hasNext() ) {
					QuerySolution sol = results.next();
					Literal lit = sol.getLiteral("numRanIns");
					if (lit != null) {
						numRanInsWithClass = lit.getInt();
					}
					lit = sol.getLiteral("numTriplesWithRan");
					if (lit != null) {
						numTriplesWithRanClass = lit.getInt();
					}
					
				}
				qexec.close();

				// literal
				queryBuffer = new StringBuffer();
				queryBuffer
						.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
				queryBuffer
						.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
				queryBuffer
						.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
				queryBuffer
						.append("SELECT (count(DISTINCT ?o) AS ?numRanIns) (count(?o) AS ?numTriplesWithRan)\n");
				if (graphURIs != null && graphURIs.length != 0) {
					for (String graphURI : graphURIs) {
						queryBuffer.append("FROM <");
						queryBuffer.append(graphURI);
						queryBuffer.append(">\n");
					}
				}
				queryBuffer.append("WHERE{\n");
				queryBuffer.append("   ?i <" + propURI + "> ?o. \n");
				queryBuffer.append(" FILTER(isLiteral(?o)) \n");
				queryBuffer.append("}");
				queryString = queryBuffer.toString();
				// System.out.println(queryString);
				query = QueryFactory.create(queryString);

				qexec = null;
				results = null;
				try {
					// long start = System.currentTimeMillis();
					qexec = QueryExecutionFactory.sparqlService(endpointURI,
							query);
					endpointAccessCount++;
					results = qexec.execSelect();
					// long end = System.currentTimeMillis();
					// System.out.println("EXEC TIME: " + (end - start));
					System.out.print(".");
				} catch (Exception ex) {
					System.out.println(queryString);
					ex.printStackTrace();
					throw ex;
				}
				if( results.hasNext() ) {
					QuerySolution sol = results.next();
					Literal lit = sol.getLiteral("numRanIns");
					if (lit != null) {
						numRanInsWithClass += lit.getInt();
					}
					lit = sol.getLiteral("numTriplesWithRan");
					if (lit != null) {
						numTriplesWithRanClass += lit.getInt();
					}
					
				}
				qexec.close();
				
				
//				// literal
//				queryBuffer = new StringBuffer();
//				queryBuffer
//						.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
//				queryBuffer
//						.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
//				queryBuffer
//						.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
//				queryBuffer
//						.append("SELECT (count(DISTINCT ?o) AS ?numRanIns)\n");
//				if (graphURIs != null && graphURIs.length != 0) {
//					for (String graphURI : graphURIs) {
//						queryBuffer.append("FROM <");
//						queryBuffer.append(graphURI);
//						queryBuffer.append(">\n");
//					}
//				}
//				queryBuffer.append("WHERE{\n");
//				queryBuffer.append("   ?i <" + propURI + "> ?o. \n");
//				queryBuffer.append("FILTER( datatype(?o) = ?c) \n");
//				queryBuffer.append("}");
//				queryString = queryBuffer.toString();
//				// System.out.println(queryString);
//				query = QueryFactory.create(queryString);
//
//				qexec = null;
//				results = null;
//				try {
//					// long start = System.currentTimeMillis();
//					qexec = QueryExecutionFactory.sparqlService(endpointURI,
//							query);
//					results = qexec.execSelect();
//					// long end = System.currentTimeMillis();
//					// System.out.println("EXEC TIME: " + (end - start));
//					System.out.print(".");
//				} catch (Exception ex) {
//					System.out.println(queryString);
//					ex.printStackTrace();
//					throw ex;
//				}
//				for (; results.hasNext();) {
//					QuerySolution sol = results.next();
//					Literal lit = sol.getLiteral("numRanIns");
//					if (lit != null) {
//						numRanInsWithClass += lit.getInt();
//					}
//				}
//				qexec.close();
				
				
				// domain, range両方宣言されているトリプル数を数える
				queryBuffer = new StringBuffer();
				queryBuffer
						.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
				queryBuffer
						.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
				queryBuffer
						.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
				queryBuffer.append("SELECT (count(?i) AS ?numTriples)\n");
				if (graphURIs != null && graphURIs.length != 0) {
					for (String graphURI : graphURIs) {
						queryBuffer.append("FROM <");
						queryBuffer.append(graphURI);
						queryBuffer.append(">\n");
					}
				}
				queryBuffer.append("WHERE{\n");
				queryBuffer.append("   ?i <" + propURI + "> ?o. \n");
//				if (domClassSet.size() == 0) {
					queryBuffer.append("   ?i rdf:type ?d. \n");
//				}
//				if (ranClassSet.size() == 0) {
					queryBuffer.append("   ?o rdf:type ?r. \n");
//					queryBuffer.append("FILTER( isLiteral(?o) ) \n");
//				}

				queryBuffer.append("}");
				queryString = queryBuffer.toString();
				// System.out.println(queryString);
				query = QueryFactory.create(queryString);

				qexec = null;
				results = null;
				try {
					// long start = System.currentTimeMillis();
					qexec = QueryExecutionFactory.sparqlService(endpointURI,
							query);
					endpointAccessCount++;
					results = qexec.execSelect();
					// long end = System.currentTimeMillis();
					// System.out.println("EXEC TIME: " + (end - start));
					System.out.print(".");
				} catch (Exception ex) {
					System.out.println(queryString);
					ex.printStackTrace();
					throw ex;
				}
				for (; results.hasNext();) {
					QuerySolution sol = results.next();
					Literal lit = sol.getLiteral("numTriples");
					if (lit != null) {
						numTriplesWithBothClass = lit.getInt();
					}
				}
				qexec.close();

				queryBuffer = new StringBuffer();
				queryBuffer
						.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
				queryBuffer
						.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
				queryBuffer
						.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
				queryBuffer.append("SELECT (count(?i) AS ?numTriples)\n");
				if (graphURIs != null && graphURIs.length != 0) {
					for (String graphURI : graphURIs) {
						queryBuffer.append("FROM <");
						queryBuffer.append(graphURI);
						queryBuffer.append(">\n");
					}
				}
				queryBuffer.append("WHERE{\n");
				queryBuffer.append("   ?i <" + propURI + "> ?o. \n");
//				if (domClassSet.size() == 0) {
					queryBuffer.append("   ?i rdf:type ?d. \n");
//				}
//				if (ranClassSet.size() == 0) {
//					queryBuffer.append("   ?o rdf:type ?r. \n");
					queryBuffer.append("FILTER( isLiteral(?o) ) \n");
//				}

				queryBuffer.append("}");
				queryString = queryBuffer.toString();
				// System.out.println(queryString);
				query = QueryFactory.create(queryString);

				qexec = null;
				results = null;
				try {
					// long start = System.currentTimeMillis();
					qexec = QueryExecutionFactory.sparqlService(endpointURI,
							query);
					endpointAccessCount++;
					results = qexec.execSelect();
					// long end = System.currentTimeMillis();
					// System.out.println("EXEC TIME: " + (end - start));
					System.out.print(".");
				} catch (Exception ex) {
					System.out.println(queryString);
					ex.printStackTrace();
					throw ex;
				}
				for (; results.hasNext();) {
					QuerySolution sol = results.next();
					Literal lit = sol.getLiteral("numTriples");
					if (lit != null) {
						numTriplesWithBothClass += lit.getInt();
					}
				}
				qexec.close();

//			} // end of IF

			int numTriplesWithClass = (numTriplesWithDomClass+numTriplesWithRanClass) - numTriplesWithBothClass;
			

//System.out.println("numTriplesWithClass: "+numTriplesWithClass);
//System.out.println("numTriplesWithRanClass: "+numTriplesWithRanClass);
//System.out.println("numRanInsWithClass: " + numRanInsWithClass);

			// label
			ArrayList<String> labelList = new ArrayList<String>();
			queryBuffer = new StringBuffer();
			queryBuffer
					.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
			queryBuffer
					.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
			queryBuffer
					.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
			queryBuffer.append("SELECT ?label\n");
			if (graphURIs != null && graphURIs.length != 0) {
				for (String graphURI : graphURIs) {
					queryBuffer.append("FROM <");
					queryBuffer.append(graphURI);
					queryBuffer.append(">\n");
				}
			}
			queryBuffer.append("WHERE{\n");
			queryBuffer.append("  <" + propURI + "> rdfs:label ?label. \n");
			queryBuffer.append("}");
			queryString = queryBuffer.toString();
			// System.out.println(queryString);
			query = QueryFactory.create(queryString);

			qexec = null;
			results = null;
			try {
				// long start = System.currentTimeMillis();
				qexec = QueryExecutionFactory.sparqlService(endpointURI, query);
				endpointAccessCount++;
				results = qexec.execSelect();
				// long end = System.currentTimeMillis();
				// System.out.println("EXEC TIME: " + (end - start));
				// System.out.print(".");
				System.out.print(".");
			} catch (Exception ex) {
				System.out.println(queryString);
				ex.printStackTrace();
				throw ex;
			}
			for (; results.hasNext();) {
				QuerySolution sol = results.next();
				Literal lit = sol.getLiteral("label");
				if (lit != null) {
					String label = lit.getString();
					labelList.add(label);
					// pro.addLiteral(labelPro, label);
				}
			}
			qexec.close();

			// analysis
			int propCategory = 0;
			// domain
			if (numTriples == 0) {
				propCategory = 4;
			} else {
				if (domClassSet.size() == 0) {
					// dom is not defined.
					if (numDomIns - numDomInsWithClass == 0) {
						// ���ׂẴC���X�^���X��class�錾����Ă���Ƃ�
						// GUI�ŃN���X�I���\(���_�ŋ~��)
						propCategory = 2;
					} else {
						if (numDomInsWithClass == 0) {
							// class�錾�̂���C���X�^���X���Ȃ��Ƃ�
							// �ǂ̃C���X�^���X���N���X�錾����Ă��Ȃ��Ƃ�
							// Junk�v���p�e�B(�~�ςł��Ȃ�)
							propCategory = 4;
							numDomIns = 0;
						} else {
							// �ꕔ�~��
							propCategory = 3;
							numDomIns = numDomInsWithClass;
						}
					}
				} else {
					if( numDomIns - numDomInsWithClass == 0 ){
						// okay
						propCategory = 1;
					}else{
						propCategory = 2;
					}
				}
			}
			// range
			if (numTriples == 0) {
				propCategory = 4;
			} else {
				if (ranClassSet.size() == 0 && literalDatatypeSet.size() == 0 ) {
					// ran is not defined.
					if (numRanIns - numRanInsWithClass == 0) {
						// ���ׂẴC���X�^���X��class�錾����Ă���Ƃ�
						// GUI�ŃN���X�I���\(���_�ŋ~��)
						if (propCategory == 1) {
							propCategory = 2;
						}
						if (numRanInsWithClass == 0) {
							// class�錾�̂���C���X�^���X���Ȃ��Ƃ�
							// �ǂ̃C���X�^���X���N���X�錾����Ă��Ȃ��Ƃ�
							// Junk�v���p�e�B(�~�ςł��Ȃ�)
							propCategory = 4;
							numRanIns = 0;
						} else {
							// �ꕔ�~��
							propCategory = Math.max(propCategory, 3);
							numRanIns = numRanInsWithClass;
						}
					}
				} else {
					if (ranClassSet.size() == 0 && literalDatatypeSet.size() != 0 ) {
						// ran is not defined.
						if (numRanIns - numRanInsWithClass == 0) {
							// nothing to do
						} else {
							if (numRanInsWithClass == 0) {
								propCategory = 4;
								numRanIns = 0;
							} else {
								// �ꕔ�~��
								propCategory = Math.max(propCategory, 3);
								numRanIns = numRanInsWithClass;
							}
						}
					} else {
						if( numDomIns - numDomInsWithClass == 0 ){
							// okay
							//nothing to do
						}else{
							propCategory = Math.max(propCategory, 2);
						}
					}
				}
			}
			
			if (domClassSet.size() == 0 || (ranClassSet.size() == 0 && literalDatatypeSet.size() == 0 )) {
				numTriples = numTriplesWithClass;
			}

			if (wholePropertyCategory == 0) {
				wholePropertyCategory = propCategory;
			} else {
				if (propCategory == 1) {
					if (wholePropertyCategory == 4) {
						wholePropertyCategory = 3;
					}
				} else {
					if (propCategory == 2) {
						if (wholePropertyCategory == 1) {
							wholePropertyCategory = 2;
						} else {
							if (wholePropertyCategory == 4) {
								wholePropertyCategory = 3;
							}
						}
					} else {
						if (wholePropertyCategory == 1
								|| wholePropertyCategory == 2) {
							wholePropertyCategory = 3;
						}
					}
				}
			}

			countProperties[propCategory - 1]++;

			// if (propCategory != 4) {
			// write to model
			// property
			Property pro = model.createProperty(propURI);
			// labels
			for (String label : labelList) {
				pro.addLiteral(labelPro, label);
			}

			// class relations
			for (PropertyDomainRangeDecl pdrd : propDomRanDeclList2) {
				Resource classRelation = model.createResource(AnonId.create());
				classRelation.addProperty(typePro, classRelationCls);
				classRelation.addProperty(startClsPro,
						model.createResource(pdrd.getDomainClass()));
				classURISet.add(pdrd.getDomainClass());
				if( pdrd.getRangeClass() != null ){
				
					classRelation.addProperty(endClsPro,
						model.createResource(pdrd.getRangeClass()));
					classURISet.add(pdrd.getRangeClass());
				}else{
					if( pdrd.getLiteralDataType() != null ){
						classRelation.addProperty(endDatatypePro,
								model.createResource(pdrd.getLiteralDataType()));
					}
				}
				
				classRelation.addProperty(propPro,
						model.createProperty(pdrd.getProperty()));
				classRelation.addLiteral(numTriplePro, pdrd.getNumTriples());
				classRelation.addLiteral(numStartClsNumInsPro,
						pdrd.getNumDomainInstances());
				classRelation.addLiteral(numEndClsNumInsPro,
						pdrd.getNumRangeInstances());
				classRelation.addLiteral(isDomClsLimPro,
						pdrd.isDomainClassLimitedQ());
				classRelation.addLiteral(isRanClsLimPro,
						pdrd.isRangeClassLimitedQ());
			}

			Resource propProfile = model.createResource(AnonId.create());
			propProfile.addProperty(typePro, propProfileCls);
			propProfile.addProperty(propPro, pro);
			propProfile.addLiteral(indCatPro, propCategory);

			for (String domURI : domClassSet) {
				Resource dom = model.createResource(domURI);
				dom.addProperty(typePro, clsCls);
				pro.addProperty(domainPro, dom);
				classURISet.add(domURI);
			}

			for (String ranURI : ranClassSet) {
				Resource ran = model.createResource(ranURI);
				ran.addProperty(typePro, clsCls);
				pro.addProperty(rangePro, ran);
				classURISet.add(ranURI);
			}

			// TODO literal		
			for( String datatypeURI: literalDatatypeSet){
				Resource ran = model.createResource(datatypeURI);
				ran.addProperty(typePro, clsCls);
				pro.addProperty(rangePro, ran);
			}
			
			propProfile.addLiteral(numDomClsNumInsPro, numDomIns);
			propProfile.addLiteral(numRanClsNumInsPro, numRanIns);
			propProfile.addLiteral(numTriplePro, numTriples);

			totalNumTriples += numTriples;

			// } //end if cat

			System.out.println(propURI + " (" + propCategory + ")("
					+ numTriples + ", " + numDomIns + ", " + numRanIns + ")");
		}// end of for (propURI)

		if (countProperties != null) {
			int cnt = 1;
			for (int c : countProperties) {
				System.out.println("property[" + cnt + "]: " + c);
				cnt++;
			}
		}
		System.out.println("#Datatypes: " + datatypeSet.size());
		System.out.println("#Classes: " + classURISet.size());
		System.out.println("#Triples: " + totalNumTriples);

		return new Schema(model, wholePropertyCategory, countProperties, 0, 0,
				totalNumTriples, classURISet);
	}

	class PropertyDomainRangeDecl {

		String property = null;
		String domainClass = null;
		String rangeClass = null;
		String literalDataType = null;
		int numTriples = 0;
		int numDomainInstances = 0;
		int numRangeInstances = 0;
		boolean domainClassLimitedQ = false;
		boolean rangeClassLimitedQ = false;

		public PropertyDomainRangeDecl(String property, String domainClass,
				String rangeClass, String literalDataType, int numTriples, int numDomainInstances,
				int numRangeInstances, boolean domainClassLimitedQ,
				boolean rangeClassLimitedQ) {
			this.property = property;
			this.domainClass = domainClass;
			this.rangeClass = rangeClass;
			this.literalDataType = literalDataType;
			this.numTriples = numTriples;
			this.numDomainInstances = numDomainInstances;
			this.numRangeInstances = numRangeInstances;
			this.domainClassLimitedQ = domainClassLimitedQ;
			this.rangeClassLimitedQ = rangeClassLimitedQ;
		}

		public String getProperty() {
			return property;
		}

		public String getDomainClass() {
			return domainClass;
		}

		public String getRangeClass() {
			return rangeClass;
		}

		public String getLiteralDataType() {
			return literalDataType;
		}

		public final int getNumTriples() {
			return numTriples;
		}

		public final int getNumDomainInstances() {
			return numDomainInstances;
		}

		public final int getNumRangeInstances() {
			return numRangeInstances;
		}

		public final boolean isDomainClassLimitedQ() {
			return domainClassLimitedQ;
		}

		public final boolean isRangeClassLimitedQ() {
			return rangeClassLimitedQ;
		}

	}

	class Schema {
		public Model model = null;
		public int propertyCategory = 0;
		public int classCategory = 0;
		public int[] countProperties;
		public int category = 0;
		public int numTriples = 0;
		public HashSet<String> inferedClasses; // internally used

		public Schema(Model model, int propertyCategory, int[] countProperties,
				int classCategory, int category, int numTriples,
				HashSet<String> inferedClasses) {
			this.model = model;
			this.propertyCategory = propertyCategory;
			this.countProperties = countProperties;
			this.classCategory = classCategory;
			this.category = category;
			this.numTriples = numTriples;
			this.inferedClasses = inferedClasses;
		}
	}

	public RDFsCrawlerImpl(String endpointURI) {
		this.endpointURI = endpointURI;
	}

	public RDFsCrawlerImpl(String endpointURI, String[] graphURIs) {
		this.endpointURI = endpointURI;
		this.graphURIs = graphURIs;
	}

	public Model getPropertiesFromInstanceDecls() throws Exception {

		StringBuffer queryBuffer = new StringBuffer();
		queryBuffer.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
		queryBuffer
				.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
		queryBuffer
				.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
		queryBuffer.append("SELECT DISTINCT ?p ?d ?r \n");
		if (graphURIs != null && graphURIs.length != 0) {
			for (String graphURI : graphURIs) {
				queryBuffer.append("FROM <");
				queryBuffer.append(graphURI);
				queryBuffer.append(">\n");
			}
		}
		queryBuffer.append("WHERE{\n");
		queryBuffer.append("  ?i rdf:type ?d.\n");
		queryBuffer.append("  ?j rdf:type ?r.\n");
		queryBuffer.append("  ?i ?p ?j.\n");
		// queryBuffer.append("  ?p rdfs:domain ?m.\n");
		// queryBuffer.append("  ?p rdfs:range ?r.\n");
		queryBuffer.append("}");

		String queryString = queryBuffer.toString();

		// System.out.println(queryString);

		Query query = QueryFactory.create(queryString);

		QueryExecution qexec = null;
		ResultSet results = null;
		try {
			// long start = System.currentTimeMillis();
			qexec = QueryExecutionFactory.sparqlService(endpointURI, query);
			endpointAccessCount++;
			results = qexec.execSelect();
			// long end = System.currentTimeMillis();
			// System.out.println("EXEC TIME: " + (end - start));
			System.out.print(".");
		} catch (Exception ex) {
			ex.printStackTrace();
			throw ex;
		}

		// create model
		Model model = ModelFactory.createDefaultModel();
		Property domainPro = model
				.createProperty("http://www.w3.org/2000/01/rdf-schema#domain");
		Property rangePro = model
				.createProperty("http://www.w3.org/2000/01/rdf-schema#range");

		String[] filterStrs = { "http://www.openlinksw", "http://www.w3.org/2001/XMLSchema" };
		for (; results.hasNext();) {
			QuerySolution sol = results.next();
			Resource pro = sol.getResource("p");
			Resource dom = sol.getResource("d");
			Resource ren = sol.getResource("r");
			if (pro != null && uriFilter(pro.getURI(), filterStrs) != null) {
				pro = model.createResource(pro);
				if (dom != null) {
					dom = model.createResource(dom);
					pro.addProperty(domainPro, dom);
				}
				if (ren != null) {
					ren = model.createResource(ren);
					pro.addProperty(rangePro, ren);
				}
			}
		}
		qexec.close();
		return model;
	}

	public Model getProperiesFromDomainRangeDecls() throws Exception {
		StringBuffer queryBuffer = new StringBuffer();
		queryBuffer.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
		queryBuffer
				.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
		queryBuffer
				.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
		queryBuffer.append("SELECT ?p ?d ?r \n");
		if (graphURIs != null && graphURIs.length != 0) {
			for (String graphURI : graphURIs) {
				queryBuffer.append("FROM <");
				queryBuffer.append(graphURI);
				queryBuffer.append(">\n");
			}
		}
		queryBuffer.append("WHERE{\n");
		queryBuffer.append("  ?p rdfs:domain ?d.\n");
		queryBuffer.append("  ?p rdfs:range ?r.\n");
		queryBuffer.append("}");

		String queryString = queryBuffer.toString();

		// System.out.println(queryString);

		Query query = QueryFactory.create(queryString);

		QueryExecution qexec = null;
		ResultSet results = null;
		try {
			// long start = System.currentTimeMillis();
			qexec = QueryExecutionFactory.sparqlService(endpointURI, query);
			endpointAccessCount++;
			results = qexec.execSelect();
			// long end = System.currentTimeMillis();
			// System.out.println("EXEC TIME: " + (end - start));
			System.out.print(".");
		} catch (Exception ex) {
			ex.printStackTrace();
			throw ex;
		}

		// create model
		Model model = ModelFactory.createDefaultModel();
		Property domainPro = model
				.createProperty("http://www.w3.org/2000/01/rdf-schema#domain");
		Property rangePro = model
				.createProperty("http://www.w3.org/2000/01/rdf-schema#range");

		String[] filterStrs = { "http://www.openlinksw", "http://www.w3.org/2001/XMLSchema" };
		for (; results.hasNext();) {
			QuerySolution sol = results.next();
			Resource pro = sol.getResource("p");
			Resource dom = sol.getResource("d");
			Resource ren = sol.getResource("r");
			if (pro != null && uriFilter(pro.getURI(), filterStrs) != null) {
				pro = model.createResource(pro);
				if (dom != null) {
					dom = model.createResource(dom);
					pro.addProperty(domainPro, dom);
				}
				if (ren != null) {
					ren = model.createResource(ren);
					pro.addProperty(rangePro, ren);
				}
			}
		}
		qexec.close();
		return model;
	}

	// heavy
	public String[] getDeclaredRDFsClasses() throws Exception {
		String[] filterStrs = { "http://www.openlinksw", "http://www.w3.org" };
		// where
		String[] lines = new String[] { "", "?c rdf:type rdfs:Class.",
				"[] rdf:type ?c.", "[] rdfs:domain ?c.", "[] rdfs:range ?c.",
				"?c rdfs:subclassOf [].", "[] rdfs:subclassOf ?c." };

		StringBuffer queryBuffer = new StringBuffer();
		for (int i = 1; i < lines.length; i++) {
			if (i != 1) {
				queryBuffer.append(" UNION ");
			}
			queryBuffer.append("{");
			queryBuffer.append(lines[i]);
			queryBuffer.append("}\n");
		}
		lines[0] = queryBuffer.toString();

		HashSet<String> resultClassSet = new HashSet<String>();
		for (int i = 0; i < lines.length; i++) {
			queryBuffer = new StringBuffer();
			queryBuffer
					.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
			queryBuffer
					.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
			queryBuffer
					.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
			queryBuffer.append("SELECT DISTINCT ?c  \n");
			if (graphURIs != null && graphURIs.length != 0) {
				for (String graphURI : graphURIs) {
					queryBuffer.append("FROM <");
					queryBuffer.append(graphURI);
					queryBuffer.append(">\n");
				}
			}
			queryBuffer.append("WHERE{\n");
			queryBuffer.append(lines[i]);
			queryBuffer.append("}");

			String queryString = queryBuffer.toString();

			// System.out.println(queryString);

			Query query = QueryFactory.create(queryString);

			QueryExecution qexec = null;
			ResultSet results = null;
			try {
				// long start = System.currentTimeMillis();
				qexec = QueryExecutionFactory.sparqlService(endpointURI, query);
				endpointAccessCount++;
				results = qexec.execSelect();
				// long end = System.currentTimeMillis();
				// System.out.println("EXEC TIME: " + (end - start));
				System.out.print(".");
				for (; results.hasNext();) {
					QuerySolution sol = results.next();
					Resource res = sol.getResource("c");
					if (res != null
							&& uriFilter(res.getURI(), filterStrs) != null) {
						resultClassSet.add(res.getURI());
					}
				}
				qexec.close();
				if (i == 0) {
					break;
				}
			} catch (Exception ex) {
				qexec.close();
				ex.printStackTrace();
				if (i != 0) {
					throw ex;
				}
			}
		}
		return resultClassSet.toArray(new String[0]);
	}

	public String[] getInferedRDFsClassesFromInstances() throws Exception {
		StringBuffer queryBuffer = new StringBuffer();
		queryBuffer.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
		queryBuffer
				.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
		queryBuffer
				.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
		queryBuffer.append("SELECT DISTINCT ?c  \n");
		if (graphURIs != null && graphURIs.length != 0) {
			for (String graphURI : graphURIs) {
				queryBuffer.append("FROM <");
				queryBuffer.append(graphURI);
				queryBuffer.append(">\n");
			}
		}
		queryBuffer.append("WHERE{\n  [] rdf:type ?c. \n");
		queryBuffer.append("}");
		String queryString = queryBuffer.toString();

		// System.out.println(queryString);

		Query query = QueryFactory.create(queryString);

		QueryExecution qexec = null;
		ResultSet results = null;
		try {
			// long start = System.currentTimeMillis();
			qexec = QueryExecutionFactory.sparqlService(endpointURI, query);
			endpointAccessCount++;
			results = qexec.execSelect();
			// long end = System.currentTimeMillis();
			// System.out.println("EXEC TIME: " + (end - start));
			System.out.print(".");
		} catch (Exception ex) {
			ex.printStackTrace();
			throw ex;
		}

		ArrayList<String> resultList = new ArrayList<String>();
		String[] filterStrs = { "http://www.openlinksw", "http://www.w3.org" };
		for (; results.hasNext();) {
			QuerySolution sol = results.next();
			Resource res = sol.getResource("c");
			if (res != null && uriFilter(res.getURI(), filterStrs) != null) {
				resultList.add(res.getURI());
			}
		}
		qexec.close();
		return resultList.toArray(new String[0]);
	}

	public String[] getRDFProperties() throws Exception {
		StringBuffer queryBuffer = new StringBuffer();
		queryBuffer.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
		queryBuffer
				.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
		queryBuffer
				.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
		queryBuffer.append("SELECT DISTINCT ?p  \n");
		if (graphURIs != null && graphURIs.length != 0) {
			for (String graphURI : graphURIs) {
				queryBuffer.append("FROM <");
				queryBuffer.append(graphURI);
				queryBuffer.append(">\n");
			}
		}
		queryBuffer.append("WHERE{\n");
		queryBuffer.append("{  ?s ?p ?o.}\n");
		// queryBuffer.append("UNION\n");
		// queryBuffer.append("{  ?p rdfs:domain ?d.}\n");
		// queryBuffer.append("UNION\n");
		// queryBuffer.append("{  ?p rdfs:range ?r.}\n");
		queryBuffer.append("}");
		String queryString = queryBuffer.toString();

		// System.out.println(queryString);

		Query query = QueryFactory.create(queryString);

		QueryExecution qexec = null;
		ResultSet results = null;
		try {
			// long start = System.currentTimeMillis();
			qexec = QueryExecutionFactory.sparqlService(endpointURI, query);
			endpointAccessCount++;
			results = qexec.execSelect();
			// long end = System.currentTimeMillis();
			// System.out.println("EXEC TIME: " + (end - start));
			System.out.print(".");
		} catch (Exception ex) {
			ex.printStackTrace();
			throw ex;
		}

		ArrayList<String> resultList = new ArrayList<String>();
		String[] filterStrs = { "http://www.openlinksw",
				"http://www.w3.org/1999/02/22-rdf-syntax-ns",
				"http://www.w3.org/2000/01/rdf-schema",
				"http://www.w3.org/2002/07/owl",
				"http://www.w3.org/ns/sparql-service-description" };
		for (; results.hasNext();) {
			QuerySolution sol = results.next();
			Resource res = sol.getResource("p");
			if (res != null && uriFilter(res.getURI(), filterStrs) != null) {
				resultList.add(res.getURI());
			}
		}
		qexec.close();
		return resultList.toArray(new String[0]);
	}

//	public String[] getDomainRangeDeclaredRDFProperties() throws Exception {
//		StringBuffer queryBuffer = new StringBuffer();
//		queryBuffer.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
//		queryBuffer
//				.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
//		queryBuffer
//				.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
//		queryBuffer.append("SELECT DISTINCT ?p \n");
//		if (graphURIs != null && graphURIs.length != 0) {
//			for (String graphURI : graphURIs) {
//				queryBuffer.append("FROM <");
//				queryBuffer.append(graphURI);
//				queryBuffer.append(">\n");
//			}
//		}
//		queryBuffer.append("WHERE{\n");
//		queryBuffer.append("  ?p rdfs:domain ?cs. \n");
//		queryBuffer.append("  ?p rdfs:range ?co. \n");
//		queryBuffer.append("}");
//		String queryString = queryBuffer.toString();
//
//		// System.out.println(queryString);
//
//		Query query = QueryFactory.create(queryString);
//
//		QueryExecution qexec = null;
//		ResultSet results = null;
//		try {
//			// long start = System.currentTimeMillis();
//			qexec = QueryExecutionFactory.sparqlService(endpointURI, query);
//			results = qexec.execSelect();
//			// long end = System.currentTimeMillis();
//			// System.out.println("EXEC TIME: " + (end - start));
//			System.out.print(".");
//		} catch (Exception ex) {
//			ex.printStackTrace();
//			throw ex;
//		}
//
//		ArrayList<String> resultList = new ArrayList<String>();
//		String[] filterStrs = { "http://www.openlinksw" };
//		for (; results.hasNext();) {
//			QuerySolution sol = results.next();
//			Resource res = sol.getResource("p");
//			if (res != null && uriFilter(res.getURI(), filterStrs) != null) {
//				resultList.add(res.getURI());
//			}
//		}
//		qexec.close();
//		return resultList.toArray(new String[0]);
//	}

	public String[] getDatatypes(String[] propertyURIs) throws Exception {
		HashSet<String> datatypes = new HashSet<String>();

		if( propertyURIs != null ){
			for(String propertyURI: propertyURIs){
		StringBuffer queryBuffer = new StringBuffer();
		queryBuffer.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
		queryBuffer
				.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
		queryBuffer
				.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
		queryBuffer.append("SELECT DISTINCT (datatype(?o) AS ?ldt) \n");
		if (graphURIs != null && graphURIs.length != 0) {
			for (String graphURI : graphURIs) {
				queryBuffer.append("FROM <");
				queryBuffer.append(graphURI);
				queryBuffer.append(">\n");
			}
		}
		queryBuffer.append("WHERE{\n");
		queryBuffer.append(" [] <");
		queryBuffer.append(propertyURI);
		queryBuffer.append("> ?o.\n  FILTER(isLiteral(?o))\n");
		queryBuffer.append("}");
		String queryString = queryBuffer.toString();

		// System.out.println(queryString);

		Query query = QueryFactory.create(queryString);

		QueryExecution qexec = null;
		ResultSet results = null;
		try {
			// long start = System.currentTimeMillis();
			qexec = QueryExecutionFactory.sparqlService(endpointURI, query);
			endpointAccessCount++;
			qexec.setTimeout(-1);
			results = qexec.execSelect();
			// long end = System.currentTimeMillis();
			// System.out.println("EXEC TIME: " + (end - start));
			System.out.print(".");
		} catch (Exception ex) {
			ex.printStackTrace();
			throw ex;
		}

		String[] filterStrs = { "http://www.openlinksw",
				"http://www.w3.org/1999/02/22-rdf-syntax-ns",
				"http://www.w3.org/2000/01/rdf-schema",
				"http://www.w3.org/2002/07/owl",
				"http://www.w3.org/ns/sparql-service-description" };
		for (; results.hasNext();) {
			QuerySolution sol = results.next();
			Literal lit = sol.getLiteral("ldt");
			if( lit != null ){
				String litURI = lit.getString();
				if (litURI != null && uriFilter(litURI, filterStrs) != null) {
					datatypes.add(litURI);
				}
			}
		}
		qexec.close();
			}}
		return datatypes.toArray(new String[0]);
	}

	public String uriFilter(String uriStr, String[] filterStrs)
			throws Exception {
		if (filterStrs == null || filterStrs.length == 0) {
			return uriStr;
		}
		for (String str : filterStrs) {
			if (uriStr != null) {
				if (uriStr.startsWith(str)) {
					return null;
				}
			}

		}
		return uriStr;
	}

}
