package jp.riken.accc.db.rdf.virtuoso;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;

// import jp.riken.accc.db.common.CommandExecutor;

import org.apache.jena.iri.IRI;

public class RDFDataUploader {

	private ISQLManager iSQLManager = null;
	private String baseIRIStr = "";
	
	
	public int upload(String reference) throws Exception{
		// TODO
		return 0;
	}
	

	private File[] reference2FileList(String reference) throws Exception{
		File refFile = new File(reference);
		if( !refFile.exists()){
			throw new Exception("File/Directory not found: " + reference);
		}
		if( refFile.isDirectory()){
			File[] files = refFile.listFiles();
			ArrayList<File> fileList = new ArrayList<File>();
			for(File file: files){
				if( file.exists() && file.isFile()){
					fileList.add(file);
				}
			}
			return fileList.toArray(new File[0]);
		}else{
			if( refFile.isFile()){
				return new File[]{refFile};
			}
		}
		throw new Exception("File Internal Error: " + reference);
	}
	
	public String upload_NTriple(String reference, IRI graphMetadataIRI) throws Exception{
		File[] fileList = reference2FileList(reference);
// TODO check format
		
		return addGraph(fileList, "NT", graphMetadataIRI);
	}
	
	
	public String addGraph(File[] localDataFiles, String format,
			IRI graphMetadataIRI) throws Exception {
		// command
		String command = iSQLManager.getCommandString();

		String pre = null;
		String pro = null;
		if (format.equalsIgnoreCase("RDF/XML")) {
			pre = "DB.DBA.RDF_LOAD_RDFXML_MT(file_to_string_output('";
			pro = "'),'" + baseIRIStr + "','" + graphMetadataIRI + "');";
		} else {
			if (format.equalsIgnoreCase("TTL")) {
				pre = "DB.DBA.TTLP_MT(file_to_string_output('";
				pro = "'),'" + baseIRIStr + "','" + graphMetadataIRI + "', 255);";
			} else {
				if (format.equalsIgnoreCase("NT")) {
					pre = "DB.DBA.RDF_LOAD_RDFXML_MT(file_to_string_output('";
					pro = "'),'" + baseIRIStr + ",''" + graphMetadataIRI
							+ "', 255);";
				} else {
					if (format.equalsIgnoreCase("NQ")) {
						pre = "DB.DBA.RDF_LOAD_RDFXML_MT(file_to_string_output('";
						pro = "'),'" + baseIRIStr + "','" + graphMetadataIRI
								+ "', 512);";
					} else {
						throw new Exception("Illegal format: " + format);
					}
				}
			}
		}

		String param1 = "checkpoint;";
		String param2 = "exit;";

		StringBuffer resultSB = new StringBuffer();

		
		for (File file : localDataFiles) {
			// copy the localDataFile to tempDir
			File destinationFile = file;
			String filePath = destinationFile.getCanonicalPath();
			int pos = -1;
			if((pos=filePath.indexOf(":")) >= 0  ){
				filePath = filePath.substring(pos+1);
			}
			filePath = filePath.replaceAll("\\\\","/");
			System.out.println("DataFile: " + filePath);
			
			String param = pre + filePath + pro;
			String[] params = { param, param1, param2 };

			
			
			ByteArrayOutputStream os = new ByteArrayOutputStream();
			PrintWriter pw = new PrintWriter(os);
			ByteArrayOutputStream errOS = new ByteArrayOutputStream();
			PrintWriter errPW = new PrintWriter(errOS);

			System.out.println("ADDGraphExecute: " + param);

			//TODO
			//			CommandExecutor.execute(command, params, pw, errPW);

			if( errOS.size() != 0 ) {
				// error
				ByteArrayInputStream is = new ByteArrayInputStream(errOS.toByteArray());
				BufferedReader br = new BufferedReader(new InputStreamReader(is));
				String buf = null;
				StringBuffer errorSB = new StringBuffer();
				while((buf=br.readLine())!= null ){
					buf = buf.trim();
					errorSB.append(buf);
				}
				throw new Exception(errorSB.toString());
			}

			ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
			BufferedReader br = new BufferedReader(new InputStreamReader(is));
			String buf = null;
			while((buf=br.readLine())!= null ){
				buf = buf.trim();
				resultSB.append(buf);
				resultSB.append("\n");
			}
		System.out.println("ADDGraphExecute done.");
		}
		return resultSB.toString();
	}
}
