package jp.riken.accc.db.sparql;

import java.io.File;
import java.io.FileWriter;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;

public class EndpointClientImpl implements EndpointClient {

	private URL endpointURL = null;
	private Model model;

	public EndpointClientImpl(URL endpointURL){
		this.endpointURL = endpointURL;
	}

	public static void main(String[] args) throws Exception{
		// URLを渡しEndpointClientを実体化
		EndpointClient impl = new EndpointClientImpl(new URL("http://virtuoso-01.ad18.riken.go.jp:8890/sparql"));
		/*
		// 先に結果保存用配列を生成
		URI[] uris = null;
		// グラフURIのリストを取得
		uris = impl.getGraphURIs();
		// 取得したグラフ名の出力
		for(URI uri: uris){
			System.out.println(uri);
		}
		// 結果保存用配列を生成
		URI[] clss = null;
		// グラフのリストを渡しクラスのリストを取得
		clss = impl.getClassURIs(uris);
		// 取得したクラス名の出力
		for(URI cls: clss){
			System.out.println(cls);
		}

		System.out.println("--------------------");

		// 結果保存用配列を生成
		URI[] clss2 = null;
		// グラフ名を指定せずにクラス一覧を取得
		clss2 = impl.getClassURIs();
		// 取得したクラス名の出力
		for(URI cls2: clss2){
			System.out.println(cls2);
		}
		*/

		// デバッグのために一時的にリソースを直接指定
		String uri = "http://bio2rdf.org/pubmed:11290940";

		// 結果取得用モデル
		Model resultModel = null;

		// URIを指定し関連するトリプルとそのラベル及びクラスを取得
		resultModel = impl.getInstanceTable(URI.create(uri));

		// 作成されたモデルを内容確認用にファイル出力
		/*
		File rdffile = new File("C:\\Users\\Lenz\\Desktop\\model.nt");
		rdffile.createNewFile();
		DataOutputStream stream = new DataOutputStream(new FileOutputStream(rdffile));

		RDFDataMgr.write(stream, resultModel, RDFFormat.NTRIPLES);
		*/

		// 結果を元にHTMLファイルを出力する

		// html本体（順次追記していくのでStringBuffer）
		StringBuffer htmlStr = new StringBuffer();

		// ヘッダー周り（タイトルに指定されたインスタンスの名前を設定）
		htmlStr.append("<html>\n\t<head>\n\t\t<title>");
		htmlStr.append(impl.getFilenameWithURIString(uri));
		htmlStr.append("</title>\n\t</head>\n\t<body>\n");

		// インスタンステーブル
		htmlStr.append(impl.model2HTMLTable(resultModel, URI.create(uri)));

		// 終了
		htmlStr.append("\t</body>\n</html>");

		// ファイルに書き出し（戀津のデスクトップで実験、書き換え必須）
		/*
		File htmlfile = new File("C:\\Users\\Lenz\\Desktop\\InstanceTable.html");
		htmlfile.createNewFile();
		FileWriter fr = new FileWriter(htmlfile);

		fr.write(htmlStr.toString());
		fr.close();
		*/

		// ファイル出力の代わりにコンソールに出力
		System.out.println(htmlStr.toString());

		System.out.println("\n\n\n\n-------------------------------------------------------------------------------\n\n\n\n");

		// デバッグのために一時的にリソースを直接指定
		String classuri = "http://bio2rdf.org/pubmed_vocabulary:PubMedRecord";



		// html本体（順次追記していくのでStringBuffer）
		StringBuffer htmlStr2 = new StringBuffer();

		// ヘッダー周り（タイトルに指定されたインスタンスの名前を設定）
		htmlStr2.append("<html>\n\t<head>\n\t\t<title>");
		htmlStr2.append(classuri);
		htmlStr2.append("</title>\n\t</head>\n\t<body>\n");

		// インスタンステーブル
		htmlStr2.append(impl.makeClassTable(URI.create(classuri)));

		// 終了
		htmlStr2.append("\t</body>\n</html>");

		// ファイルに書き出し（戀津のデスクトップで実験、書き換え必須）

		File htmlfile = new File("C:\\Users\\Lenz\\Desktop\\ClassInstanceTable.html");
		htmlfile.createNewFile();
		FileWriter fr = new FileWriter(htmlfile);

		fr.write(htmlStr2.toString());
		fr.close();
	}

	public URI[] getGraphURIs() throws Exception{
		// クエリ本体（順次追記していくのでStringBuffer）
		StringBuffer queryStr = new StringBuffer();

		// 略称とURIの対応を宣言
		queryStr.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
		queryStr.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
		queryStr.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");

		// クエリ（グラフのリストを取得）
		queryStr.append("SELECT DISTINCT ?g\nWHERE {\nGRAPH ?g {\n?s ?p ?o }\n}");

		// クエリ文の出力
		System.out.println(queryStr.toString());

		// グラフURI保存用配列を生成
		URI[] uriList = null;

		// クエリで指定した変数名
		String var = "g";
		// 生成したクエリと返り値として欲しい変数名をクエリ実行メソッドに渡し結果を取得
		uriList = this.getURIs(queryStr.toString(), var);

		// 結果のURIリストを返す
		return uriList;
	}

	public URI[] getClassURIs(URI[] graphURIs) throws Exception {
		// クエリ本体（順次追記していくのでStringBuffer）
		StringBuffer queryStr = new StringBuffer();

		// プレフィックス
		queryStr.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
		queryStr.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
		queryStr.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");

		// クエリ（クラスのリストを取得）
		queryStr.append("SELECT DISTINCT ?cls \n");

		// 指定されたグラフのURIの数だけクエリに追記
		if (graphURIs != null) {
			for (URI graphURI : graphURIs) {
				queryStr.append("FROM <");
				queryStr.append(graphURI.toString());
				queryStr.append(">\n");
			}
		}
		queryStr.append("WHERE{\n");
		queryStr.append("\t{ ?cls rdf:type rdfs:Class. }\n");
		queryStr.append("\tUNION\n");
		queryStr.append("\t{ ?cls rdf:type owl:Class. }\n");
		queryStr.append("\tUNION\n");
		queryStr.append("\t{ [] rdfs:type ?cls. }\n");
		queryStr.append("\tUNION\n");
		queryStr.append("\t{ [] rdfs:domain ?cls. }\n");
		queryStr.append("\tUNION\n");
		queryStr.append("\t{ [] rdfs:range ?cls. }\n");
		queryStr.append("\tUNION\n");
		queryStr.append("\t{ ?cls rdfs:subclassOf []. }\n");
		queryStr.append("\t?cls rdfs:label ?pLabel.\n");
		queryStr.append("}");

		// クエリ文の出力
		System.out.println(queryStr.toString());

		// グラフURI保存用配列を生成
		URI[] uriList = null;

		// クエリで指定した変数名
		String var = "cls";
		// 生成したクエリと返り値として欲しい変数名をクエリ実行メソッドに渡し結果を取得
		uriList = this.getURIs(queryStr.toString(), var);

		// 結果のURIリストを返す
		return uriList;
	}

	// グラフ指定なしでデータベース上にある全てのクラスを返すメソッド
	public URI[] getClassURIs() throws Exception {
		return getClassURIs(null);
	}

	// クエリを受け付けて結果をURIリストで返す
	public URI[] getURIs(String sparqlQuery, String var) throws Exception {
		// クエリ文から実行可能なクエリ本体を生成
		Query query = QueryFactory.create(sparqlQuery);

		// クエリ実行本体と結果を空で生成
		QueryExecution qexec = null;
		ResultSet results = null;
		try {
			// クエリ開始時間を取得
			long start = System.currentTimeMillis();
			// クエリの実行
			qexec = QueryExecutionFactory.sparqlService(endpointURL.toString(), query);
			// 実行結果の取得
			results = qexec.execSelect();
			// クエリ完了時間を取得
			long end = System.currentTimeMillis();
			// クエリの実行にかかった時間を出力
			System.out.println("EXEC TIME: " + (end - start));
		} catch (Exception ex) {
			// 例外が発生したら出力
			ex.printStackTrace();
			throw ex;
		}

		// グラフURI保存用配列を生成
		ArrayList<URI> uriList = new ArrayList<URI>();

		// 結果の数だけ繰り返しながら
		for (; results.hasNext();) {
			// 結果を一つ取得
			QuerySolution sol = results.next();
			// 変数名を指定しリソースを取得
			Resource res = sol.getResource(var);
			// リソースが空でなければ
			if (res != null) {
				// そのリソースのURIを取得
				String uri = res.getURI();
				// 取得したURIを保存
				uriList.add(URI.create(uri));
			}
		}
		// クエリ本体の終了
		qexec.close();

		// 取得した結果を配列に変換し返す
		return uriList.toArray(new URI[0]);
	}

	// 指定されたインスタンスを主語または目的語として持つトリプルのリスト、及びそれらに関わるクラスとラベルを取得
	public Model getInstanceTable(URI subjectURI) throws Exception {

		// 送られてきたURIの元の形を文字列で保持
		String subjectURIStr = subjectURI.toString();

		// 送られてきたURIがhttp://で始まっているならば前後に<>をつける
		String subjectStr = subjectURI.toString();
		if(subjectStr.startsWith("http://")){
			// この文字列をクエリに使う
			subjectStr = "<" + subjectStr + ">";
		}else{
			// TODO: http://の形ではないもの（プレフィクス依存またはエラー）が送られてきた時の処理
		}

		// クエリ本体（順次追記していくのでStringBuffer）
		StringBuffer queryStr = new StringBuffer();

		// プレフィックス
		queryStr.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
		queryStr.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
		queryStr.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");

		// クエリ（クラスのリストを取得）
		queryStr.append("SELECT DISTINCT ?p ?pres ?q ?qres ?pcls ?plabel ?rpcls ?rplabel ?rqcls ?rqlabel ?qcls ?qlabel \n");

		queryStr.append("WHERE{\n");
		queryStr.append("\t{ " + subjectStr + " ?p ?pres.\n");
		queryStr.append("\t\tOPTIONAL{\n");
		queryStr.append("\t\t\t?p rdf:type ?pcls.\n");
		queryStr.append("\t\t}\n");
		queryStr.append("\t\tOPTIONAL{\n");
		queryStr.append("\t\t\t?p rdfs:label ?plabel.\n");
		queryStr.append("\t\t}\n");
		queryStr.append("\t\tOPTIONAL{\n");
		queryStr.append("\t\t\t?pres rdf:type ?rpcls.\n");
		queryStr.append("\t\t}\n");
		queryStr.append("\t\tOPTIONAL{\n");
		queryStr.append("\t\t\t?pres rdfs:label ?rplabel.\n");
		queryStr.append("\t\t}\n");
		queryStr.append("\t}\n");
		queryStr.append("\n");
		queryStr.append("\tUNION\n");
		queryStr.append("\n");
		queryStr.append("\t{ ?qres ?q " + subjectStr + ".\n");
		queryStr.append("\t\tOPTIONAL{\n");
		queryStr.append("\t\t\t?qres rdf:type ?rqcls.\n");
		queryStr.append("\t\t}\n");
		queryStr.append("\t\tOPTIONAL{\n");
		queryStr.append("\t\t\t?qres rdfs:label ?rqlabel.\n");
		queryStr.append("\t\t}\n");
		queryStr.append("\t\tOPTIONAL{\n");
		queryStr.append("\t\t\t?q rdf:type ?qcls.\n");
		queryStr.append("\t\t}\n");
		queryStr.append("\t\tOPTIONAL{\n");
		queryStr.append("\t\t\t?q rdfs:label ?qlabel.\n");
		queryStr.append("\t\t}\n");
		queryStr.append("\t}\n");
		queryStr.append("}");

		// クエリ文の出力
		System.out.println(queryStr.toString());

		// クエリ文から実行可能なクエリ本体を生成
		Query query = QueryFactory.create(queryStr.toString());

		// クエリ実行本体と結果を空で生成
		QueryExecution qexec = null;
		ResultSet results = null;
		try {
			// クエリ開始時間を取得
			long start = System.currentTimeMillis();
			// クエリの実行
			qexec = QueryExecutionFactory.sparqlService(endpointURL.toString(), query);
			// 実行結果の取得
			results = qexec.execSelect();
			// クエリ完了時間を取得
			long end = System.currentTimeMillis();
			// クエリの実行にかかった時間を出力
			System.out.println("EXEC TIME: " + (end - start));
		} catch (Exception ex) {
			// 例外が発生したら出力
			ex.printStackTrace();
			throw ex;
		}

		// リソース・プロパティ等作成用のmodel
		model = ModelFactory.createDefaultModel();

		// 返り値用のmodelを作成
		Model queryResultModel = ModelFactory.createDefaultModel();

		// 指定されたURIからリソースを作成
		Resource sub = model.createResource(subjectURIStr);

		// 変数を空で宣言
		Property proForward = null;
		Resource pres = null;
		Literal lpres = null;
		Resource pcls = null;
		Literal plabel = null;
		Resource rpcls = null;
		Literal rplabel = null;
		Property proReverse = null;
		Resource qres = null;
		Resource qcls = null;
		Literal qlabel = null;
		Resource rqcls = null;
		Literal rqlabel = null;

		// 結果の数だけ繰り返しながら
		for (; results.hasNext();) {
			// 結果を一つ取得
			QuerySolution sol = results.next();

			// 変数を空に
			proForward = null;
			pres = null;
			lpres = null;
			pcls = null;
			plabel = null;
			rpcls = null;
			rplabel = null;
			proReverse = null;
			qres = null;
			qcls = null;
			qlabel = null;
			rqcls = null;
			rqlabel = null;

			// 変数名を指定し値があれば
			if(sol.contains("p")){
				// modelを使いプロパティを作成
				proForward = model.createProperty(sol.getResource("p").toString());
			}
			// 変数名を指定し値があれば
			if(sol.contains("pres")){
				// 中身がリソースならば
				if(sol.get("pres").isResource()){
					// modelを使いリソースを作成
					pres = model.createResource(sol.getResource("pres").toString());
				// リソースでなければ
				}else{
					// modelを使いリテラルを作成
					lpres = model.createLiteral(sol.getLiteral("pres").toString());
				}
			}
			// 以下同じ
			if(sol.contains("q")){
				proReverse = model.createProperty(sol.getResource("q").toString());
			}
			if(sol.contains("qres")){
				qres = model.createResource(sol.getResource("qres").toString());
			}
			if(sol.contains("pcls")){
				pcls = model.createResource(sol.getResource("pcls").toString());
			}
			if(sol.contains("plabel")){
				plabel = model.createLiteral(sol.getLiteral("plabel").toString());
			}
			if(sol.contains("rpcls")){
				rpcls = model.createResource(sol.getResource("rpcls").toString());
			}
			if(sol.contains("rplabel")){
				rplabel = model.createLiteral(sol.getLiteral("rplabel").toString());
			}
			if(sol.contains("rqcls")){
				rqcls = model.createResource(sol.getResource("rqcls").toString());
			}
			if(sol.contains("rqlabel")){
				rqlabel = model.createLiteral(sol.getLiteral("rqlabel").toString());
			}
			if(sol.contains("qcls")){
				qcls = model.createResource(sol.getResource("qcls").toString());
			}
			if(sol.contains("qlabel")){
				qlabel = model.createLiteral(sol.getLiteral("qlabel").toString());
			}

			// ここまでで結果の取得完了
			// ここから取得した結果からステートメントを作成しmodelに追加

			// 述語のフォワード側があった時
			if(proForward != null){
				// presがnullでなければ（目的語がリソースだったなら）
				if(pres != null){
					// 指定されたURI、取得された述語と目的語でステートメントを作成
					Statement st = model.createStatement(sub, proForward, pres);
					// 作成したステートメントをモデルに追加
					queryResultModel.add(st);
				// nullだったら（目的語がリテラルだったなら）
				}else{
					// 指定されたURI、取得された述語と目的語でステートメントを作成
					Statement st = model.createStatement(sub, proForward, lpres);
					// 作成したステートメントをモデルに追加
					queryResultModel.add(st);
				}
			}
			// 述語のリバース側とリソースがあった時
			// 以下同じ
			if(qres != null && proReverse != null){
				Statement st = model.createStatement(qres, proReverse, sub);
				queryResultModel.add(st);
			}

			if(pcls != null){
				Statement st = model.createStatement(proForward, model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), pcls);
				queryResultModel.add(st);
			}
			if(plabel != null){
				Statement st = model.createStatement(proForward, model.createProperty("http://www.w3.org/2000/01/rdf-schema#label"), plabel);
				queryResultModel.add(st);
			}

			if(rpcls != null && pres != null){
				Statement st = model.createStatement(pres, model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), rpcls);
				queryResultModel.add(st);
			}
			if(rplabel != null && pres != null){
				Statement st = model.createStatement(pres, model.createProperty("http://www.w3.org/2000/01/rdf-schema#label"), rplabel);
				queryResultModel.add(st);
			}

			if(qcls != null){
				Statement st = model.createStatement(proReverse, model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), qcls);
				queryResultModel.add(st);
			}
			if(qlabel != null){
				Statement st = model.createStatement(proReverse, model.createProperty("http://www.w3.org/2000/01/rdf-schema#label"), qlabel);
				queryResultModel.add(st);
			}

			if(rqcls != null){
				Statement st = model.createStatement(qres, model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), rqcls);
				queryResultModel.add(st);
			}
			if(rqlabel != null){
				Statement st = model.createStatement(qres, model.createProperty("http://www.w3.org/2000/01/rdf-schema#label"), rqlabel);
				queryResultModel.add(st);
			}
		}
		// クエリ本体の終了
		qexec.close();

		// ここまでで作成したモデルを返す
		return queryResultModel;
	}

	public String model2HTMLTable(Model modelGraph, URI subjectURI)
			throws Exception {

		// テーブル部分（順次追記していくのでStringBuffer）
		StringBuffer tableStr = new StringBuffer();
		// 追記用文字列
		String append = "";

		// 検索用のリソース系（まずは指定インスタンスのラベルを指定）
		Resource selectSubject = model.createResource(subjectURI.toString());
		Property selectProperty = model.createProperty("http://www.w3.org/2000/01/rdf-schema#label");
		Resource selectObject = null;

		// 検索を実行
		StmtIterator selectInstanceLabel = modelGraph.listStatements(selectSubject, selectProperty, selectObject);

		// 検索結果が0件でなければ
		if(selectInstanceLabel.hasNext()){
			// ラベルを表示、URIをリンクにしたアンカータグを追記用文字列に指定
			append = "\t\t<h1><a href=\"" + subjectURI.toString() + "\">" + selectInstanceLabel.nextStatement().getObject().toString() + "</a></h1>\n";
		// 検索結果が0件なら
		}else{
			// URIをそのURIへのリンクを張った状態にして追記用文字列に指定
			append = "\t\t<h1><a href=\"" + subjectURI.toString() + "\">" + subjectURI.toString() + "</a></h1>\n";
		}

		// 作成した文字列を追加
		tableStr.append(append);

		// テーブルタグ開始
		tableStr.append("\t\t<table border=\"2\">\n");
		// テーブルのヘッダーを設定
		tableStr.append("\t\t\t<th>Property</th><th>Object</th>\n");

		// プロパティを空に
		selectProperty = null;

		// プロパティが空の状態で再検索（指定インスタンスに関わるトリプルをすべて取得）
		StmtIterator selectBySubject = modelGraph.listStatements(selectSubject, selectProperty, selectObject);

		// 検索結果の数だけ繰り返しながら
		while(selectBySubject.hasNext()){
			// 結果をステートメントとして取得
			Statement st = selectBySubject.nextStatement();

			// 指定インスタンスのラベル（トップで表示済み）をスキップ
			if(st.getPredicate().toString() != "http://www.w3.org/2000/01/rdf-schema#label"){

				// テーブルの列とセルひとつ分のタグを追記
				tableStr.append("\t\t\t<tr><td>");

				// 追記用文字列を空に
				append = "";

				// 今回の述語を主語としたラベルのトリプルを検索
				selectSubject = model.createResource(st.getPredicate().toString());
				selectProperty = model.createProperty("http://www.w3.org/2000/01/rdf-schema#label");
				selectObject = null;

				StmtIterator selectPredicateLabel = modelGraph.listStatements(selectSubject, selectProperty, selectObject);

				// ラベルが見つかれば
				if(selectPredicateLabel.hasNext()){
					// ラベルを表示、URIをリンクにしたアンカータグを追記用文字列に指定
					append = "<a href=\"" + st.getPredicate().toString() + "\">" + this.getFilenameWithURIString(selectPredicateLabel.nextStatement().getObject().toString()) + "</a>";
				// 見つからなければ
				}else{
					// URIをそのURIへのリンクを張った状態にして追記用文字列に指定
					append = "<a href=\"" + st.getPredicate().toString() + "\">" + this.getFilenameWithURIString(st.getPredicate().toString()) + "</a>";
				}


				// 今回の述語を主語としたクラスのトリプルを検索
				selectProperty = model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");

				StmtIterator selectPredicateClass = modelGraph.listStatements(selectSubject, selectProperty, selectObject);

				// クラスが見つかれば
				if(selectPredicateClass.hasNext()){
					// 同じセル内に改行してクラスへのリンクを追記
					String classURI = selectPredicateClass.nextStatement().getObject().toString();
					append = append + "<br>Class:<a href=\"" + classURI + "\">" + this.getFilenameWithURIString(classURI) + "</a>";
				}

				// ここまででできたセルの内容を追記し次のセルへ
				tableStr.append(append + "</td><td>");

				// 追記用文字列を空に
				append = "";


				// 目的語がリソースだったなら
				if(st.getObject().isResource()){
					// 今回の目的語を主語としたラベルのトリプルを検索
					selectSubject = model.createResource(st.getObject().toString());
					selectProperty = model.createProperty("http://www.w3.org/2000/01/rdf-schema#label");
					selectObject = null;

					StmtIterator selectObjectLabel = modelGraph.listStatements(selectSubject, selectProperty, selectObject);

					// ラベルが見つかれば
					if(selectObjectLabel.hasNext()){
						// ラベルを表示、URIをリンクにしたアンカータグを追記用文字列に指定
						append = "<a href=\"" + st.getObject().toString() + "\">" + this.getFilenameWithURIString(selectObjectLabel.nextStatement().getObject().toString()) + "</a>";
					// 見つからなければ
					}else{
						// URIをそのURIへのリンクを張った状態にして追記用文字列に指定
						append = "<a href=\"" + st.getObject().toString() + "\">" + this.getFilenameWithURIString(st.getObject().toString()) + "</a>";
					}

					// 今回の目的語を主語としたクラスのトリプルを検索
					selectProperty = model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");

					StmtIterator selectObjectClass = modelGraph.listStatements(selectSubject, selectProperty, selectObject);

					// クラスが見つかれば
					if(selectObjectClass.hasNext()){
						// 同じセル内に改行してクラスへのリンクを追記
						String classURI = selectObjectClass.nextStatement().getObject().toString();
						append = append + "<br>Class:<a href=\"" + classURI + "\">" + this.getFilenameWithURIString(classURI) + "</a>";
					}

				// 目的語がリテラルだったなら
				}else{
					// セル内に直接リテラルを追記
					append = st.getObject().toString();
				}

				// ここまででできたセルの内容を追記しセルと行を閉じる
				tableStr.append(append + "</td></tr>\n");
			}
		}

		// テーブルタグを閉じる
		tableStr.append("\t\t</table>\n");

		// ここまででできたテーブル部分のHTMLを文字列として返す
		return tableStr.toString();
	}

	// URIを文字列で受け取り、その中のファイル名にあたる部分を切り出し返す
	public String getFilenameWithURIString(String baseURI) throws Exception {

		// /で区切った最後の部分を取得
		String[] splitStr = baseURI.split("/", 0);
		String filename = splitStr[splitStr.length - 1];

		// 上記結果をさらに#で区切った最後の部分を取得
		splitStr = filename.split("#", 0);
		filename = splitStr[splitStr.length - 1];

		// 作成した文字列を返す
		return filename;
	}

	public String makeClassTable(URI classURI) throws Exception {

		Model classModel = this.getInstanceWithClassURI(classURI);

		ArrayList<String> instanceList = this.getInstanceList(classModel);

		ArrayList<String> propertyList = this.getInstancePropertyList(classModel);

		ArrayList<String> labelList = this.getInstancePropertyLabelList(classModel, propertyList);


		StringBuffer tableStr = new StringBuffer();

		tableStr.append("<table border=\"2\"><tr>");

		tableStr.append("<th>Instance</th>");

		for(int i = 0; i < propertyList.size(); i++){
			tableStr.append("<th><a href=\"" + propertyList.get(i) + "\">" + labelList.get(i) + "</a></th>");
		}

		tableStr.append("</tr>");

		Resource selectObject = null;

		for(int i = 0; i < instanceList.size(); i++){

			String instance = instanceList.get(i);

			tableStr.append("<tr>");

			tableStr.append("<td>" + instance + "</td>");

			for(int j = 0; j < propertyList.size(); j++){

				// 検索用のリソース系（まずは指定インスタンスのラベルを指定）
				Resource selectSubject = model.createResource(instance);
				Property selectProperty = model.createProperty(propertyList.get(j));

				tableStr.append("<td>");
				// 検索を実行
				StmtIterator selectInstance = classModel.listStatements(selectSubject, selectProperty, selectObject);
				if(selectInstance.hasNext()){
					tableStr.append(selectInstance.next().getObject().toString());
				}
				tableStr.append("</td>");
			}
			tableStr.append("</tr>");
		}
		tableStr.append("</table>");

		return tableStr.toString();
	}

	public Model getInstanceWithClassURI(URI classURI) throws Exception {

		// 送られてきたURIがhttp://で始まっているならば前後に<>をつける
		String classStr = classURI.toString();
		if(classStr.startsWith("http://")){
			// この文字列をクエリに使う
			classStr = "<" + classStr + ">";
		}else{
			// TODO: http://の形ではないもの（プレフィクス依存またはエラー）が送られてきた時の処理
		}

		// クエリ本体（順次追記していくのでStringBuffer）
		StringBuffer queryStr = new StringBuffer();

		// プレフィックス
		queryStr.append("PREFIX owl: <http://www.w3.org/2002/07/owl#>\n");
		queryStr.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
		queryStr.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");

		// クエリ（クラスのリストを取得）
		queryStr.append("SELECT DISTINCT ?ins ?insp ?inso ?insl \n");

		queryStr.append("WHERE{\n");
		queryStr.append("\t{ ?ins rdf:type " + classStr + ".\n");
		queryStr.append("\t\tOPTIONAL{\n");
		queryStr.append("\t\t\t?ins ?insp ?inso.\n");
		queryStr.append("\t\t}\n");
		queryStr.append("\t\tOPTIONAL{\n");
		queryStr.append("\t\t\t?insp rdfs:label ?insl.\n");
		queryStr.append("\t\t}\n");
		queryStr.append("\t}\n");
		queryStr.append("}");

		// クエリ文の出力
		System.out.println(queryStr.toString());

		// クエリ文から実行可能なクエリ本体を生成
		Query query = QueryFactory.create(queryStr.toString());

		// クエリ実行本体と結果を空で生成
		QueryExecution qexec = null;
		ResultSet results = null;
		try {
			// クエリ開始時間を取得
			long start = System.currentTimeMillis();
			// クエリの実行
			qexec = QueryExecutionFactory.sparqlService(endpointURL.toString(), query);
			// 実行結果の取得
			results = qexec.execSelect();
			// クエリ完了時間を取得
			long end = System.currentTimeMillis();
			// クエリの実行にかかった時間を出力
			System.out.println("EXEC TIME: " + (end - start));
		} catch (Exception ex) {
			// 例外が発生したら出力
			ex.printStackTrace();
			throw ex;
		}

		// リソース・プロパティ等作成用のmodel
		model = ModelFactory.createDefaultModel();

		// 返り値用のmodelを作成
		Model queryResultModel = ModelFactory.createDefaultModel();

		// 変数を空で宣言
		Resource ins = null;
		Property insp = null;
		Resource rinso = null;
		Literal linso = null;
		Literal insl = null;

		// 結果の数だけ繰り返しながら
		for (; results.hasNext();) {
			// 結果を一つ取得
			QuerySolution sol = results.next();

			// 変数を空に
			ins = null;
			insp = null;
			rinso = null;
			linso = null;

			// 変数名を指定し値があれば
			if(sol.contains("ins")){
				// modelを使いリソースを作成
				ins = model.createResource(sol.getResource("ins").toString());
			}
			// 変数名を指定し値があれば
			if(sol.contains("insp")){
				// modelを使いプロパティを作成
				insp = model.createProperty(sol.getResource("insp").toString());
			}
			// 変数名を指定し値があれば
			if(sol.contains("inso")){
				// 中身がリソースならば
				if(sol.get("inso").isResource()){
					// modelを使いリソースを作成
					rinso = model.createResource(sol.getResource("inso").toString());
				// リソースでなければ
				}else{
					// modelを使いリテラルを作成
					linso = model.createLiteral(sol.getLiteral("inso").toString());
				}
			}
			// 変数名を指定し値があれば
			if(sol.contains("insl")){
				// modelを使いプロパティを作成
				insl = model.createLiteral(sol.getLiteral("insl").toString());
			}

			// ここまでで結果の取得完了
			// ここから取得した結果からステートメントを作成しmodelに追加

			if(ins != null){
				Statement st = model.createStatement(ins, model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), model.createResource(classURI.toString()));
				queryResultModel.add(st);

				if(insp != null){
					if(rinso != null){
						st = model.createStatement(ins, insp, rinso);
						queryResultModel.add(st);
					}
					if(linso != null){
						st = model.createLiteralStatement(ins, insp, linso);
						queryResultModel.add(st);
					}
				}
				if(insl != null){
					st = model.createLiteralStatement(insp, model.createProperty("http://www.w3.org/2000/01/rdf-schema#label"), insl);
				}
			}
		}
		// クエリ本体の終了
		qexec.close();

		// ここまでで作成したモデルを返す
		return queryResultModel;
	}

	public ArrayList<String> getInstanceList(Model modelGraph) throws Exception {

		ArrayList<String> insList = new ArrayList<String>();

		// 検索用のリソース系（まずは指定インスタンスのラベルを指定）
		Resource selectSubject = null;
		Property selectProperty = model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
		Resource selectObject = null;

		// 検索を実行
		StmtIterator selectInstance = modelGraph.listStatements(selectSubject, selectProperty, selectObject);

		String next = "";

		// 検索結果の数だけ繰り返しながら
		while(selectInstance.hasNext()){
			next = selectInstance.nextStatement().getSubject().toString();
			if(insList.indexOf(next) == -1){
				insList.add(next);
			}
		}

		return insList;
	}

	public ArrayList<String> getInstancePropertyList(Model modelGraph)
			throws Exception {

		ArrayList<String> proList = new ArrayList<String>();

		// 検索を実行
		StmtIterator selectInstanceProperty = modelGraph.listStatements();

		String next = "";

		// 検索結果の数だけ繰り返しながら
		while(selectInstanceProperty.hasNext()){
			next = selectInstanceProperty.nextStatement().getPredicate().toString();
			if(proList.indexOf(next) == -1 && !next.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")){
				proList.add(next);
			}
		}

		return proList;
	}

	public ArrayList<String> getInstancePropertyLabelList(Model modelGraph, ArrayList<String> proList)
			throws Exception {

		ArrayList<String> labelList = new ArrayList<String>();


		// 検索用のリソース系（まずは指定インスタンスのラベルを指定）
		Resource selectSubject = null;
		Property selectProperty = model.createProperty("http://www.w3.org/2000/01/rdf-schema#label");
		Resource selectObject = null;

		for(int i = 0; i < proList.size(); i++){
			selectSubject = model.createResource(proList.get(i));
			// 検索を実行
			StmtIterator selectLabel = modelGraph.listStatements(selectSubject, selectProperty, selectObject);

			if(selectLabel.hasNext()){
				labelList.add(selectLabel.nextStatement().getObject().toString());
			}else{
				labelList.add(this.getFilenameWithURIString(proList.get(i)));
			}
		}

		return labelList;
	}

}
