package org.biohackathon.SPARQLBuilder.OWL;

import java.util.HashSet;

/**
 * インスタンスへ、あるいはインスタンスからの1ステップリンクを記述する
 * @author Norio KOBAYASHI
 * @since 28.01.2014
 * @version 29.01.2014
 */
public class InstanceLink {

	private String propertyURI = null;
	private String[] linkedClassURIs = null;
	private String linkedInstanceURI = null;
	private Direction direction = null;


	/**
	 * プロパティURI、リンク先（元）インスタンス、リンクの向きを与える構成子
	 * <BR>
	 * リンク先 (元) インスタンスについては、それが属しているすべてのクラスも与える
	 * 
	 * @param propertyURI　プロパティのURI
	 * @param linkedInstanceURI　リンクの主語、、あるいはリンクの目的語となっているインスタンスのURI
	 * @param linkedClassURIs　linkedInstanceURIのインスタンスが属しているすべてのクラスのURIの配列
	 * @param direction プロパティの向き、linkedClassURIのクラスがリンク先になっているときはDirection.forward,リンク元になっているときはDirection.reverse, それら両方の時はDirection.bothを指定する 
	 * @throws Exception
	 * @since 28.01.2014
	 */
	public InstanceLink(String propertyURI, String linkedInstanceURI, String[] linkedClassURIs, Direction direction){
		this.propertyURI = propertyURI;
		this.linkedInstanceURI = linkedInstanceURI;
		this.linkedClassURIs = linkedClassURIs;
		this.direction = direction;
	}
	

	/**
	 * linkedInstanceURIのインスタンスが属しているクラスを一つ追加する
	 * 
	 * @param classURI　追加するlinkedInstanceURIのインスタンスが属しているクラスのURI
	 * @throws Exception
	 * @since 28.01.2014
	 */
	public void addLinkedClassURI(String classURI){
		if( linkedClassURIs == null || linkedClassURIs.length == 0 ){
			linkedClassURIs = new String[]{classURI};
		}else{
			HashSet<String> hSet = new HashSet<String>();
			for(String clsURI: linkedClassURIs){
				hSet.add(clsURI);
			}
			hSet.add(classURI);
			linkedClassURIs = hSet.toArray(new String[0]);
		}
	}
	
	/**
	 * 文字列表記を取得する
	 * 
	 * @since 28.01.2014
	 */
	public String toString(){
		StringBuffer sb = new StringBuffer();
		sb.append(propertyURI);
		if( direction == Direction.forward ){
			sb.append(" --> ");
		}else{
			if( direction == Direction.reverse ){
			sb.append(" <-- ");
			}else{
				sb.append(" <-> ");
			}
		}
		sb.append(linkedInstanceURI);
		sb.append(" rdf:type [");
		if( linkedClassURIs != null ){
			for( int i = 0; i < linkedClassURIs.length; i++ ) {
				if( i != 0 ) {
					sb.append(", ");
				}
				sb.append(linkedClassURIs[i]);
			}
		}
		sb.append("]");
		return sb.toString();
	}
	
	public String getPropertyURI() {
		return propertyURI;
	}
	public void setPropertyURI(String propertyURI) {
		this.propertyURI = propertyURI;
	}
	public String[] getLinkedClassURIs() {
		return linkedClassURIs;
	}
	public void setLinkedClassURIs(String[] linkedClassURIs) {
		this.linkedClassURIs = linkedClassURIs;
	}
	public Direction getDirection() {
		return direction;
	}
	public void setDirection(Direction direction) {
		this.direction = direction;
	}

	public String getLinkedInstanceURI() {
		return linkedInstanceURI;
	}

	public void setLinkedInstanceURI(String linkedInstanceURI) {
		this.linkedInstanceURI = linkedInstanceURI;
	}
		
	// private String[] propertyDomainClassURIs = null;
	// private String[] propertyRangeClassURIs = null;

		

}
