/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.http;

import java.io.File;
import java.io.IOException;
import org.openrdf.http.client.HTTPClient;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.util.LiteralUtil;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.http.HTTPRepositoryConnection;
import org.openrdf.rio.RDFFormat;

public class HTTPRepository
implements Repository {
    private final HTTPClient httpClient = new HTTPClient();
    private File dataDir;
    private boolean initialized = false;

    private HTTPRepository() {
        this.httpClient.setValueFactory(new ValueFactoryImpl());
    }

    public HTTPRepository(String serverURL, String repositoryID) {
        this();
        this.httpClient.setServerURL(serverURL);
        this.httpClient.setRepositoryID(repositoryID);
    }

    public HTTPRepository(String repositoryURL) {
        this();
        this.httpClient.setRepositoryURL(repositoryURL);
    }

    HTTPClient getHTTPClient() {
        return this.httpClient;
    }

    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public void initialize() throws RepositoryException {
        this.initialized = true;
    }

    public void shutDown() throws RepositoryException {
        this.initialized = false;
        this.httpClient.shutDown();
    }

    public ValueFactory getValueFactory() {
        return this.httpClient.getValueFactory();
    }

    public RepositoryConnection getConnection() throws RepositoryException {
        return new HTTPRepositoryConnection(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWritable() throws RepositoryException {
        if (!this.initialized) {
            throw new IllegalStateException("HTTPRepository not initialized.");
        }
        boolean isWritable = false;
        String repositoryURL = this.httpClient.getRepositoryURL();
        try {
            TupleQueryResult repositoryList = this.httpClient.getRepositoryList();
            try {
                while (repositoryList.hasNext()) {
                    BindingSet bindingSet = (BindingSet)repositoryList.next();
                    Value uri = bindingSet.getValue("uri");
                    if (uri == null || !uri.stringValue().equals(repositoryURL)) continue;
                    isWritable = LiteralUtil.getBooleanValue(bindingSet.getValue("writable"), false);
                    break;
                }
            }
            finally {
                repositoryList.close();
            }
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException(e);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        return isWritable;
    }

    public void setPreferredTupleQueryResultFormat(TupleQueryResultFormat format) {
        this.httpClient.setPreferredTupleQueryResultFormat(format);
    }

    public TupleQueryResultFormat getPreferredTupleQueryResultFormat() {
        return this.httpClient.getPreferredTupleQueryResultFormat();
    }

    public void setPreferredRDFFormat(RDFFormat format) {
        this.httpClient.setPreferredRDFFormat(format);
    }

    public RDFFormat getPreferredRDFFormat() {
        return this.httpClient.getPreferredRDFFormat();
    }

    public void setUsernameAndPassword(String username, String password) {
        this.httpClient.setUsernameAndPassword(username, password);
    }
}

