/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.optimizer.reorder;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.PatternElements;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;

public final class PatternTriple {
    public Item subject;
    public Item predicate;
    public Item object;

    public static PatternTriple parse(Item pt) {
        ItemList list = pt.getList();
        return new PatternTriple(list.get(0), list.get(1), list.get(2));
    }

    public PatternTriple(Item s, Item p, Item o) {
        this.set(PatternTriple.normalize(s), PatternTriple.normalize(p), PatternTriple.normalize(o));
    }

    private void set(Item s, Item p, Item o) {
        this.subject = s;
        this.predicate = p;
        this.object = o;
    }

    public PatternTriple(Node s, Node p, Node o) {
        this.set(PatternTriple.normalize(s), PatternTriple.normalize(p), PatternTriple.normalize(o));
    }

    public PatternTriple(Triple triple) {
        this(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public String toString() {
        return this.subject + " " + this.predicate + " " + this.object;
    }

    private static Item normalize(Item x) {
        return x != null ? x : PatternElements.ANY;
    }

    private static Item normalize(Node x) {
        return x != null ? Item.createNode(x) : PatternElements.ANY;
    }
}

