/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.app;

import info.aduna.app.AppVersion;
import info.aduna.app.config.Configuration;
import info.aduna.app.logging.LogConfiguration;
import info.aduna.app.net.ProxySettings;
import info.aduna.app.util.ConfigurationUtil;
import info.aduna.platform.PlatformFactory;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class AppConfiguration
implements Configuration {
    private static final String APP_CONFIG_FILE = "application.properties";
    private static final String DEFAULT_LONGNAME_PREFIX = "Aduna";
    private static final String DEFAULT_LOGGING_IMPL = "info.aduna.app.logging.logback.LogbackConfiguration";
    private String applicationId;
    private String longName;
    private String fullName;
    private AppVersion version;
    private String[] commandLineArgs;
    private String dataDirName;
    private File dataDir;
    private LogConfiguration loggingConfiguration;
    private ProxySettings proxySettings;
    private Properties properties;

    public AppConfiguration() {
    }

    public AppConfiguration(String applicationId) {
        this();
        this.setApplicationId(applicationId);
    }

    public AppConfiguration(String applicationId, AppVersion version) {
        this(applicationId);
        this.setVersion(version);
    }

    public AppConfiguration(String applicationId, String longName, AppVersion version) {
        this(applicationId, version);
        this.setLongName(longName);
    }

    public void load() throws IOException {
        this.properties = ConfigurationUtil.loadConfigurationProperties(APP_CONFIG_FILE, null);
    }

    public void save() throws IOException {
        this.loggingConfiguration.save();
        this.proxySettings.save();
    }

    public void init() throws IOException {
        if (this.longName == null) {
            this.setLongName("Aduna " + this.applicationId);
        }
        this.setFullName();
        this.configureDataDir();
        this.load();
        try {
            this.loggingConfiguration = this.loadLogConfiguration();
            this.loggingConfiguration.setBaseDir(this.getDataDir());
            this.loggingConfiguration.setAppConfiguration(this);
            this.loggingConfiguration.init();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.proxySettings = new ProxySettings(this.getDataDir());
        this.proxySettings.init();
        this.save();
    }

    public void destroy() throws IOException {
        this.loggingConfiguration.destroy();
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public void setDataDirName(String dataDirName) {
        this.dataDirName = dataDirName;
    }

    public String getLongName() {
        return this.longName;
    }

    public void setLongName(String longName) {
        this.longName = longName;
    }

    public String getFullName() {
        return this.fullName;
    }

    private void setFullName() {
        this.fullName = this.longName;
        if (this.version != null) {
            this.fullName = this.fullName + " " + this.version.toString();
        }
    }

    public AppVersion getVersion() {
        return this.version;
    }

    public void setVersion(AppVersion version) {
        this.version = version;
        this.fullName = this.longName + " " + version.toString();
    }

    public String[] getCommandLineArgs() {
        return this.commandLineArgs;
    }

    public void setCommandLineArgs(String[] args) {
        this.commandLineArgs = args;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public LogConfiguration getLogConfiguration() {
        return this.loggingConfiguration;
    }

    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    public void setProxySettings(ProxySettings proxySettings) {
        this.proxySettings = proxySettings;
    }

    private void configureDataDir() {
        if (this.dataDirName != null) {
            this.dataDirName = this.dataDirName.trim();
            if (!this.dataDirName.equals("")) {
                File dataDirCandidate = new File(this.dataDirName);
                dataDirCandidate.mkdirs();
                if (dataDirCandidate.canRead() && dataDirCandidate.canWrite()) {
                    this.dataDir = dataDirCandidate;
                }
            }
        }
        if (this.dataDir == null) {
            this.dataDir = PlatformFactory.getPlatform().getApplicationDataDir(this.applicationId);
        }
    }

    private LogConfiguration loadLogConfiguration() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> logImplClass;
        Object logImpl;
        String classname = this.properties.getProperty("feature.logging.impl");
        if (classname == null) {
            classname = DEFAULT_LOGGING_IMPL;
        }
        if ((logImpl = (logImplClass = Class.forName(classname)).newInstance()) instanceof LogConfiguration) {
            return (LogConfiguration)logImpl;
        }
        throw new InstantiationException(classname + " is not valid LogConfiguration instance!");
    }

    public Properties getProperties() {
        return this.properties;
    }
}

