/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.path;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.impl.NodeIteratorImpl;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.path.P_Alt;
import com.hp.hpl.jena.sparql.path.P_FixedLength;
import com.hp.hpl.jena.sparql.path.P_Inverse;
import com.hp.hpl.jena.sparql.path.P_Link;
import com.hp.hpl.jena.sparql.path.P_Mod;
import com.hp.hpl.jena.sparql.path.P_NegPropSet;
import com.hp.hpl.jena.sparql.path.P_OneOrMore;
import com.hp.hpl.jena.sparql.path.P_ReverseLink;
import com.hp.hpl.jena.sparql.path.P_Seq;
import com.hp.hpl.jena.sparql.path.P_ZeroOrMore;
import com.hp.hpl.jena.sparql.path.P_ZeroOrOne;
import com.hp.hpl.jena.sparql.path.Path;
import com.hp.hpl.jena.sparql.path.PathVisitor;
import com.hp.hpl.jena.sparql.util.ModelUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.openjena.atlas.iterator.Filter;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.iterator.Transform;
import org.openjena.atlas.logging.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathEval_ARQ {
    private static Logger log = LoggerFactory.getLogger(PathEval_ARQ.class);

    private static NodeIterator convertGraphNodeToRDFNode(final Model model, Iterator<Node> iter) {
        Transform<Node, RDFNode> conv = new Transform<Node, RDFNode>(){

            @Override
            public RDFNode convert(Node obj) {
                return ModelUtils.convertGraphNodeToRDFNode(obj, model);
            }
        };
        Iterator<RDFNode> iterRDF = Iter.map(iter, conv);
        return new NodeIteratorImpl(iterRDF, null);
    }

    private static NodeIterator walkForwards(Model model, RDFNode rdfNode, Path path) {
        Iterator<Node> iter = PathEval_ARQ.eval(model.getGraph(), rdfNode.asNode(), path);
        return PathEval_ARQ.convertGraphNodeToRDFNode(model, iter);
    }

    private static NodeIterator walkBackwards(Model model, RDFNode rdfNode, Path path) {
        Iterator<Node> iter = PathEval_ARQ.evalInverse(model.getGraph(), rdfNode.asNode(), path);
        return PathEval_ARQ.convertGraphNodeToRDFNode(model, iter);
    }

    private static Iterator<Node> eval(Graph graph, Node node, Path path) {
        if (node == null) {
            Log.fatal(PathEval_ARQ.class, "PathEval.eval applied to a null node");
        }
        if (node.isVariable()) {
            Log.warn(PathEval_ARQ.class, "PathEval.eval applied to a variable: " + node);
        }
        return PathEval_ARQ.eval(graph, node, path, true);
    }

    private static Iterator<Node> evalInverse(Graph g, Node node, Path path) {
        return PathEval_ARQ.eval(g, node, path, false);
    }

    private static Iterator<Node> eval(Graph graph, Node node, Path path, boolean forward) {
        LinkedHashSet<Node> acc = new LinkedHashSet<Node>();
        PathEval_ARQ.eval(graph, node, path, forward, acc);
        return acc.iterator();
    }

    private static Iterator<Node> eval(Graph graph, Iterator<Node> input, Path path, boolean forward) {
        LinkedHashSet<Node> acc = new LinkedHashSet<Node>();
        while (input.hasNext()) {
            Node node = input.next();
            PathEval_ARQ.eval(graph, node, path, forward, acc);
        }
        return acc.iterator();
    }

    private static void eval(Graph graph, Node node, Path p, boolean forward, Collection<Node> acc) {
        PathEvaluator evaluator = new PathEvaluator(graph, node, acc, forward);
        p.visit(evaluator);
    }

    private static class PathEvaluator
    implements PathVisitor {
        private final Graph graph;
        private final Node node;
        private final Collection<Node> output;
        private boolean forwardMode;
        private static Transform<Triple, Node> selectSubject = new Transform<Triple, Node>(){

            @Override
            public Node convert(Triple triple) {
                return triple.getSubject();
            }
        };
        private static Transform<Triple, Node> selectPredicate = new Transform<Triple, Node>(){

            @Override
            public Node convert(Triple triple) {
                return triple.getPredicate();
            }
        };
        private static Transform<Triple, Node> selectObject = new Transform<Triple, Node>(){

            @Override
            public Node convert(Triple triple) {
                return triple.getObject();
            }
        };

        public PathEvaluator(Graph g, Node n, Collection<Node> output, boolean forward) {
            this.graph = g;
            this.node = n;
            this.output = output;
            this.forwardMode = forward;
        }

        @Override
        public void visit(P_Link pathNode) {
            Iterator<Node> nodes = this.doOne(pathNode.getNode());
            this.fill(nodes);
        }

        @Override
        public void visit(P_ReverseLink pathNode) {
            this.forwardMode = !this.forwardMode;
            Iterator<Node> nodes = this.doOne(pathNode.getNode());
            this.forwardMode = !this.forwardMode;
            this.fill(nodes);
        }

        @Override
        public void visit(P_NegPropSet pathNotOneOf) {
            List<Node> props;
            if (pathNotOneOf.getBwdNodes().size() > 0) {
                Log.warn(this, "Only forward negated property sets implemented");
            }
            if ((props = pathNotOneOf.getFwdNodes()).size() == 0) {
                throw new ARQException("Bad path element: Negative property set found with no elements");
            }
            Iterator<Node> nodes = this.doOneExclude(pathNotOneOf.getFwdNodes());
            this.fill(nodes);
        }

        @Override
        public void visit(P_Inverse inversePath) {
            this.forwardMode = !this.forwardMode;
            inversePath.getSubPath().visit(this);
            this.forwardMode = !this.forwardMode;
        }

        @Override
        public void visit(P_Alt pathAlt) {
            Iterator iter = PathEval_ARQ.eval(this.graph, this.node, pathAlt.getLeft(), this.forwardMode);
            this.fill(iter);
            iter = PathEval_ARQ.eval(this.graph, this.node, pathAlt.getRight(), this.forwardMode);
            this.fill(iter);
        }

        @Override
        public void visit(P_Seq pathSeq) {
            Path part1 = this.forwardMode ? pathSeq.getLeft() : pathSeq.getRight();
            Path part2 = this.forwardMode ? pathSeq.getRight() : pathSeq.getLeft();
            Iterator iter = PathEval_ARQ.eval(this.graph, this.node, part1, this.forwardMode);
            iter = PathEval_ARQ.eval(this.graph, iter, part2, this.forwardMode);
            this.fill(iter);
        }

        @Override
        public void visit(P_Mod pathMod) {
            if (pathMod.isZeroOrMore()) {
                this.doZeroOrMore(pathMod.getSubPath());
                return;
            }
            if (pathMod.isOneOrMore()) {
                this.doOneOrMore(pathMod.getSubPath());
                return;
            }
            if (pathMod.getMin() == 0L) {
                this.output.add(this.node);
            }
            if (pathMod.getMax() == 0L) {
                return;
            }
            Iterator iter = PathEval_ARQ.eval(this.graph, this.node, pathMod.getSubPath(), this.forwardMode);
            long min2 = PathEvaluator.dec(pathMod.getMin());
            long max2 = PathEvaluator.dec(pathMod.getMax());
            P_Mod nextPath = new P_Mod(pathMod.getSubPath(), min2, max2);
            while (iter.hasNext()) {
                Node n2 = (Node)iter.next();
                Iterator iter2 = PathEval_ARQ.eval(this.graph, n2, nextPath, this.forwardMode);
                this.fill(iter2);
            }
        }

        @Override
        public void visit(P_FixedLength pFixedLength) {
            Iterator iter = PathEval_ARQ.eval(this.graph, this.node, pFixedLength.getSubPath(), this.forwardMode);
            long count2 = PathEvaluator.dec(pFixedLength.getCount());
            P_FixedLength nextPath = new P_FixedLength(pFixedLength.getSubPath(), count2);
            while (iter.hasNext()) {
                Node n2 = (Node)iter.next();
                Iterator iter2 = PathEval_ARQ.eval(this.graph, n2, nextPath, this.forwardMode);
                this.fill(iter2);
            }
        }

        @Override
        public void visit(P_ZeroOrOne path) {
            this.doZero(path.getSubPath());
            this.doOne(path.getSubPath());
        }

        @Override
        public void visit(P_ZeroOrMore path) {
            this.doZeroOrMore(path.getSubPath());
        }

        @Override
        public void visit(P_OneOrMore path) {
            this.doOneOrMore(path.getSubPath());
        }

        private void doZero(Path path) {
            this.output.add(this.node);
        }

        private void doOne(Path path) {
            Iterator iter = PathEval_ARQ.eval(this.graph, this.node, path, this.forwardMode);
            this.fill(iter);
        }

        private void fill(Iterator<Node> iter) {
            while (iter.hasNext()) {
                this.output.add(iter.next());
            }
        }

        private final Iterator<Node> doOne(Node property) {
            Iter<Node> iter2 = null;
            if (this.forwardMode) {
                Iter<Triple> iter1 = Iter.iter(this.graph.find(this.node, property, Node.ANY));
                iter2 = iter1.map(selectObject);
            } else {
                Iter<Triple> iter1 = Iter.iter(this.graph.find(Node.ANY, property, this.node));
                iter2 = iter1.map(selectSubject);
            }
            return iter2;
        }

        private final Iterator<Node> doOneExclude(List<Node> excludedNodes) {
            Iter<Triple> iter1 = this.forwardLinks(this.node, excludedNodes);
            Iter<Node> r1 = iter1.map(selectObject);
            return r1;
        }

        private boolean testConnected(Node x, Node z, List<Node> excludeProperties) {
            Iter<Triple> iter1 = Iter.iter(this.graph.find(x, Node.ANY, z));
            if (excludeProperties != null) {
                iter1 = iter1.filter(new FilterExclude(excludeProperties));
            }
            return iter1.hasNext();
        }

        private Iter<Triple> between(Node x, Node z) {
            Iter<Triple> iter1 = Iter.iter(this.graph.find(x, Node.ANY, z));
            return iter1;
        }

        private Iter<Triple> forwardLinks(Node x, Collection<Node> excludeProperties) {
            Iter<Triple> iter1 = Iter.iter(this.graph.find(x, Node.ANY, Node.ANY));
            if (excludeProperties != null) {
                iter1 = iter1.filter(new FilterExclude(excludeProperties));
            }
            return iter1;
        }

        private Iter<Triple> backwardLinks(Node x, Collection<Node> excludeProperties) {
            Iter<Triple> iter1 = Iter.iter(this.graph.find(Node.ANY, Node.ANY, x));
            if (excludeProperties != null) {
                iter1 = iter1.filter(new FilterExclude(excludeProperties));
            }
            return iter1;
        }

        private static long dec(long x) {
            return x <= 0L ? x : x - 1L;
        }

        private void doOneOrMore(Path path) {
            Iterator iter1 = PathEval_ARQ.eval(this.graph, this.node, path, this.forwardMode);
            LinkedHashSet<Node> visited = new LinkedHashSet<Node>();
            while (iter1.hasNext()) {
                Node n1 = (Node)iter1.next();
                PathEvaluator.closure(this.graph, n1, path, visited, this.forwardMode);
            }
            this.output.addAll(visited);
        }

        private void doZeroOrMore(Path path) {
            LinkedHashSet<Node> visited = new LinkedHashSet<Node>();
            PathEvaluator.closure(this.graph, this.node, path, visited, this.forwardMode);
            this.output.addAll(visited);
        }

        private static void closure(Graph graph, Node node, Path path, Collection<Node> visited, boolean forward) {
            if (visited.contains(node)) {
                return;
            }
            visited.add(node);
            Iterator iter = PathEval_ARQ.eval(graph, node, path, forward);
            while (iter.hasNext()) {
                Node n2 = (Node)iter.next();
                PathEvaluator.closure(graph, n2, path, visited, forward);
            }
        }

        private static class FilterExclude
        implements Filter<Triple> {
            private Collection<Node> excludes;

            public FilterExclude(Collection<Node> excludes) {
                this.excludes = excludes;
            }

            @Override
            public boolean accept(Triple triple) {
                return !this.excludes.contains(triple.getPredicate());
            }
        }
    }
}

