/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.iterator;

import info.aduna.iteration.FilterIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryResultUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPARQLMinusIteration<X extends Exception>
extends FilterIteration<BindingSet, X> {
    private final Iteration<BindingSet, X> rightArg;
    private final boolean distinct;
    private boolean initialized;
    private Set<BindingSet> excludeSet;

    public SPARQLMinusIteration(Iteration<BindingSet, X> leftArg, Iteration<BindingSet, X> rightArg) {
        this(leftArg, rightArg, false);
    }

    public SPARQLMinusIteration(Iteration<BindingSet, X> leftArg, Iteration<BindingSet, X> rightArg, boolean distinct) {
        super(leftArg);
        assert (rightArg != null);
        this.rightArg = rightArg;
        this.distinct = distinct;
        this.initialized = false;
    }

    @Override
    protected boolean accept(BindingSet object) throws X {
        if (!this.initialized) {
            this.excludeSet = Iterations.addAll(this.rightArg, new HashSet());
            this.initialized = true;
        }
        boolean compatible = false;
        for (BindingSet excluded : this.excludeSet) {
            HashSet<String> sharedBindingNames = new HashSet<String>(excluded.getBindingNames());
            sharedBindingNames.retainAll(object.getBindingNames());
            if (sharedBindingNames.isEmpty() || !QueryResultUtil.bindingSetsCompatible(excluded, object)) continue;
            compatible = true;
            break;
        }
        return !compatible;
    }

    @Override
    protected void handleClose() throws X {
        super.handleClose();
        Iterations.closeCloseable(this.rightArg);
    }
}

