/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.OpVisitorByType;
import com.hp.hpl.jena.sparql.algebra.OpWalker;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.TransformWrapper;
import com.hp.hpl.jena.sparql.algebra.op.Op0;
import com.hp.hpl.jena.sparql.algebra.op.Op1;
import com.hp.hpl.jena.sparql.algebra.op.Op2;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGroup;
import com.hp.hpl.jena.sparql.algebra.op.OpN;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpService;
import com.hp.hpl.jena.sparql.algebra.optimize.ExprTransformApplyTransform;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprAggregator;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprTransform;
import com.hp.hpl.jena.sparql.expr.ExprTransformer;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.openjena.atlas.logging.Log;

public class Transformer {
    private static Transformer singleton = new Transformer();

    public static Transformer get() {
        return singleton;
    }

    public static void set(Transformer value) {
        singleton = value;
    }

    public static Op transform(Transform transform, Op op) {
        return Transformer.get().transformation(transform, op, null, null);
    }

    public static Op transform(Transform transform, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        return Transformer.get().transformation(transform, op, beforeVisitor, afterVisitor);
    }

    public static Op transformSkipService(Transform transform, Op op) {
        return Transformer.transformSkipService(transform, op, null, null);
    }

    public static Op transformSkipService(Transform transform, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        transform = new TransformSkipService(transform);
        return Transformer.transform(transform, op, beforeVisitor, afterVisitor);
    }

    protected Op transformation(Transform transform, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        ApplyTransformVisitor v = new ApplyTransformVisitor(transform);
        return this.transformation(v, op, beforeVisitor, afterVisitor);
    }

    protected Op transformation(ApplyTransformVisitor transformApply, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        if (op == null) {
            Log.warn(this, "Attempt to transform a null Op - ignored");
            return op;
        }
        return this.applyTransformation(transformApply, op, beforeVisitor, afterVisitor);
    }

    protected Op applyTransformation(ApplyTransformVisitor transformApply, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        OpWalker.walk(op, transformApply, beforeVisitor, afterVisitor);
        Op r = transformApply.result();
        return r;
    }

    protected Transformer() {
    }

    static class TransformSkipService
    extends TransformWrapper {
        public TransformSkipService(Transform transform) {
            super(transform);
        }

        @Override
        public Op transform(OpService opService, Op subOp) {
            return opService;
        }
    }

    static class WalkerVisitorSkipService
    extends OpWalker.WalkerVisitor {
        public WalkerVisitorSkipService(OpVisitor visitor, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
            super(visitor, beforeVisitor, afterVisitor);
        }

        public WalkerVisitorSkipService(OpVisitor visitor) {
            super(visitor);
        }

        @Override
        public void visit(OpService op) {
            this.before(op);
            if (this.visitor != null) {
                op.visit(this.visitor);
            }
            this.after(op);
        }
    }

    static class ApplyTransformVisitorServiceAsLeaf
    extends ApplyTransformVisitor {
        public ApplyTransformVisitorServiceAsLeaf(Transform transform) {
            super(transform);
        }

        @Override
        public void visit(OpService op) {
            this.push(op);
        }
    }

    public static class ApplyTransformVisitor
    extends OpVisitorByType {
        protected final Transform transform;
        private final ExprTransformApplyTransform exprTransform;
        private final Stack<Op> stack = new Stack();

        protected final Op pop() {
            return this.stack.pop();
        }

        protected final void push(Op op) {
            this.stack.push(op);
        }

        public ApplyTransformVisitor(Transform transform) {
            this.transform = transform;
            this.exprTransform = new ExprTransformApplyTransform(transform);
        }

        final Op result() {
            if (this.stack.size() != 1) {
                Log.warn(this, "Stack is not aligned");
            }
            return this.pop();
        }

        @Override
        public void visit(OpFilter opFilter) {
            ExprList ex = new ExprList();
            boolean changed = false;
            for (Expr e2 : opFilter.getExprs()) {
                Expr e22 = ExprTransformer.transform((ExprTransform)this.exprTransform, e2);
                ex.add(e22);
                if (e2 == e22) continue;
                changed = true;
            }
            OpFilter f = opFilter;
            if (changed) {
                f = (OpFilter)OpFilter.filter(ex, opFilter.getSubOp());
            }
            this.visit1(f);
        }

        @Override
        public void visit(OpOrder opOrder) {
            List<SortCondition> conditions = opOrder.getConditions();
            ArrayList<SortCondition> conditions2 = new ArrayList<SortCondition>();
            boolean changed = false;
            for (SortCondition sc : conditions) {
                Expr e2 = sc.getExpression();
                Expr e22 = ExprTransformer.transform((ExprTransform)this.exprTransform, e2);
                conditions2.add(new SortCondition(e22, sc.getDirection()));
                if (e2 == e22) continue;
                changed = true;
            }
            OpOrder x = opOrder;
            if (changed) {
                x = new OpOrder(opOrder.getSubOp(), conditions2);
            }
            this.visit1(x);
        }

        @Override
        public void visit(OpAssign opAssign) {
            VarExprList varExpr = opAssign.getVarExprList();
            List<Var> vars = varExpr.getVars();
            VarExprList varExpr2 = this.process(varExpr);
            OpAssign opAssign2 = opAssign;
            if (varExpr != varExpr2) {
                opAssign2 = OpAssign.assignDirect(opAssign.getSubOp(), varExpr2);
            }
            this.visit1(opAssign2);
        }

        private VarExprList process(VarExprList varExpr) {
            List<Var> vars = varExpr.getVars();
            VarExprList varExpr2 = new VarExprList();
            boolean changed = false;
            for (Var v : vars) {
                Expr e2;
                Expr e22 = e2 = varExpr.getExpr(v);
                if (e2 != null) {
                    e22 = ExprTransformer.transform((ExprTransform)this.exprTransform, e2);
                }
                if (e22 == null) {
                    varExpr2.add(v);
                } else {
                    varExpr2.add(v, e22);
                }
                if (e2 == e22) continue;
                changed = true;
            }
            if (!changed) {
                return varExpr;
            }
            return varExpr2;
        }

        @Override
        public void visit(OpGroup opGroup) {
            List<ExprAggregator> aggs;
            VarExprList varExpr2;
            boolean changed = false;
            VarExprList varExpr = opGroup.getGroupVars();
            if (varExpr != (varExpr2 = this.process(varExpr))) {
                changed = true;
            }
            List<ExprAggregator> aggs2 = aggs = opGroup.getAggregators();
            aggs2 = new ArrayList<ExprAggregator>();
            for (ExprAggregator agg : aggs) {
                Expr e2;
                Expr eVar2;
                Aggregator aggregator = agg.getAggregator();
                Var v = agg.getVar();
                ExprVar eVar = agg.getAggVar();
                if (eVar != (eVar2 = ExprTransformer.transform((ExprTransform)this.exprTransform, eVar))) {
                    changed = true;
                }
                Expr e22 = e2 = aggregator.getExpr();
                if (e2 != null) {
                    ExprTransformer.transform((ExprTransform)this.exprTransform, e2);
                }
                if (e2 != e22) {
                    changed = true;
                }
                Aggregator a2 = aggregator.copy(e22);
                aggs2.add(new ExprAggregator(eVar2.asVar(), a2));
            }
            OpGroup opGroup2 = opGroup;
            if (changed) {
                opGroup2 = new OpGroup(opGroup.getSubOp(), varExpr2, aggs2);
            }
            this.visit1(opGroup2);
        }

        @Override
        protected void visit0(Op0 op) {
            this.push(op.apply(this.transform));
        }

        @Override
        protected void visit1(Op1 op) {
            Op subOp = null;
            if (op.getSubOp() != null) {
                subOp = this.pop();
            }
            this.push(op.apply(this.transform, subOp));
        }

        @Override
        protected void visit2(Op2 op) {
            Op left = null;
            Op right = null;
            if (op.getRight() != null) {
                right = this.pop();
            }
            if (op.getLeft() != null) {
                left = this.pop();
            }
            Op opX = op.apply(this.transform, left, right);
            this.push(opX);
        }

        @Override
        protected void visitN(OpN op) {
            ArrayList<Op> x = new ArrayList<Op>(op.size());
            Iterator<Op> iter = op.iterator();
            while (iter.hasNext()) {
                Op sub = iter.next();
                Op r = this.pop();
                if (r == null) continue;
                x.add(0, r);
            }
            Op opX = op.apply(this.transform, x);
            this.push(opX);
        }

        @Override
        protected void visitExt(OpExt op) {
            this.push(this.transform.transform(op));
        }
    }
}

