/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.out;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import java.io.OutputStream;
import java.nio.charset.CharsetEncoder;
import org.openjena.atlas.io.BufferingWriter;
import org.openjena.atlas.lib.Chars;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.out.NodeFormatter;
import org.openjena.riot.out.NodeFormatterNT;
import org.openjena.riot.out.NodeToLabel;
import org.openjena.riot.system.Prologue;
import org.openjena.riot.system.SyntaxLabels;

public class SinkTripleOutput
implements Sink<Triple> {
    private CharsetEncoder encoder;
    private Prologue prologue = null;
    private BufferingWriter out;
    private NodeToLabel labelPolicy = null;
    private NodeFormatter nodeFmt = new NodeFormatterNT();

    public SinkTripleOutput(OutputStream outs) {
        this(outs, null, SyntaxLabels.createNodeToLabel());
    }

    public SinkTripleOutput(OutputStream outs, Prologue prologue, NodeToLabel labels) {
        this.encoder = Chars.charsetASCII.newEncoder();
        this.out = BufferingWriter.create(outs);
        this.setPrologue(prologue);
        this.setLabelPolicy(labels);
    }

    public void setPrologue(Prologue prologue) {
        this.prologue = prologue;
    }

    public void setLabelPolicy(NodeToLabel labels) {
        this.labelPolicy = labels;
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void send(Triple triple) {
        Node s = triple.getSubject();
        Node p = triple.getPredicate();
        Node o = triple.getObject();
        this.nodeFmt.format(this.out, s);
        this.out.output(" ");
        this.nodeFmt.format(this.out, p);
        this.out.output(" ");
        this.nodeFmt.format(this.out, o);
        this.out.output(" .\n");
    }

    @Override
    public void close() {
        this.flush();
    }
}

