/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biohackathon.SPARQLBuilder.OWL;


/**
 *
 * @author atsuko
 */

public class QueryPathGenerator {
    private String sparqlEndpoint = null;
    private RDFSchemaAnalyzerFactory factory = null;
    private RDFSchemaAnalyzer analyzer = null;
    //private OWLClassGraph graph;

    private static final String CDIR = "cdata";
    
    public static void main(String[] args){
        // For Test
        //String sp = "http://data.allie.dbcls.jp/sparql";
        //String sc = "http://purl.org/allie/ontology/201108#ShortForm";
        //String ec = "http://purl.org/allie/ontology/201108#LongForm";

        String sp = "http://www.ebi.ac.uk/rdf/services/chembl/sparql";
        String sc = "http://rdf.ebi.ac.uk/terms/chembl#Enzyme";
        String ec = "http://rdf.ebi.ac.uk/terms/chembl#Activity";

        //String sp = "http://www.ebi.ac.uk/rdf/services/biosamples/sparql";
        //String sc = "http://rdf.ebi.ac.uk/terms/biosd/Sample";
        //String ec = "http://purl.obolibrary.org/obo/NCBITaxon_7955";
        //String sp = "http://www.ebi.ac.uk/rdf/services/biosamples/sparql";
        //String sc = "http://rdf.ebi.ac.uk/terms/biosd/Sample";
        //String ec = "http://purl.obolibrary.org/obo/NCBITaxon_7955";
        //String sp = "http://lsd.dbcls.jp/sparql";
        //String sc = "http://purl.jp/bio/10/lsd/ontology/201209#EnglishCode";
        //String ec = "http://purl.jp/bio/10/lsd/ontology/201209#JapaneseCode";
        //QueryPathGenerator qpg = new QueryPathGenerator(sp, "c:\\cdata");
        QueryPathGenerator qpg1 = new QueryPathGenerator(sp, "cdata/");
        //SClass[] cl = qpg.getClasses(null);
        
        long start1 = System.currentTimeMillis();
        Path[] path1 = qpg1.getPaths(sc, ec, false);
        long end1 = System.currentTimeMillis();
        
        QueryPathGenerator qpg2 = new QueryPathGenerator(sp, "ddata/");
        long start2 = System.currentTimeMillis();
        Path[] path2 = qpg2.getPaths(sc, ec, false);
        long end2 = System.currentTimeMillis();
        System.out.println("TOTAL1:");
        System.out.println(end1 - start1);
        System.out.println("TOTAL2:");
        System.out.println(end2 - start2);
        
        System.out.println(path1.length);
        System.out.println(path2.length);
    }
    
    public QueryPathGenerator(){
        factory = new RDFSchemaAnalyzerFactory(CDIR);
    }
    
    public QueryPathGenerator(String sparqlEndpoint){
        factory = new RDFSchemaAnalyzerFactory(CDIR);
        setSPARQLendpoint(sparqlEndpoint);      
    }

    public QueryPathGenerator(String sparqlEndpoint, String crawlFileName){
        factory = new RDFSchemaAnalyzerFactory(crawlFileName);
        setSPARQLendpoint(sparqlEndpoint);
    }
    
    public SClass[] getClasses(String keyword){
        String[] keywords = null;
        if ( keyword != null ){
            if ( keyword.length() != 0 ){
                keywords = new String[1];
                keywords[0] = keyword;
            }
        }
        try {
            return analyzer.getOWLClasses(null, keywords, null, false);
        }catch(Exception e){
            System.err.println(e);
            return null;
        }
    } 
    
    public Path[] getPaths(String startClass, String endClass, boolean countLink){
        if ( analyzer == null ){
            System.err.println("ERROR. SPARQL endpoint is not decided.");
        }
        OWLClassGraph graph = new OWLClassGraph(startClass, endClass);
        return graph.getPaths(analyzer, countLink);
    }
    
    public void setSPARQLendpoint(String sparqlEndpoint){
        this.sparqlEndpoint = sparqlEndpoint;
        setAnalyzer();
    }
    
    public RDFSchemaAnalyzerFactory getFactory(){
        return factory;
    }

    private void setAnalyzer(){
        //analyzer = new EndpointAnalyzer(sparqlEndpoint); //ForTest
        
        try {
            analyzer = factory.create(sparqlEndpoint);
        } catch (Exception e) {
            System.err.println(e);
        }
    }
}
