/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sail;

import java.net.URL;
import java.util.List;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.query.Dataset;
import org.openrdf.query.Update;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.query.algebra.Load;
import org.openrdf.query.algebra.UpdateExpr;
import org.openrdf.query.impl.AbstractOperation;
import org.openrdf.query.parser.ParsedUpdate;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepositoryConnection;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SailUpdate
extends AbstractOperation
implements Update {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ParsedUpdate parsedUpdate;
    private final SailRepositoryConnection con;

    protected SailUpdate(ParsedUpdate parsedUpdate, SailRepositoryConnection con) {
        this.parsedUpdate = parsedUpdate;
        this.con = con;
    }

    public ParsedUpdate getParsedUpdate() {
        return this.parsedUpdate;
    }

    protected SailRepositoryConnection getConnection() {
        return this.con;
    }

    public Dataset getActiveDataset() {
        if (this.dataset != null) {
            return this.dataset;
        }
        return this.parsedUpdate.getDataset();
    }

    public String toString() {
        return this.parsedUpdate.toString();
    }

    public void execute() throws UpdateExecutionException {
        List<UpdateExpr> updateExprs = this.parsedUpdate.getUpdateExprs();
        for (UpdateExpr updateExpr : updateExprs) {
            if (updateExpr instanceof Load) {
                Load load = (Load)updateExpr;
                Value source = load.getSource().getValue();
                Value graph = load.getGraph() != null ? load.getGraph().getValue() : null;
                SailRepositoryConnection conn = this.getConnection();
                try {
                    URL sourceURL = new URL(source.stringValue());
                    if (graph == null) {
                        conn.add(sourceURL, source.stringValue(), null, new Resource[0]);
                        continue;
                    }
                    conn.add(sourceURL, source.stringValue(), null, (Resource)graph);
                    continue;
                }
                catch (Exception e) {
                    this.logger.warn("exception during update execution: ", (Throwable)e);
                    if (load.isSilent()) continue;
                    throw new UpdateExecutionException(e);
                }
            }
            SailConnection conn = this.getConnection().getSailConnection();
            try {
                conn.executeUpdate(updateExpr, this.getActiveDataset(), this.getBindings(), true);
                if (!this.getConnection().isAutoCommit()) continue;
                conn.commit();
            }
            catch (SailException e) {
                this.logger.warn("exception during update execution: ", (Throwable)e);
                if (updateExpr.isSilent()) continue;
                throw new UpdateExecutionException(e);
            }
            catch (RepositoryException e) {
                this.logger.warn("exception during update execution: ", (Throwable)e);
                if (updateExpr.isSilent()) continue;
                throw new UpdateExecutionException(e);
            }
        }
    }
}

