/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.helpers;

import info.aduna.iteration.CloseableIteration;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.Add;
import org.openrdf.query.algebra.Clear;
import org.openrdf.query.algebra.Copy;
import org.openrdf.query.algebra.Create;
import org.openrdf.query.algebra.DeleteData;
import org.openrdf.query.algebra.InsertData;
import org.openrdf.query.algebra.Load;
import org.openrdf.query.algebra.Modify;
import org.openrdf.query.algebra.Move;
import org.openrdf.query.algebra.SingletonSet;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UpdateExpr;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.helpers.StatementPatternCollector;
import org.openrdf.query.impl.EmptyBindingSet;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.SailBase;
import org.openrdf.sail.helpers.SailBaseIteration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SailConnectionBase
implements SailConnection {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SailBase sailBase;
    private volatile boolean isOpen;
    private volatile boolean txnActive;
    protected final ReentrantReadWriteLock connectionLock = new ReentrantReadWriteLock();
    protected final ReentrantLock updateLock = new ReentrantLock();
    private final List<SailBaseIteration> activeIterations = Collections.synchronizedList(new LinkedList());
    private final Throwable creatorTrace;

    private static boolean debugEnabled() {
        try {
            return System.getProperty("org.openrdf.repository.debug") != null;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public SailConnectionBase(SailBase sailBase) {
        this.sailBase = sailBase;
        this.isOpen = true;
        this.txnActive = false;
        this.creatorTrace = SailConnectionBase.debugEnabled() ? new Throwable() : null;
    }

    @Override
    public final boolean isOpen() throws SailException {
        return this.isOpen;
    }

    protected void verifyIsOpen() throws SailException {
        if (!this.isOpen) {
            throw new IllegalStateException("Connection has been closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SailException {
        block19: {
            this.connectionLock.writeLock().lock();
            try {
                if (!this.isOpen) break block19;
                try {
                    while (true) {
                        SailBaseIteration ci = null;
                        List<SailBaseIteration> list = this.activeIterations;
                        synchronized (list) {
                            if (this.activeIterations.isEmpty()) {
                                break;
                            }
                            ci = this.activeIterations.remove(0);
                        }
                        try {
                            ci.forceClose();
                        }
                        catch (SailException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new SailException(e);
                        }
                    }
                    assert (this.activeIterations.isEmpty());
                    if (this.txnActive) {
                        this.logger.warn("Rolling back transaction due to connection close", new Throwable());
                        try {
                            this.rollbackInternal();
                        }
                        finally {
                            this.txnActive = false;
                        }
                    }
                    this.closeInternal();
                }
                finally {
                    this.isOpen = false;
                    this.sailBase.connectionClosed(this);
                }
            }
            finally {
                this.connectionLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.isOpen()) {
                if (this.creatorTrace != null) {
                    this.logger.warn("Closing connection due to garbage collection, connection was created in:", this.creatorTrace);
                }
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            CloseableIteration<? extends BindingSet, QueryEvaluationException> closeableIteration = this.registerIteration(this.evaluateInternal(tupleExpr, dataset, bindings, includeInferred));
            return closeableIteration;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void executeUpdate(UpdateExpr updateExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.autoStartTransaction();
                this.executeInternal(updateExpr, dataset, bindings, includeInferred);
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CloseableIteration<? extends Resource, SailException> getContextIDs() throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            CloseableIteration<? extends Resource, SailException> closeableIteration = this.registerIteration(this.getContextIDsInternal());
            return closeableIteration;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CloseableIteration<? extends Statement, SailException> getStatements(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            CloseableIteration<? extends Statement, SailException> closeableIteration = this.registerIteration(this.getStatementsInternal(subj, pred, obj, includeInferred, contexts));
            return closeableIteration;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long size(Resource ... contexts) throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            long l = this.sizeInternal(contexts);
            return l;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    protected final boolean transactionActive() {
        return this.txnActive;
    }

    protected void autoStartTransaction() throws SailException {
        if (!this.txnActive) {
            this.startTransactionInternal();
            this.txnActive = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void commit() throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                if (this.txnActive) {
                    this.commitInternal();
                    this.txnActive = false;
                }
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void rollback() throws SailException {
        block9: {
            this.connectionLock.readLock().lock();
            try {
                this.verifyIsOpen();
                this.updateLock.lock();
                try {
                    if (!this.txnActive) break block9;
                    try {
                        this.rollbackInternal();
                    }
                    finally {
                        this.txnActive = false;
                    }
                }
                finally {
                    this.updateLock.unlock();
                }
            }
            finally {
                this.connectionLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.autoStartTransaction();
                this.addStatementInternal(subj, pred, obj, contexts);
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeStatements(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.autoStartTransaction();
                this.removeStatementsInternal(subj, pred, obj, contexts);
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear(Resource ... contexts) throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.autoStartTransaction();
                this.clearInternal(contexts);
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CloseableIteration<? extends Namespace, SailException> getNamespaces() throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            CloseableIteration<? extends Namespace, SailException> closeableIteration = this.registerIteration(this.getNamespacesInternal());
            return closeableIteration;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getNamespace(String prefix) throws SailException {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            String string = this.getNamespaceInternal(prefix);
            return string;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setNamespace(String prefix, String name) throws SailException {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.autoStartTransaction();
                this.setNamespaceInternal(prefix, name);
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeNamespace(String prefix) throws SailException {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.autoStartTransaction();
                this.removeNamespaceInternal(prefix);
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clearNamespaces() throws SailException {
        this.connectionLock.readLock().lock();
        try {
            this.verifyIsOpen();
            this.updateLock.lock();
            try {
                this.autoStartTransaction();
                this.clearNamespacesInternal();
            }
            finally {
                this.updateLock.unlock();
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    protected info.aduna.concurrent.locks.Lock getSharedConnectionLock() throws SailException {
        return new JavaLock(this.connectionLock.readLock());
    }

    protected info.aduna.concurrent.locks.Lock getExclusiveConnectionLock() throws SailException {
        return new JavaLock(this.connectionLock.writeLock());
    }

    @Deprecated
    protected info.aduna.concurrent.locks.Lock getTransactionLock() throws SailException {
        return new JavaLock(this.updateLock);
    }

    protected <T, E extends Exception> CloseableIteration<T, E> registerIteration(CloseableIteration<T, E> iter) {
        SailBaseIteration<T, E> result = new SailBaseIteration<T, E>(iter, this);
        this.activeIterations.add(result);
        return result;
    }

    protected void iterationClosed(SailBaseIteration iter) {
        this.activeIterations.remove(iter);
    }

    protected abstract void closeInternal() throws SailException;

    protected abstract CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateInternal(TupleExpr var1, Dataset var2, BindingSet var3, boolean var4) throws SailException;

    protected void executeInternal(UpdateExpr updateExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        this.logger.trace("Incoming update expression:\n{}", (Object)updateExpr);
        if (updateExpr instanceof Modify) {
            this.executeModify((Modify)updateExpr, dataset, bindings, includeInferred);
        } else if (updateExpr instanceof InsertData) {
            this.executeInsertData((InsertData)updateExpr, dataset, bindings, includeInferred);
        } else if (updateExpr instanceof DeleteData) {
            this.executeDeleteData((DeleteData)updateExpr, dataset, bindings, includeInferred);
        } else if (updateExpr instanceof Clear) {
            this.executeClear((Clear)updateExpr, dataset, bindings, includeInferred);
        } else if (updateExpr instanceof Create) {
            this.executeCreate((Create)updateExpr, dataset, bindings, includeInferred);
        } else if (updateExpr instanceof Copy) {
            this.executeCopy((Copy)updateExpr, dataset, bindings, includeInferred);
        } else if (updateExpr instanceof Add) {
            this.executeAdd((Add)updateExpr, dataset, bindings, includeInferred);
        } else if (updateExpr instanceof Move) {
            this.executeMove((Move)updateExpr, dataset, bindings, includeInferred);
        } else if (updateExpr instanceof Load) {
            throw new SailException("load operations can not be handled directly by the SAIL");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeCreate(Create create, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        Value graphValue = create.getGraph().getValue();
        if (graphValue instanceof Resource) {
            Resource namedGraph = (Resource)graphValue;
            CloseableIteration<? extends Resource, SailException> contextIDs = this.getContextIDsInternal();
            try {
                while (contextIDs.hasNext()) {
                    Resource contextID = (Resource)contextIDs.next();
                    if (!namedGraph.equals(contextID)) continue;
                    throw new SailException("Named graph " + namedGraph + " already exists. ");
                }
            }
            finally {
                contextIDs.close();
            }
        }
    }

    protected void executeCopy(Copy copy, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        Resource destination;
        ValueConstant sourceGraph = copy.getSourceGraph();
        ValueConstant destinationGraph = copy.getDestinationGraph();
        Resource source = sourceGraph != null ? (Resource)sourceGraph.getValue() : null;
        Resource resource = destination = destinationGraph != null ? (Resource)destinationGraph.getValue() : null;
        if (source == null && destination == null || source != null && source.equals(destination)) {
            return;
        }
        this.clearInternal(destination);
        CloseableIteration<? extends Statement, SailException> statements = this.getStatementsInternal(null, null, null, includeInferred, source);
        while (statements.hasNext()) {
            Statement st = (Statement)statements.next();
            this.addStatementInternal(st.getSubject(), st.getPredicate(), st.getObject(), destination);
        }
        statements.close();
    }

    protected void executeAdd(Add add, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        Resource destination;
        ValueConstant sourceGraph = add.getSourceGraph();
        ValueConstant destinationGraph = add.getDestinationGraph();
        Resource source = sourceGraph != null ? (Resource)sourceGraph.getValue() : null;
        Resource resource = destination = destinationGraph != null ? (Resource)destinationGraph.getValue() : null;
        if (source == null && destination == null || source != null && source.equals(destination)) {
            return;
        }
        CloseableIteration<? extends Statement, SailException> statements = this.getStatementsInternal(null, null, null, includeInferred, source);
        while (statements.hasNext()) {
            Statement st = (Statement)statements.next();
            this.addStatementInternal(st.getSubject(), st.getPredicate(), st.getObject(), destination);
        }
        statements.close();
    }

    protected void executeMove(Move move, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        Resource destination;
        ValueConstant sourceGraph = move.getSourceGraph();
        ValueConstant destinationGraph = move.getDestinationGraph();
        Resource source = sourceGraph != null ? (Resource)sourceGraph.getValue() : null;
        Resource resource = destination = destinationGraph != null ? (Resource)destinationGraph.getValue() : null;
        if (source == null && destination == null || source != null && source.equals(destination)) {
            return;
        }
        this.clearInternal(destination);
        CloseableIteration<? extends Statement, SailException> statements = this.getStatementsInternal(null, null, null, includeInferred, source);
        while (statements.hasNext()) {
            Statement st = (Statement)statements.next();
            this.addStatementInternal(st.getSubject(), st.getPredicate(), st.getObject(), destination);
            this.removeStatementsInternal(st.getSubject(), st.getPredicate(), st.getObject(), source);
        }
        statements.close();
    }

    protected void executeClear(Clear clearExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        block9: {
            try {
                ValueConstant graph = clearExpr.getGraph();
                if (graph != null) {
                    Resource context = (Resource)graph.getValue();
                    this.clearInternal(context);
                } else {
                    StatementPattern.Scope scope = clearExpr.getScope();
                    if (StatementPattern.Scope.NAMED_CONTEXTS.equals((Object)scope)) {
                        CloseableIteration<? extends Resource, SailException> contextIDs = this.getContextIDsInternal();
                        while (contextIDs.hasNext()) {
                            this.clearInternal((Resource)contextIDs.next());
                        }
                    } else if (StatementPattern.Scope.DEFAULT_CONTEXTS.equals((Object)scope)) {
                        this.clearInternal(new Resource[]{null});
                    } else {
                        this.clearInternal(new Resource[0]);
                    }
                }
            }
            catch (SailException e) {
                if (clearExpr.isSilent()) break block9;
                throw e;
            }
        }
    }

    protected void executeInsertData(InsertData insertDataExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        TupleExpr insertExpr = insertDataExpr.getInsertExpr();
        CloseableIteration<? extends BindingSet, QueryEvaluationException> toBeInserted = this.evaluateInternal(insertExpr, dataset, bindings, includeInferred);
        try {
            while (toBeInserted.hasNext()) {
                BindingSet bs = (BindingSet)toBeInserted.next();
                Resource subject = (Resource)bs.getValue("subject");
                URI predicate = (URI)bs.getValue("predicate");
                Value object = bs.getValue("object");
                Resource context = (Resource)bs.getValue("context");
                if (context == null) {
                    this.addStatementInternal(subject, predicate, object, new Resource[0]);
                    continue;
                }
                this.addStatementInternal(subject, predicate, object, context);
            }
        }
        catch (QueryEvaluationException e) {
            throw new SailException(e);
        }
    }

    protected void executeDeleteData(DeleteData deleteDataExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        TupleExpr deleteExpr = deleteDataExpr.getDeleteExpr();
        CloseableIteration<? extends BindingSet, QueryEvaluationException> toBeDeleted = this.evaluateInternal(deleteExpr, dataset, bindings, includeInferred);
        try {
            while (toBeDeleted.hasNext()) {
                BindingSet bs = (BindingSet)toBeDeleted.next();
                Resource subject = (Resource)bs.getValue("subject");
                URI predicate = (URI)bs.getValue("predicate");
                Value object = bs.getValue("object");
                Resource context = (Resource)bs.getValue("context");
                if (context == null) {
                    this.removeStatementsInternal(subject, predicate, object, new Resource[0]);
                    continue;
                }
                this.removeStatementsInternal(subject, predicate, object, context);
            }
        }
        catch (QueryEvaluationException e) {
            throw new SailException(e);
        }
    }

    protected void executeModify(Modify modify, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        TupleExpr deleteClause = modify.getDeleteExpr();
        TupleExpr insertClause = modify.getInsertExpr();
        TupleExpr whereClause = modify.getWhereExpr();
        SailConnection readConnection = this.sailBase.getConnection();
        try {
            CloseableIteration<? extends BindingSet, QueryEvaluationException> sourceBindings = readConnection.evaluate(whereClause, dataset, bindings, includeInferred);
            while (sourceBindings.hasNext()) {
                BindingSet sourceBinding = (BindingSet)sourceBindings.next();
                if (whereClause instanceof SingletonSet && sourceBinding instanceof EmptyBindingSet && bindings != null) {
                    sourceBinding = bindings;
                } else {
                    HashSet<String> uniqueBindings = new HashSet<String>(bindings.getBindingNames());
                    uniqueBindings.removeAll(sourceBinding.getBindingNames());
                    if (uniqueBindings.size() > 0) {
                        MapBindingSet mergedSet = new MapBindingSet();
                        for (String bindingName : sourceBinding.getBindingNames()) {
                            mergedSet.addBinding(sourceBinding.getBinding(bindingName));
                        }
                        for (String bindingName : uniqueBindings) {
                            mergedSet.addBinding(bindings.getBinding(bindingName));
                        }
                        sourceBinding = mergedSet;
                    }
                }
                if (deleteClause != null) {
                    List<StatementPattern> deletePatterns = StatementPatternCollector.process(deleteClause);
                    for (StatementPattern deletePattern : deletePatterns) {
                        Resource subject = (Resource)this.getValueForVar(deletePattern.getSubjectVar(), sourceBinding);
                        URI predicate = (URI)this.getValueForVar(deletePattern.getPredicateVar(), sourceBinding);
                        Value object = this.getValueForVar(deletePattern.getObjectVar(), sourceBinding);
                        Resource context = null;
                        if (deletePattern.getContextVar() != null) {
                            context = (Resource)this.getValueForVar(deletePattern.getContextVar(), sourceBinding);
                        }
                        if (context == null) {
                            this.removeStatementsInternal(subject, predicate, object, new Resource[0]);
                            continue;
                        }
                        this.removeStatementsInternal(subject, predicate, object, context);
                    }
                }
                if (insertClause == null) continue;
                List<StatementPattern> insertPatterns = StatementPatternCollector.process(insertClause);
                for (StatementPattern insertPattern : insertPatterns) {
                    Statement toBeInserted = this.createStatementFromPattern(insertPattern, sourceBinding);
                    if (toBeInserted == null) continue;
                    if (toBeInserted.getContext() == null) {
                        this.addStatementInternal(toBeInserted.getSubject(), toBeInserted.getPredicate(), toBeInserted.getObject(), new Resource[0]);
                        continue;
                    }
                    this.addStatementInternal(toBeInserted.getSubject(), toBeInserted.getPredicate(), toBeInserted.getObject(), toBeInserted.getContext());
                }
            }
        }
        catch (QueryEvaluationException e) {
            throw new SailException(e);
        }
        finally {
            readConnection.close();
        }
    }

    private Value getValueForVar(Var var, BindingSet bindings) throws SailException {
        Value value = null;
        value = var.hasValue() ? var.getValue() : bindings.getValue(var.getName());
        return value;
    }

    private Statement createStatementFromPattern(StatementPattern pattern, BindingSet sourceBinding) throws SailException {
        Resource subject = null;
        URI predicate = null;
        Value object = null;
        Resource context = null;
        ValueFactory f = this.sailBase.getValueFactory();
        if (pattern.getSubjectVar().hasValue()) {
            subject = (Resource)pattern.getSubjectVar().getValue();
        } else {
            subject = (Resource)sourceBinding.getValue(pattern.getSubjectVar().getName());
            if (subject == null && pattern.getSubjectVar().isAnonymous()) {
                subject = f.createBNode();
            }
        }
        predicate = pattern.getPredicateVar().hasValue() ? (URI)pattern.getPredicateVar().getValue() : (URI)sourceBinding.getValue(pattern.getPredicateVar().getName());
        if (pattern.getObjectVar().hasValue()) {
            object = pattern.getObjectVar().getValue();
        } else {
            object = sourceBinding.getValue(pattern.getObjectVar().getName());
            if (object == null && pattern.getObjectVar().isAnonymous()) {
                object = f.createBNode();
            }
        }
        if (pattern.getContextVar() != null) {
            context = pattern.getContextVar().hasValue() ? (Resource)pattern.getContextVar().getValue() : (Resource)sourceBinding.getValue(pattern.getContextVar().getName());
        }
        Statement st = null;
        if (subject != null && predicate != null && object != null) {
            st = context != null ? f.createStatement(subject, predicate, object, context) : f.createStatement(subject, predicate, object);
        }
        return st;
    }

    protected abstract CloseableIteration<? extends Resource, SailException> getContextIDsInternal() throws SailException;

    protected abstract CloseableIteration<? extends Statement, SailException> getStatementsInternal(Resource var1, URI var2, Value var3, boolean var4, Resource ... var5) throws SailException;

    protected abstract long sizeInternal(Resource ... var1) throws SailException;

    protected abstract void startTransactionInternal() throws SailException;

    protected abstract void commitInternal() throws SailException;

    protected abstract void rollbackInternal() throws SailException;

    protected abstract void addStatementInternal(Resource var1, URI var2, Value var3, Resource ... var4) throws SailException;

    protected abstract void removeStatementsInternal(Resource var1, URI var2, Value var3, Resource ... var4) throws SailException;

    protected abstract void clearInternal(Resource ... var1) throws SailException;

    protected abstract CloseableIteration<? extends Namespace, SailException> getNamespacesInternal() throws SailException;

    protected abstract String getNamespaceInternal(String var1) throws SailException;

    protected abstract void setNamespaceInternal(String var1, String var2) throws SailException;

    protected abstract void removeNamespaceInternal(String var1) throws SailException;

    protected abstract void clearNamespacesInternal() throws SailException;

    private static class JavaLock
    implements info.aduna.concurrent.locks.Lock {
        private final Lock javaLock;
        private boolean isActive = true;

        public JavaLock(Lock javaLock) {
            this.javaLock = javaLock;
            javaLock.lock();
        }

        public synchronized boolean isActive() {
            return this.isActive;
        }

        public synchronized void release() {
            if (this.isActive) {
                this.javaLock.unlock();
                this.isActive = false;
            }
        }
    }
}

