/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.ReificationWrapperGraph;
import com.hp.hpl.jena.graph.impl.SimpleReifier;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.shared.AlreadyReifiedException;
import com.hp.hpl.jena.shared.BrokenException;
import com.hp.hpl.jena.shared.CannotReifyException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.List;

public class ReificationWrapper
implements Reifier {
    protected final ReificationStyle style;
    protected final ReificationWrapperGraph graph;
    protected final Graph base;
    protected static final Filter<Triple> isReificationTriple = new Filter<Triple>(){

        @Override
        public boolean accept(Triple o) {
            return ReificationWrapper.isReificationTriple(o);
        }
    };

    public ReificationWrapper(Graph graph, ReificationStyle style) {
        this.style = style;
        this.graph = (ReificationWrapperGraph)graph;
        this.base = this.graph.getBase();
    }

    @Override
    public ExtendedIterator<Node> allNodes() {
        return this.base.find(Node.ANY, RDF.Nodes.type, RDF.Nodes.Statement).mapWith(Triple.getSubject);
    }

    @Override
    public ExtendedIterator<Node> allNodes(Triple t) {
        throw new BrokenException("this reifier operation");
    }

    @Override
    public void close() {
    }

    @Override
    public ExtendedIterator<Triple> find(TripleMatch m) {
        return this.base.find(m).filterKeep(isReificationTriple);
    }

    @Override
    public ExtendedIterator<Triple> findEither(TripleMatch m, boolean showHidden) {
        return showHidden == this.style.conceals() ? this.find(m) : Triple.None;
    }

    @Override
    public ExtendedIterator<Triple> findExposed(TripleMatch m) {
        return this.find(m);
    }

    @Override
    public Graph getParentGraph() {
        return this.graph;
    }

    @Override
    public ReificationStyle getStyle() {
        return this.style;
    }

    @Override
    public boolean handledAdd(Triple t) {
        this.base.add(t);
        return ReificationWrapper.isReificationTriple(t);
    }

    @Override
    public boolean handledRemove(Triple t) {
        throw new BrokenException("this reifier operation");
    }

    @Override
    public boolean hasTriple(Node n) {
        return this.getTriple(n) != null;
    }

    @Override
    public Node reifyAs(Node n, Triple t) {
        Triple already = this.getTriple(n);
        if (already == null) {
            this.checkQuadElementFree(n, RDF.Nodes.subject, t.getSubject());
            this.checkQuadElementFree(n, RDF.Nodes.predicate, t.getPredicate());
            this.checkQuadElementFree(n, RDF.Nodes.object, t.getObject());
            SimpleReifier.graphAddQuad(this.graph, n, t);
        } else if (!t.equals(already)) {
            throw new AlreadyReifiedException(n);
        }
        return n;
    }

    private void checkQuadElementFree(Node n, Node predicate, Node object) {
        List<Node> L = this.base.find(n, predicate, Node.ANY).mapWith(Triple.getObject).toList();
        if (L.size() == 0) {
            return;
        }
        if (L.size() == 1 && L.get(0).equals(object)) {
            return;
        }
        throw new CannotReifyException(n);
    }

    @Override
    public void remove(Node n, Triple t) {
        this.base.delete(Triple.create(n, RDF.Nodes.subject, t.getSubject()));
        this.base.delete(Triple.create(n, RDF.Nodes.predicate, t.getPredicate()));
        this.base.delete(Triple.create(n, RDF.Nodes.object, t.getObject()));
        this.base.delete(Triple.create(n, RDF.Nodes.type, RDF.Nodes.Statement));
    }

    @Override
    public void remove(Triple t) {
        throw new BrokenException("this reifier operation");
    }

    @Override
    public int size() {
        return this.style.conceals() ? 0 : this.countQuadlets();
    }

    int count(ExtendedIterator<?> find) {
        int result = 0;
        while (find.hasNext()) {
            ++result;
            find.next();
        }
        return result;
    }

    int countConcealed() {
        return this.style.conceals() ? this.countQuadlets() : 0;
    }

    private int countQuadlets() {
        return this.count(this.base.find(Node.ANY, RDF.Nodes.subject, Node.ANY)) + this.count(this.base.find(Node.ANY, RDF.Nodes.predicate, Node.ANY)) + this.count(this.base.find(Node.ANY, RDF.Nodes.object, Node.ANY)) + this.count(this.base.find(Node.ANY, RDF.Nodes.type, RDF.Nodes.Statement));
    }

    @Override
    public boolean hasTriple(Triple t) {
        Node X = Query.X;
        Node S = Query.S;
        Node P = Query.P;
        Node O = Query.O;
        Query q = ReificationWrapper.quadsQuery(Query.X);
        List<Domain> bindings = this.base.queryHandler().prepareBindings(q, new Node[]{X, S, P, O}).executeBindings().toList();
        return bindings.size() == 1 && t.equals(this.tripleFromRSPO(bindings.get(0)));
    }

    private Triple tripleFromRSPO(Domain domain) {
        return Triple.create(domain.getElement(1), domain.getElement(2), domain.getElement(3));
    }

    @Override
    public Triple getTriple(Node n) {
        Node S = Query.S;
        Node P = Query.P;
        Node O = Query.O;
        Query q = ReificationWrapper.quadsQuery(n);
        List<Domain> bindings = this.base.queryHandler().prepareBindings(q, new Node[]{S, P, O}).executeBindings().toList();
        return bindings.size() == 1 ? this.tripleFromSPO(bindings.get(0)) : null;
    }

    private static Query quadsQuery(Node subject) {
        return new Query().addMatch(subject, RDF.Nodes.subject, Query.S).addMatch(subject, RDF.Nodes.predicate, Query.P).addMatch(subject, RDF.Nodes.object, Query.O).addMatch(subject, RDF.Nodes.type, RDF.Nodes.Statement);
    }

    private Triple tripleFromSPO(Domain d) {
        return Triple.create(d.getElement(0), d.getElement(1), d.getElement(2));
    }

    private static boolean isReificationTriple(Triple t) {
        return Reifier.Util.isReificationPredicate(t.getPredicate()) || Reifier.Util.isReificationType(t.getPredicate(), t.getObject());
    }
}

