/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EnumConverter
implements Converter {
    public static final EnumConverter INSTANCE = new EnumConverter();

    EnumConverter() {
    }

    @Override
    public Object convert(JSON json, JSON.Context context, Object value, Class<?> c, Type t) throws Exception {
        if (value instanceof Map) {
            value = ((Map)value).get(null);
        } else if (value instanceof List) {
            List src = (List)value;
            value = !src.isEmpty() ? src.get(0) : null;
        }
        Enum[] enums = (Enum[])c.getEnumConstants();
        if (value instanceof Number) {
            return enums[((Number)value).intValue()];
        }
        if (value instanceof Boolean) {
            return enums[(Boolean)value != false ? 1 : 0];
        }
        if (value != null) {
            String str = value.toString().trim();
            if (str.length() == 0) {
                return null;
            }
            if (Character.isDigit(str.charAt(0))) {
                return enums[Integer.parseInt(str)];
            }
            for (Enum e : enums) {
                if (!str.equals(e.name())) continue;
                return e;
            }
            if (context.getEnumCaseStyle() != null) {
                for (Enum e : enums) {
                    if (!str.equals(context.getEnumCaseStyle().to(e.name()))) continue;
                    return e;
                }
            }
            throw new IllegalArgumentException(str + " is not " + c);
        }
        return null;
    }
}

