/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.binding;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.ResultBinding;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingBase;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.binding.BindingProjectNamed;
import java.util.Iterator;
import org.openjena.atlas.logging.Log;

public class BindingUtils {
    public static Binding asBinding(QuerySolution qSolution) {
        if (qSolution == null) {
            return null;
        }
        if (qSolution instanceof ResultBinding) {
            return new BindingProjectNamed(((ResultBinding)qSolution).getBinding());
        }
        BindingMap binding = BindingFactory.create();
        BindingUtils.addToBinding(binding, qSolution);
        return binding;
    }

    public static void addToBinding(BindingMap binding, QuerySolution qSolution) {
        if (qSolution == null) {
            return;
        }
        Iterator<String> iter = qSolution.varNames();
        while (iter.hasNext()) {
            String n = iter.next();
            RDFNode x = qSolution.get(n);
            if (Var.isBlankNodeVarName(n)) continue;
            try {
                binding.add(Var.alloc(n), x.asNode());
            }
            catch (ARQInternalErrorException ex) {
                Log.warn(BindingUtils.class, "Attempt to bind " + n + " when already bound");
            }
        }
    }

    public static void addAll(BindingMap dest, Binding src) {
        Iterator<Var> iter = src.vars();
        while (iter.hasNext()) {
            Var v = iter.next();
            Node n = src.get(v);
            dest.add(v, n);
        }
    }

    public static boolean equals(Binding b1, Binding b2) {
        return BindingBase.equals(b1, b2);
    }
}

