/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprException;
import com.hp.hpl.jena.sparql.expr.ExprFunctionN;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.Function;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.function.FunctionFactory;
import com.hp.hpl.jena.sparql.function.FunctionRegistry;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import java.util.List;

public class E_Function
extends ExprFunctionN {
    private static final String name = "function";
    public static boolean WarnOnUnknownFunction = true;
    private String functionIRI;
    private Function function = null;
    private boolean functionBound = false;

    public E_Function(String functionIRI, ExprList args) {
        super(name, args);
        this.functionIRI = functionIRI;
    }

    @Override
    public String getFunctionIRI() {
        return this.functionIRI;
    }

    @Override
    public NodeValue evalSpecial(Binding binding, FunctionEnv env) {
        if (!this.functionBound) {
            this.buildFunction(env.getContext());
        }
        if (this.function == null) {
            throw new ExprEvalException("URI <" + this.getFunctionIRI() + "> not bound");
        }
        NodeValue r = this.function.exec(binding, this.args, this.getFunctionIRI(), env);
        return r;
    }

    @Override
    protected NodeValue eval(List<NodeValue> args) {
        throw new ARQInternalErrorException();
    }

    public void buildFunction(Context cxt) {
        block2: {
            try {
                this.bindFunction(cxt);
            }
            catch (ExprException ex) {
                if (!WarnOnUnknownFunction) break block2;
                ARQ.getExecLogger().warn("URI <" + this.functionIRI + "> has no registered function factory");
            }
        }
    }

    private void bindFunction(Context cxt) {
        if (this.functionBound) {
            return;
        }
        FunctionRegistry registry = this.chooseRegistry(cxt);
        FunctionFactory ff = registry.get(this.functionIRI);
        if (ff == null) {
            this.functionBound = true;
            throw new ExprEvalException("URI <" + this.functionIRI + "> not found as a function");
        }
        this.function = ff.create(this.functionIRI);
        this.function.build(this.functionIRI, this.args);
        this.functionBound = true;
    }

    private FunctionRegistry chooseRegistry(Context context) {
        FunctionRegistry registry = FunctionRegistry.get(context);
        if (registry == null) {
            registry = FunctionRegistry.get();
        }
        return registry;
    }

    @Override
    public String getFunctionPrintName(SerializationContext cxt) {
        return FmtUtils.stringForURI(this.functionIRI, cxt);
    }

    @Override
    protected Expr copy(ExprList newArgs) {
        return new E_Function(this.getFunctionIRI(), newArgs);
    }
}

