/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.nodevalue;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueVisitor;
import com.hp.hpl.jena.sparql.util.Utils;
import java.math.BigDecimal;

public class NodeValueDecimal
extends NodeValue {
    BigDecimal decimal;

    public NodeValueDecimal(BigDecimal d) {
        this.decimal = d;
    }

    public NodeValueDecimal(BigDecimal d, Node n) {
        super(n);
        this.decimal = d;
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public boolean isDecimal() {
        return true;
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public BigDecimal getDecimal() {
        return this.decimal;
    }

    @Override
    public float getFloat() {
        return this.decimal.floatValue();
    }

    @Override
    public double getDouble() {
        return this.decimal.doubleValue();
    }

    @Override
    protected Node makeNode() {
        int s = this.decimal.scale();
        return Node.createLiteral((String)Utils.stringForm(this.decimal), null, (RDFDatatype)XSDDatatype.XSDdecimal);
    }

    @Override
    public String asString() {
        return this.toString();
    }

    @Override
    public String toString() {
        if (this.getNode() != null) {
            return super.asString();
        }
        return Utils.stringForm(this.decimal);
    }

    @Override
    public void visit(NodeValueVisitor visitor) {
        visitor.visit(this);
    }
}

