/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.lib.cache;

import org.openjena.atlas.iterator.Action;
import org.openjena.atlas.lib.ActionKeyValue;
import org.openjena.atlas.lib.CacheSet;
import org.openjena.atlas.lib.cache.CacheImpl;

public class CacheSetLRU<T>
implements CacheSet<T> {
    static Object theOnlyValue = new Object();
    CacheImpl<T, Object> cacheMap = null;

    public CacheSetLRU(int maxSize) {
        this(0.75f, maxSize);
    }

    public CacheSetLRU(float loadFactor, int maxSize) {
        this.cacheMap = new CacheImpl(loadFactor, maxSize);
    }

    @Override
    public synchronized void add(T e2) {
        this.cacheMap.put(e2, theOnlyValue);
    }

    @Override
    public synchronized void clear() {
        this.cacheMap.clear();
    }

    @Override
    public synchronized boolean contains(T obj) {
        return this.cacheMap.containsKey(obj);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.cacheMap.isEmpty();
    }

    @Override
    public synchronized void remove(T obj) {
        this.cacheMap.remove(obj);
    }

    @Override
    public synchronized long size() {
        return this.cacheMap.size();
    }

    static class Wrapper<T>
    implements ActionKeyValue<T, Object> {
        Action<T> dropHandler;

        public Wrapper(Action<T> dropHandler) {
            this.dropHandler = dropHandler;
        }

        @Override
        public void apply(T key, Object value) {
            this.dropHandler.apply(key);
        }
    }
}

