/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.tokens;

import java.io.IOException;
import java.nio.charset.MalformedInputException;
import java.util.NoSuchElementException;
import org.openjena.atlas.AtlasException;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.io.InStreamUTF8;
import org.openjena.atlas.io.PeekInputStream;
import org.openjena.riot.RiotParseException;
import org.openjena.riot.system.RiotChars;
import org.openjena.riot.tokens.Token;
import org.openjena.riot.tokens.TokenChecker;
import org.openjena.riot.tokens.TokenType;
import org.openjena.riot.tokens.Tokenizer;

public final class TokenizerBytes
implements Tokenizer {
    public static final int CTRL_CHAR = 42;
    public static boolean Checking = false;
    private Token token = null;
    private final StringBuilder stringBuilder = new StringBuilder(200);
    private final PeekInputStream inputStream;
    private boolean finished = false;
    private TokenChecker checker = null;

    TokenizerBytes(PeekInputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public final boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.token != null) {
            return true;
        }
        try {
            this.skip();
            if (this.inputStream.eof()) {
                this.finished = true;
                return false;
            }
            this.token = this.parseToken();
            if (this.token == null) {
                this.finished = true;
                return false;
            }
            return true;
        }
        catch (AtlasException ex) {
            if (ex.getCause().getClass() == MalformedInputException.class) {
                throw new RiotParseException("Bad character encoding", this.inputStream.getLineNum(), this.inputStream.getColNum());
            }
            throw new RiotParseException("Bad input stream", this.inputStream.getLineNum(), this.inputStream.getColNum());
        }
    }

    @Override
    public final Token next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Token t = this.token;
        this.token = null;
        return t;
    }

    @Override
    public final Token peek() {
        if (!this.hasNext()) {
            return null;
        }
        return this.token;
    }

    @Override
    public final boolean eof() {
        return this.hasNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public TokenChecker getChecker() {
        return this.checker;
    }

    public void setChecker(TokenChecker checker) {
        this.checker = checker;
    }

    @Override
    public void close() {
        try {
            this.inputStream.close();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    private void skip() {
        int ch = -1;
        while (true) {
            if (this.inputStream.eof()) {
                return;
            }
            ch = this.inputStream.peekByte();
            if (ch == 35) {
                this.inputStream.readByte();
                while ((ch = this.inputStream.peekByte()) != -1 && !RiotChars.isNewlineChar(ch)) {
                    this.inputStream.readByte();
                }
            }
            if (!RiotChars.isWhitespace(ch)) break;
            this.inputStream.readByte();
        }
    }

    private Token parseToken() {
        this.token = new Token(this.getLine(), this.getColumn());
        int chByte = this.inputStream.peekByte();
        if (chByte == 60) {
            this.inputStream.readByte();
            this.token.setImage(this.allBetween(60, 62, false, false));
            this.token.setType(TokenType.IRI);
            if (Checking) {
                this.checkURI(this.token.getImage());
            }
            return this.token;
        }
        if (chByte == 39 || chByte == 34) {
            this.inputStream.readByte();
            int ch2 = this.inputStream.peekByte();
            if (ch2 == chByte) {
                this.inputStream.readByte();
                int ch3 = this.inputStream.peekByte();
                if (ch3 == chByte) {
                    this.inputStream.readByte();
                    this.token.setImage(this.readLongString(chByte, false));
                    TokenType tt = chByte == 39 ? TokenType.LONG_STRING1 : TokenType.LONG_STRING2;
                    this.token.setType(tt);
                } else {
                    this.token.setImage("");
                    this.token.setType(chByte == 39 ? TokenType.STRING1 : TokenType.STRING2);
                }
            } else {
                this.token.setImage(this.allBetween(chByte, chByte, true, false));
                this.token.setType(chByte == 39 ? TokenType.STRING1 : TokenType.STRING2);
            }
            if (this.inputStream.peekByte() == 64) {
                this.inputStream.readByte();
                this.token.setImage2(this.langTag());
                this.token.setType(TokenType.LITERAL_LANG);
                if (Checking) {
                    this.checkLiteralLang(this.token.getImage(), this.token.getImage2());
                }
            } else if (this.inputStream.peekByte() == 94) {
                this.expect("^^");
                int nextCh = this.inputStream.peekByte();
                if (RiotChars.isWhitespace(nextCh)) {
                    this.exception("No whitespace after ^^ in literal with datatype");
                }
                Token mainToken = this.token;
                Token subToken = this.parseToken();
                if (!subToken.isIRI()) {
                    this.exception("Datatype URI required after ^^ - URI or prefixed name expected");
                }
                this.token = mainToken;
                this.token.setSubToken(subToken);
                this.token.setType(TokenType.LITERAL_DT);
                if (Checking) {
                    this.checkLiteralDT(this.token.getImage(), subToken);
                }
            } else if (Checking) {
                this.checkString(this.token.getImage());
            }
            return this.token;
        }
        if (chByte == 95) {
            this.expect("_:");
            this.token.setImage(this.readBlankNodeLabel());
            this.token.setType(TokenType.BNODE);
            if (Checking) {
                this.checkBlankNode(this.token.getImage());
            }
            return this.token;
        }
        if (chByte == 42) {
            this.inputStream.readByte();
            this.token.setType(TokenType.CNTRL);
            chByte = this.inputStream.readByte();
            if (chByte == -1) {
                this.exception("EOF found after 42");
            }
            this.token.cntrlCode = (char)chByte;
            if (Checking) {
                this.checkControl(this.token.cntrlCode);
            }
            return this.token;
        }
        if (chByte == 64) {
            this.inputStream.readByte();
            this.token.setType(TokenType.DIRECTIVE);
            this.token.setImage(this.readWord(false));
            if (Checking) {
                this.checkDirective(this.token.cntrlCode);
            }
            return this.token;
        }
        if (chByte == 63) {
            this.inputStream.readByte();
            this.token.setType(TokenType.VAR);
            this.token.setImage(this.readWord(true));
            if (Checking) {
                this.checkVariable(this.token.getImage());
            }
            return this.token;
        }
        switch (chByte) {
            case 46: {
                this.inputStream.readByte();
                chByte = this.inputStream.peekByte();
                if (RiotChars.range(chByte, '0', '9')) {
                    this.inputStream.pushbackByte(46);
                    this.readNumber();
                    return this.token;
                }
                this.token.setType(TokenType.DOT);
                return this.token;
            }
            case 59: {
                this.inputStream.readByte();
                this.token.setType(TokenType.SEMICOLON);
                this.token.setImage(";");
                return this.token;
            }
            case 44: {
                this.inputStream.readByte();
                this.token.setType(TokenType.COMMA);
                this.token.setImage(",");
                return this.token;
            }
            case 123: {
                this.inputStream.readByte();
                this.token.setType(TokenType.LBRACE);
                this.token.setImage("{");
                return this.token;
            }
            case 125: {
                this.inputStream.readByte();
                this.token.setType(TokenType.RBRACE);
                this.token.setImage("}");
                return this.token;
            }
            case 40: {
                this.inputStream.readByte();
                this.token.setType(TokenType.LPAREN);
                this.token.setImage("(");
                return this.token;
            }
            case 41: {
                this.inputStream.readByte();
                this.token.setType(TokenType.RPAREN);
                this.token.setImage(")");
                return this.token;
            }
            case 91: {
                this.inputStream.readByte();
                this.token.setType(TokenType.LBRACKET);
                this.token.setImage("[");
                return this.token;
            }
            case 93: {
                this.inputStream.readByte();
                this.token.setType(TokenType.RBRACKET);
                this.token.setImage("]");
                return this.token;
            }
            case 95: {
                this.inputStream.readByte();
                this.token.setType(TokenType.UNDERSCORE);
                this.token.setImage("_");
                return this.token;
            }
            case 60: {
                this.inputStream.readByte();
                this.token.setType(TokenType.LT);
                this.token.setImage("<");
                return this.token;
            }
            case 62: {
                this.inputStream.readByte();
                this.token.setType(TokenType.GT);
                this.token.setImage(">");
                return this.token;
            }
        }
        if (chByte == 43 || chByte == 45 || RiotChars.range(chByte, '0', '9')) {
            this.readNumber();
            if (Checking) {
                this.checkNumber(this.token.getImage(), this.token.getImage2());
            }
            return this.token;
        }
        this.readPrefixedNameOrKeyWord(this.token);
        if (Checking) {
            this.checkKeyword(this.token.getImage());
        }
        return this.token;
    }

    private void readPrefixedNameOrKeyWord(Token token2) {
        long posn = this.inputStream.getPosition();
        token2.setImage(this.readWord(false));
        token2.setType(TokenType.KEYWORD);
        int ch = this.inputStream.peekByte();
        if (ch == 58) {
            this.inputStream.readByte();
            token2.setType(TokenType.PREFIXED_NAME);
            String ln = this.readLocalPart();
            token2.setImage2(ln);
            if (Checking) {
                this.checkPrefixedName(token2.getImage(), token2.getImage2());
            }
        }
        if (posn == this.inputStream.getPosition()) {
            this.exception(String.format("Unknown char: %c(%d)", ch, ch));
        }
        if (Checking) {
            this.checkKeyword(token2.getImage());
        }
    }

    private String readLongString(int quoteChar, boolean endNL) {
        this.stringBuilder.setLength(0);
        while (true) {
            int ch;
            if ((ch = this.inputStream.readByte()) == -1) {
                if (endNL) {
                    return this.stringBuilder.toString();
                }
                this.exception("Broken long string");
            }
            if (ch == quoteChar && this.threeQuotes(quoteChar)) {
                return this.stringBuilder.toString();
            }
            if (ch == 92) {
                ch = this.readLiteralEscape();
            }
            this.insertCodepoint(this.stringBuilder, ch);
        }
    }

    private String readLocalPart() {
        return this.readWordSub(true, true);
    }

    private String readWord(boolean leadingDigitAllowed) {
        return this.readWordSub(leadingDigitAllowed, false);
    }

    private String readWordSub(boolean leadingDigitAllowed, boolean leadingSignAllowed) {
        int ch;
        this.stringBuilder.setLength(0);
        int idx = 0;
        if (!leadingDigitAllowed && Character.isDigit(ch = this.inputStream.peekByte())) {
            return "";
        }
        if (!(leadingSignAllowed || (ch = this.inputStream.peekByte()) != 45 && ch != 43)) {
            return "";
        }
        while (Character.isLetterOrDigit(ch = this.inputStream.peekByte()) || ch == 95 || ch == 46 || ch == 45) {
            this.inputStream.readByte();
            int ch2 = InStreamUTF8.advance(this.inputStream.getInput());
            this.stringBuilder.append((char)ch2);
            ++idx;
        }
        while (idx > 0 && this.stringBuilder.charAt(idx - 1) == '.') {
            this.inputStream.pushbackByte(46);
            this.stringBuilder.setLength(idx - 1);
            --idx;
        }
        return this.stringBuilder.toString();
    }

    private boolean threeQuotes(int ch) {
        int ch2 = this.inputStream.peekByte();
        if (ch2 != ch) {
            return false;
        }
        this.inputStream.readByte();
        int ch3 = this.inputStream.peekByte();
        if (ch3 != ch) {
            this.inputStream.pushbackByte(ch2);
            return false;
        }
        this.inputStream.readByte();
        return true;
    }

    private void readNumber() {
        boolean isDouble = false;
        boolean isDecimal = false;
        this.stringBuilder.setLength(0);
        int x = 0;
        int ch = this.inputStream.peekByte();
        if (ch == 48) {
            ++x;
            this.inputStream.readByte();
            this.stringBuilder.append((char)ch);
            ch = this.inputStream.peekByte();
            if (ch == 120 || ch == 88) {
                this.inputStream.readByte();
                this.stringBuilder.append((char)ch);
                TokenizerBytes.readHex(this.inputStream, this.stringBuilder);
                this.token.setImage(this.stringBuilder.toString());
                this.token.setType(TokenType.HEX);
                return;
            }
        } else if (ch == 45 || ch == 43) {
            this.readPossibleSign(this.stringBuilder);
        }
        x += this.readDigits(this.stringBuilder);
        ch = this.inputStream.peekByte();
        if (ch == 46) {
            this.inputStream.readByte();
            this.stringBuilder.append(46);
            isDecimal = true;
            this.readDigits(this.stringBuilder);
        }
        if (x == 0 && !isDecimal) {
            this.exception("Unrecognized as number");
        }
        if (this.exponent(this.stringBuilder)) {
            isDouble = true;
            isDecimal = false;
        }
        this.token.setImage(this.stringBuilder.toString());
        if (isDouble) {
            this.token.setType(TokenType.DOUBLE);
        } else if (isDecimal) {
            this.token.setType(TokenType.DECIMAL);
        } else {
            this.token.setType(TokenType.INTEGER);
        }
    }

    private static void readHex(PeekInputStream inputStream, StringBuilder sb) {
        int ch;
        int x = 0;
        while (RiotChars.range(ch = inputStream.peekByte(), '0', '9') || RiotChars.range(ch, 'a', 'f') || RiotChars.range(ch, 'A', 'F')) {
            inputStream.readByte();
            sb.append((char)ch);
            ++x;
        }
        if (x == 0) {
            TokenizerBytes.exception(inputStream, "No hex characters after " + sb.toString());
        }
    }

    private boolean exponent(StringBuilder sb) {
        int ch = this.inputStream.peekByte();
        if (ch != 101 && ch != 69) {
            return false;
        }
        this.inputStream.readByte();
        sb.append((char)ch);
        this.readPossibleSign(sb);
        int x = this.readDigits(sb);
        if (x == 0) {
            this.exception("Malformed double: " + sb);
        }
        return true;
    }

    private void readPossibleSign(StringBuilder sb) {
        int ch = this.inputStream.peekByte();
        if (ch == 45 || ch == 43) {
            this.inputStream.readByte();
            sb.append((char)ch);
        }
    }

    private int readDigits(StringBuilder buffer) {
        int ch;
        int count = 0;
        while (RiotChars.range(ch = this.inputStream.peekByte(), '0', '9')) {
            this.inputStream.readByte();
            buffer.append((char)ch);
            ++count;
        }
        return count;
    }

    private String langTag() {
        int ch;
        this.stringBuilder.setLength(0);
        this.a2z(this.stringBuilder);
        if (this.stringBuilder.length() == 0) {
            this.exception("Bad language tag");
        }
        while ((ch = this.inputStream.peekByte()) == 45) {
            this.inputStream.readByte();
            this.stringBuilder.append('-');
            int x = this.stringBuilder.length();
            this.a2zN(this.stringBuilder);
            if (this.stringBuilder.length() != x) continue;
            this.exception("Bad language tag");
        }
        return this.stringBuilder.toString();
    }

    private void a2z(StringBuilder sb2) {
        int ch;
        while (RiotChars.isA2Z(ch = this.inputStream.peekByte())) {
            this.inputStream.readByte();
            this.stringBuilder.append((char)ch);
        }
    }

    private void a2zN(StringBuilder sb2) {
        int ch;
        while (RiotChars.isA2ZN(ch = this.inputStream.peekByte())) {
            this.inputStream.readByte();
            this.stringBuilder.append((char)ch);
        }
    }

    private String readBlankNodeLabel() {
        this.stringBuilder.setLength(0);
        int ch = this.inputStream.peekByte();
        if (ch == -1) {
            this.exception("Blank node label missing (EOF found)");
        }
        if (RiotChars.isWhitespace(ch)) {
            this.exception("Blank node label missing");
        }
        if (!RiotChars.isAlphaNumeric(ch) && ch != 95) {
            this.exception("Blank node label does not start with alphabetic or _ :" + (char)ch);
        }
        this.inputStream.readByte();
        this.stringBuilder.append((char)ch);
        while ((ch = this.inputStream.peekByte()) != -1 && (RiotChars.isAlphaNumeric(ch) || ch == 45 || ch == 95)) {
            this.inputStream.readByte();
            this.stringBuilder.append((char)ch);
        }
        return this.stringBuilder.toString();
    }

    private String allBetween(int startCh, int endCh, boolean strEscapes, boolean endNL) {
        long y = this.getLine();
        long x = this.getColumn();
        this.stringBuilder.setLength(0);
        while (true) {
            int ch;
            if ((ch = this.inputStream.readByte()) == -1) {
                if (endNL) {
                    return this.stringBuilder.toString();
                }
                TokenizerBytes.exception("Broken token: " + this.stringBuilder.toString(), y, x);
            }
            if (ch == 10) {
                TokenizerBytes.exception("Broken token (newline): " + this.stringBuilder.toString(), y, x);
            }
            if (ch == endCh) {
                return this.stringBuilder.toString();
            }
            if (ch == 92) {
                ch = strEscapes ? this.readLiteralEscape() : this.readUnicodeEscape();
                this.insertCodepoint(this.stringBuilder, ch);
                continue;
            }
            this.insertChar(this.stringBuilder, ch);
        }
    }

    private void insertChar(StringBuilder buffer, int first) {
        int ch2 = InStreamUTF8.advance(this.inputStream.getInput(), first);
        this.insertCodepoint(buffer, ch2);
    }

    private void insertCodepoint(StringBuilder buffer, int ch) {
        if (Character.charCount(ch) == 1) {
            buffer.append((char)ch);
        } else {
            if (!Character.isDefined(ch) && !Character.isSupplementaryCodePoint(ch)) {
                this.exception(String.format("Illegal codepoint: 0x%04X", ch));
            }
            char[] chars = Character.toChars(ch);
            buffer.append(chars);
        }
    }

    @Override
    public long getColumn() {
        return this.inputStream.getColNum();
    }

    @Override
    public long getLine() {
        return this.inputStream.getLineNum();
    }

    private void checkBlankNode(String blankNodeLabel) {
        if (this.checker != null) {
            this.checker.checkBlankNode(blankNodeLabel);
        }
    }

    private void checkLiteralLang(String lexicalForm, String langTag) {
        if (this.checker != null) {
            this.checker.checkLiteralLang(lexicalForm, langTag);
        }
    }

    private void checkLiteralDT(String lexicalForm, Token datatype) {
        if (this.checker != null) {
            this.checker.checkLiteralDT(lexicalForm, datatype);
        }
    }

    private void checkString(String string) {
        if (this.checker != null) {
            this.checker.checkString(string);
        }
    }

    private void checkURI(String uriStr) {
        if (this.checker != null) {
            this.checker.checkURI(uriStr);
        }
    }

    private void checkNumber(String image, String datatype) {
        if (this.checker != null) {
            this.checker.checkNumber(image, datatype);
        }
    }

    private void checkVariable(String tokenImage) {
        if (this.checker != null) {
            this.checker.checkVariable(tokenImage);
        }
    }

    private void checkDirective(int cntrlCode) {
        if (this.checker != null) {
            this.checker.checkDirective(cntrlCode);
        }
    }

    private void checkKeyword(String tokenImage) {
        if (this.checker != null) {
            this.checker.checkKeyword(tokenImage);
        }
    }

    private void checkPrefixedName(String tokenImage, String tokenImage2) {
        if (this.checker != null) {
            this.checker.checkPrefixedName(tokenImage, tokenImage2);
        }
    }

    private void checkControl(int code) {
        if (this.checker != null) {
            this.checker.checkControl(code);
        }
    }

    private final int readLiteralEscape() {
        int c = this.inputStream.readByte();
        if (c == -1) {
            this.exception("Escape sequence not completed");
        }
        switch (c) {
            case 110: {
                return 10;
            }
            case 114: {
                return 13;
            }
            case 116: {
                return 9;
            }
            case 34: {
                return 34;
            }
            case 39: {
                return 39;
            }
            case 92: {
                return 92;
            }
            case 117: {
                return this.readUnicode4Escape();
            }
            case 85: {
                return this.readUnicode8Escape();
            }
        }
        this.exception(String.format("illegal escape sequence value: %c (0x%02X)", c, c));
        return 0;
    }

    private final int readUnicodeEscape() {
        int ch = this.inputStream.readByte();
        if (ch == -1) {
            this.exception("Broken escape sequence");
        }
        switch (ch) {
            case 117: {
                return this.readUnicode4Escape();
            }
            case 85: {
                return this.readUnicode8Escape();
            }
        }
        this.exception(String.format("illegal escape sequence value: %c (0x%02X)", ch, ch));
        return 0;
    }

    private final int readUnicode4Escape() {
        return this.readUnicodeEscape(4);
    }

    private final int readUnicode8Escape() {
        int ch8 = this.readUnicodeEscape(8);
        if (ch8 > 0x10FFFF) {
            this.exception(String.format("illegal code point in \\U sequence value: 0x%08X", ch8));
        }
        return ch8;
    }

    private final int readUnicodeEscape(int N) {
        int x = 0;
        for (int i = 0; i < N; ++i) {
            int d = this.readHexChar();
            if (d < 0) {
                return -1;
            }
            x = (x << 4) + d;
        }
        return x;
    }

    private final int readHexChar() {
        int x;
        int ch = this.inputStream.readByte();
        if (ch == -1) {
            this.exception("Not a hexadecimal character (end of file)");
        }
        if ((x = RiotChars.valHexChar(ch)) != -1) {
            return x;
        }
        this.exception("Not a hexadecimal character: " + (char)ch);
        return -1;
    }

    private boolean expect(String str2) {
        for (int i = 0; i < str2.length(); ++i) {
            char want = str2.charAt(i);
            if (this.inputStream.eof()) {
                this.exception("End of input during expected string: " + str2);
                return false;
            }
            int inChar = this.inputStream.readByte();
            if (inChar == want) continue;
            this.exception("expected \"" + str2 + "\"");
            return false;
        }
        return true;
    }

    private void exception(String message) {
        TokenizerBytes.exception(message, this.inputStream.getLineNum(), this.inputStream.getColNum());
    }

    private static void exception(PeekInputStream inputStream, String message) {
        TokenizerBytes.exception(message, inputStream.getLineNum(), inputStream.getColNum());
    }

    private static void exception(String message, long line, long col) {
        throw new RiotParseException(message, line, col);
    }
}

