/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.util.Enumeration;
import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.NullFormatter;
import net.arnx.jsonic.io.OutputSource;

final class EnumerationFormatter
implements Formatter {
    public static final EnumerationFormatter INSTANCE = new EnumerationFormatter();

    EnumerationFormatter() {
    }

    public boolean format(JSON json, JSON.Context context, Object src, Object o, OutputSource out) throws Exception {
        Enumeration e = (Enumeration)o;
        JSONHint hint = context.getHint();
        out.append('[');
        int count = 0;
        Class<?> lastClass = null;
        Formatter lastFormatter = null;
        while (e.hasMoreElements()) {
            Object item = e.nextElement();
            if (item == src) {
                item = null;
            }
            if (count != 0) {
                out.append(',');
            }
            if (context.isPrettyPrint()) {
                out.append('\n');
                for (int j = 0; j < context.getLevel() + 1; ++j) {
                    out.append('\t');
                }
            }
            context.enter(count, hint);
            item = json.preformatInternal(context, item);
            if (item == null) {
                NullFormatter.INSTANCE.format(json, context, src, item, out);
            } else if (hint == null) {
                if (item.getClass().equals(lastClass)) {
                    lastFormatter.format(json, context, src, item, out);
                } else {
                    lastFormatter = json.formatInternal(context, item, out);
                    lastClass = item.getClass();
                }
            } else {
                json.formatInternal(context, item, out);
            }
            context.exit();
            ++count;
        }
        if (context.isPrettyPrint() && count > 0) {
            out.append('\n');
            for (int j = 0; j < context.getLevel(); ++j) {
                out.append('\t');
            }
        }
        out.append(']');
        return true;
    }
}

