/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms;

import info.aduna.concurrent.locks.ExclusiveLockManager;
import info.aduna.concurrent.locks.Lock;
import info.aduna.iteration.CloseableIteration;
import java.sql.SQLException;
import java.util.Collection;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.NamespaceImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.impl.EmptyBindingSet;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.DefaultSailChangedEvent;
import org.openrdf.sail.helpers.SailConnectionBase;
import org.openrdf.sail.rdbms.RdbmsStore;
import org.openrdf.sail.rdbms.RdbmsTripleRepository;
import org.openrdf.sail.rdbms.RdbmsValueFactory;
import org.openrdf.sail.rdbms.evaluation.RdbmsEvaluation;
import org.openrdf.sail.rdbms.evaluation.RdbmsEvaluationFactory;
import org.openrdf.sail.rdbms.exceptions.RdbmsException;
import org.openrdf.sail.rdbms.iteration.NamespaceIteration;
import org.openrdf.sail.rdbms.iteration.RdbmsResourceIteration;
import org.openrdf.sail.rdbms.managers.NamespaceManager;
import org.openrdf.sail.rdbms.model.RdbmsResource;
import org.openrdf.sail.rdbms.model.RdbmsURI;
import org.openrdf.sail.rdbms.model.RdbmsValue;
import org.openrdf.sail.rdbms.optimizers.RdbmsQueryOptimizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RdbmsConnection
extends SailConnectionBase {
    private RdbmsStore sail;
    private RdbmsValueFactory vf;
    private RdbmsTripleRepository triples;
    private NamespaceManager namespaces;
    private RdbmsQueryOptimizer optimizer;
    private RdbmsEvaluationFactory factory;
    private ExclusiveLockManager lockManager;
    private Lock lock;

    public RdbmsConnection(RdbmsStore sail, RdbmsTripleRepository triples) {
        super(sail);
        this.sail = sail;
        this.vf = sail.getValueFactory();
        this.triples = triples;
    }

    public void setNamespaces(NamespaceManager namespaces) {
        this.namespaces = namespaces;
    }

    public void setRdbmsQueryOptimizer(RdbmsQueryOptimizer optimizer) {
        this.optimizer = optimizer;
    }

    public void setRdbmsEvaluationFactory(RdbmsEvaluationFactory factory) {
        this.factory = factory;
    }

    public void setLockManager(ExclusiveLockManager lock) {
        this.lockManager = lock;
    }

    @Override
    protected void addStatementInternal(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        try {
            if (contexts.length == 0) {
                this.triples.add(this.vf.createStatement(subj, pred, obj));
            } else {
                for (Resource ctx : contexts) {
                    this.triples.add(this.vf.createStatement(subj, pred, obj, ctx));
                }
            }
        }
        catch (SQLException e) {
            throw new RdbmsException(e);
        }
        catch (InterruptedException e) {
            throw new RdbmsException(e);
        }
    }

    @Override
    protected void clearInternal(Resource ... contexts) throws SailException {
        this.removeStatementsInternal(null, null, null, contexts);
    }

    @Override
    protected void closeInternal() throws SailException {
        try {
            this.triples.close();
        }
        catch (SQLException e) {
            throw new RdbmsException(e);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    protected void commitInternal() throws SailException {
        try {
            this.triples.commit();
            this.unlock();
        }
        catch (SQLException e) {
            throw new RdbmsException(e);
        }
        catch (InterruptedException e) {
            throw new RdbmsException(e);
        }
        this.triples.setSailChangedEvent(new DefaultSailChangedEvent(this.sail));
    }

    protected RdbmsResourceIteration getContextIDsInternal() throws SailException {
        try {
            return this.triples.findContexts();
        }
        catch (SQLException e) {
            throw new RdbmsException(e);
        }
    }

    @Override
    protected CloseableIteration<? extends Statement, SailException> getStatementsInternal(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        RdbmsResource s = this.vf.asRdbmsResource(subj);
        RdbmsURI p = this.vf.asRdbmsURI(pred);
        RdbmsValue o = this.vf.asRdbmsValue(obj);
        Resource[] c = this.vf.asRdbmsResource(contexts);
        return this.triples.find(s, p, o, c);
    }

    @Override
    protected void removeStatementsInternal(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        RdbmsResource s = this.vf.asRdbmsResource(subj);
        RdbmsURI p = this.vf.asRdbmsURI(pred);
        RdbmsValue o = this.vf.asRdbmsValue(obj);
        Resource[] c = this.vf.asRdbmsResource(contexts);
        this.triples.remove(s, p, o, c);
    }

    @Override
    protected void rollbackInternal() throws SailException {
        try {
            this.triples.rollback();
        }
        catch (SQLException e) {
            throw new RdbmsException(e);
        }
        finally {
            this.unlock();
        }
    }

    protected CloseableIteration<BindingSet, QueryEvaluationException> evaluateInternal(TupleExpr expr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        this.triples.flush();
        try {
            RdbmsEvaluation strategy = this.factory.createRdbmsEvaluation(dataset);
            TupleExpr tupleExpr = this.optimizer.optimize(expr, dataset, bindings, strategy);
            return strategy.evaluate(tupleExpr, EmptyBindingSet.getInstance());
        }
        catch (QueryEvaluationException e) {
            throw new SailException(e);
        }
    }

    @Override
    protected void clearNamespacesInternal() throws SailException {
        this.namespaces.clearPrefixes();
    }

    @Override
    protected String getNamespaceInternal(String prefix) throws SailException {
        NamespaceImpl ns = this.namespaces.findByPrefix(prefix);
        if (ns == null) {
            return null;
        }
        return ns.getName();
    }

    @Override
    protected CloseableIteration<? extends Namespace, SailException> getNamespacesInternal() throws SailException {
        Collection<? extends Namespace> ns = this.namespaces.getNamespacesWithPrefix();
        return new NamespaceIteration(ns.iterator());
    }

    @Override
    protected void removeNamespaceInternal(String prefix) throws SailException {
        this.namespaces.removePrefix(prefix);
    }

    @Override
    protected void setNamespaceInternal(String prefix, String name) throws SailException {
        this.namespaces.setPrefix(prefix, name);
    }

    @Override
    protected long sizeInternal(Resource ... contexts) throws SailException {
        try {
            return this.triples.size(this.vf.asRdbmsResource(contexts));
        }
        catch (SQLException e) {
            throw new RdbmsException(e);
        }
    }

    @Override
    protected void startTransactionInternal() throws SailException {
        try {
            this.lock();
            this.triples.begin();
        }
        catch (SQLException e) {
            this.unlock();
            throw new RdbmsException(e);
        }
        catch (InterruptedException e) {
            this.unlock();
            throw new RdbmsException(e);
        }
    }

    @Override
    protected void finalize() throws Throwable {
        this.unlock();
        super.finalize();
    }

    private void lock() throws InterruptedException {
        if (this.lockManager != null) {
            this.lock = this.lockManager.getExclusiveLock();
        }
    }

    private void unlock() {
        if (this.lockManager != null && this.lock != null) {
            this.lock.release();
            this.lock = null;
        }
    }
}

