/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.mysql;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.openrdf.sail.SailException;
import org.openrdf.sail.rdbms.RdbmsStore;
import org.openrdf.sail.rdbms.exceptions.RdbmsException;
import org.openrdf.sail.rdbms.mysql.MySqlConnectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySqlStore
extends RdbmsStore {
    private String serverName = "localhost";
    private String databaseName;
    private int portNumber;
    private Map<String, String> properties = Collections.emptyMap();
    private String user;
    private String password;

    public MySqlStore() {
    }

    public MySqlStore(String databaseName) {
        this.setDatabaseName(databaseName);
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = new HashMap<String, String>(properties);
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void initialize() throws SailException {
        try {
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RdbmsException(e.toString(), e);
        }
        StringBuilder url = new StringBuilder();
        url.append("jdbc:mysql:");
        if (this.serverName != null) {
            url.append("//").append(this.serverName);
            if (this.portNumber > 0) {
                url.append(":").append(this.portNumber);
            }
            url.append("/");
        }
        url.append(this.databaseName);
        url.append("?useUnicode=yes&characterEncoding=UTF-8");
        for (Map.Entry<String, String> e : this.getProperties().entrySet()) {
            url.append("&");
            url.append(this.enc(e.getKey()));
            url.append("=");
            url.append(this.enc(e.getValue()));
        }
        BasicDataSource ds = new BasicDataSource();
        ds.setUrl(url.toString());
        if (this.user != null) {
            ds.setUsername(this.user);
        } else {
            ds.setUsername(System.getProperty("user.name"));
        }
        if (this.password != null) {
            ds.setPassword(this.password);
        }
        MySqlConnectionFactory factory = new MySqlConnectionFactory();
        factory.setSail(this);
        factory.setDataSource((DataSource)ds);
        this.setBasicDataSource(ds);
        this.setConnectionFactory(factory);
        super.initialize();
    }

    private String enc(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

