/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.app.net;

import info.aduna.app.config.Configuration;
import info.aduna.app.util.ConfigurationUtil;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;

public class ProxySettings
implements Configuration {
    private static final String PROPNAME_PROXIES_ENABLED = "proxies.enabled";
    private static final String PROPNAME_PROXIES_NONPROXYHOSTS_STARTING = "proxies.nonProxyHosts.starting";
    private static final String PROPNAME_HTTP_PROXYHOST = "http.proxyHost";
    private static final String PROPNAME_HTTP_PROXYPORT = "http.proxyPort";
    private static final String PROPNAME_HTTPS_PROXYHOST = "https.proxyHost";
    private static final String PROPNAME_HTTPS_PROXYPORT = "https.proxyPort";
    private static final String PROPNAME_FTP_PROXYHOST = "ftp.proxyHost";
    private static final String PROPNAME_FTP_PROXYPORT = "ftp.proxyPort";
    private static final String PROPNAME_SOCKS_PROXYHOST = "socksProxyHost";
    private static final String PROPNAME_SOCKS_PROXYPORT = "socksProxyPort";
    private Properties props;
    public static final String PROXY_SETTINGS_FILENAME = "proxy.properties";
    private File confDir;
    private File propsFile;

    public ProxySettings(File applicationDataDir) throws IOException {
        this.confDir = new File(applicationDataDir, "conf");
    }

    public void setProperty(String key, String val) {
        if (val == null) {
            this.props.remove(key);
        } else {
            this.props.setProperty(key, val);
        }
    }

    private void setSystemProperty(String key, String val) {
        if (val == null) {
            System.getProperties().remove(key);
        } else {
            System.setProperty(key, val);
        }
    }

    public boolean getProxiesEnabled() {
        String val = this.props.getProperty(PROPNAME_PROXIES_ENABLED);
        if (val != null) {
            val = val.trim();
        }
        return String.valueOf(true).equalsIgnoreCase(val);
    }

    public void setProxiesEnabled(boolean proxiesEnabled) {
        this.props.setProperty(PROPNAME_PROXIES_ENABLED, String.valueOf(proxiesEnabled));
    }

    public String getHttpProxyHost() {
        return this.props.getProperty(PROPNAME_HTTP_PROXYHOST);
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.setProperty(PROPNAME_HTTP_PROXYHOST, httpProxyHost);
        this.setProxySystemProperty(PROPNAME_HTTP_PROXYHOST, httpProxyHost);
    }

    public String getHttpProxyPort() {
        return this.props.getProperty(PROPNAME_HTTP_PROXYPORT);
    }

    public void setHttpProxyPort(String httpProxyPort) {
        this.setProperty(PROPNAME_HTTP_PROXYPORT, httpProxyPort);
        this.setProxySystemProperty(PROPNAME_HTTP_PROXYPORT, httpProxyPort);
    }

    public String getHttpsProxyHost() {
        return this.props.getProperty(PROPNAME_HTTPS_PROXYHOST);
    }

    public void setHttpsProxyHost(String httpsProxyHost) {
        this.setProperty(PROPNAME_HTTPS_PROXYHOST, httpsProxyHost);
        this.setProxySystemProperty(PROPNAME_HTTPS_PROXYHOST, httpsProxyHost);
    }

    public String getHttpsProxyPort() {
        return this.props.getProperty(PROPNAME_HTTPS_PROXYPORT);
    }

    public void setHttpsProxyPort(String httpsProxyPort) {
        this.setProperty(PROPNAME_HTTPS_PROXYPORT, httpsProxyPort);
        this.setProxySystemProperty(PROPNAME_HTTPS_PROXYPORT, httpsProxyPort);
    }

    public String getFtpProxyHost() {
        return this.props.getProperty(PROPNAME_FTP_PROXYHOST);
    }

    public void setFtpProxyHost(String ftpProxyHost) {
        this.setProperty(PROPNAME_FTP_PROXYHOST, ftpProxyHost);
        this.setProxySystemProperty(PROPNAME_FTP_PROXYHOST, ftpProxyHost);
    }

    public String getFtpProxyPort() {
        return this.props.getProperty(PROPNAME_FTP_PROXYPORT);
    }

    public void setFtpProxyPort(String ftpProxyPort) {
        this.setProperty(PROPNAME_FTP_PROXYPORT, ftpProxyPort);
        this.setProxySystemProperty(PROPNAME_FTP_PROXYPORT, ftpProxyPort);
    }

    public String getSocksProxyHost() {
        return this.props.getProperty(PROPNAME_SOCKS_PROXYHOST);
    }

    public void setSocksProxyHost(String socksProxyHost) {
        this.setProperty(PROPNAME_SOCKS_PROXYHOST, socksProxyHost);
        this.setProxySystemProperty(PROPNAME_SOCKS_PROXYHOST, socksProxyHost);
    }

    public String getSocksProxyPort() {
        return this.props.getProperty(PROPNAME_SOCKS_PROXYPORT);
    }

    public void setSocksProxyPort(String socksProxyPort) {
        this.setProperty(PROPNAME_SOCKS_PROXYPORT, socksProxyPort);
        this.setProxySystemProperty(PROPNAME_SOCKS_PROXYPORT, socksProxyPort);
    }

    private void setProxySystemProperty(String key, String val) {
        if (this.getProxiesEnabled()) {
            this.setSystemProperty(key, val);
        } else {
            this.setSystemProperty(key, null);
        }
    }

    public String getNonProxyHostsStarting() {
        return this.props.getProperty(PROPNAME_PROXIES_NONPROXYHOSTS_STARTING);
    }

    public void setNonProxyHostsStarting(String nonProxyHostsStarting) {
        this.setProperty(PROPNAME_PROXIES_NONPROXYHOSTS_STARTING, nonProxyHostsStarting);
        StringBuilder sysPropBuffer = new StringBuilder();
        if (nonProxyHostsStarting != null) {
            StringTokenizer st = new StringTokenizer(nonProxyHostsStarting, ";");
            while (st.hasMoreTokens()) {
                sysPropBuffer.append(st.nextToken().trim());
                sysPropBuffer.append('*');
                if (!st.hasMoreTokens()) continue;
                sysPropBuffer.append('|');
            }
        }
        String sysPropValue = null;
        if (sysPropBuffer.length() > 0) {
            sysPropValue = sysPropBuffer.toString();
        }
        this.setProxySystemProperty("http.nonProxyHosts", sysPropValue);
        this.setProxySystemProperty("ftp.nonProxyHosts", sysPropValue);
    }

    public void load() throws IOException {
        Properties proxyConfig = ConfigurationUtil.loadConfigurationProperties(PROXY_SETTINGS_FILENAME, null);
        this.propsFile = new File(this.confDir, PROXY_SETTINGS_FILENAME);
        this.props = ConfigurationUtil.loadConfigurationProperties(this.propsFile, proxyConfig);
    }

    public void save() throws IOException {
        if (!this.props.isEmpty()) {
            ConfigurationUtil.saveConfigurationProperties(this.props, this.propsFile, false);
        }
        ConfigurationUtil.saveConfigurationProperties(this.props, new File(this.propsFile.getParentFile(), this.propsFile.getName() + ".default"), true);
    }

    public void destroy() throws IOException {
    }

    public void init() throws IOException {
        this.load();
        this.setHttpProxyHost(this.getHttpProxyHost());
        this.setHttpProxyPort(this.getHttpProxyPort());
        this.setHttpsProxyHost(this.getHttpsProxyHost());
        this.setHttpsProxyPort(this.getHttpsProxyPort());
        this.setFtpProxyHost(this.getFtpProxyHost());
        this.setFtpProxyPort(this.getFtpProxyPort());
        this.setSocksProxyHost(this.getSocksProxyHost());
        this.setSocksProxyPort(this.getSocksProxyPort());
        this.setNonProxyHostsStarting(this.getNonProxyHostsStarting());
        this.save();
    }
}

