/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.query.algebra.ProjectionElem;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelNodeBase;
import org.openrdf.query.algebra.QueryModelVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectionElemList
extends QueryModelNodeBase {
    private List<ProjectionElem> elements = new ArrayList<ProjectionElem>();

    public ProjectionElemList() {
    }

    public ProjectionElemList(ProjectionElem ... elements) {
        this.addElements(elements);
    }

    public ProjectionElemList(Iterable<ProjectionElem> elements) {
        this.addElements(elements);
    }

    public List<ProjectionElem> getElements() {
        return this.elements;
    }

    public void setElements(List<ProjectionElem> elements) {
        this.elements = elements;
    }

    public void addElements(ProjectionElem ... elements) {
        for (ProjectionElem pe : elements) {
            this.addElement(pe);
        }
    }

    public void addElements(Iterable<ProjectionElem> elements) {
        for (ProjectionElem pe : elements) {
            this.addElement(pe);
        }
    }

    public void addElement(ProjectionElem pe) {
        assert (pe != null) : "pe must not be null";
        this.elements.add(pe);
        pe.setParentNode(this);
    }

    public Set<String> getTargetNames() {
        LinkedHashSet<String> targetNames = new LinkedHashSet<String>(this.elements.size());
        for (ProjectionElem pe : this.elements) {
            targetNames.add(pe.getTargetName());
        }
        return targetNames;
    }

    public Set<String> getTargetNamesFor(Collection<String> sourceNames) {
        LinkedHashSet<String> targetNames = new LinkedHashSet<String>(this.elements.size());
        for (ProjectionElem pe : this.elements) {
            if (!sourceNames.contains(pe.getSourceName())) continue;
            targetNames.add(pe.getTargetName());
        }
        return targetNames;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        for (ProjectionElem pe : this.elements) {
            pe.visit(visitor);
        }
        super.visitChildren(visitor);
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        if (this.replaceNodeInList(this.elements, current, replacement)) {
            return;
        }
        super.replaceChildNode(current, replacement);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ProjectionElemList) {
            ProjectionElemList o = (ProjectionElemList)other;
            return ((Object)this.elements).equals(o.getElements());
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.elements).hashCode();
    }

    @Override
    public ProjectionElemList clone() {
        ProjectionElemList clone = (ProjectionElemList)super.clone();
        clone.elements = new ArrayList<ProjectionElem>(this.getElements().size());
        for (ProjectionElem pe : this.getElements()) {
            clone.addElement(pe.clone());
        }
        return clone;
    }
}

