/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStatistics;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;
import org.openrdf.query.algebra.helpers.StatementPatternCollector;

public class QueryJoinOptimizer
implements QueryOptimizer {
    protected final EvaluationStatistics statistics;

    public QueryJoinOptimizer() {
        this(new EvaluationStatistics());
    }

    public QueryJoinOptimizer(EvaluationStatistics statistics) {
        this.statistics = statistics;
    }

    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit(new JoinVisitor());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JoinVisitor
    extends QueryModelVisitorBase<RuntimeException> {
        Set<String> boundVars = new HashSet<String>();

        protected JoinVisitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void meet(LeftJoin leftJoin) {
            leftJoin.getLeftArg().visit(this);
            Set<String> origBoundVars = this.boundVars;
            try {
                this.boundVars = new HashSet<String>(this.boundVars);
                this.boundVars.addAll(leftJoin.getLeftArg().getBindingNames());
                leftJoin.getRightArg().visit(this);
            }
            finally {
                this.boundVars = origBoundVars;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void meet(Join node) {
            Set<String> origBoundVars = this.boundVars;
            try {
                this.boundVars = new HashSet<String>(this.boundVars);
                ArrayList<TupleExpr> joinArgs = this.getJoinArgs(node, new ArrayList());
                HashMap<TupleExpr, Double> cardinalityMap = new HashMap<TupleExpr, Double>();
                HashMap<TupleExpr, List<Var>> varsMap = new HashMap<TupleExpr, List<Var>>();
                for (TupleExpr tupleExpr : joinArgs) {
                    cardinalityMap.put(tupleExpr, QueryJoinOptimizer.this.statistics.getCardinality(tupleExpr));
                    varsMap.put(tupleExpr, this.getStatementPatternVars(tupleExpr));
                }
                HashMap<Var, Integer> varFreqMap = new HashMap<Var, Integer>();
                for (List varList : varsMap.values()) {
                    this.getVarFreqMap(varList, varFreqMap);
                }
                ArrayList<TupleExpr> orderedJoinArgs = new ArrayList<TupleExpr>(joinArgs.size());
                while (!joinArgs.isEmpty()) {
                    TupleExpr tupleExpr = this.selectNextTupleExpr(joinArgs, cardinalityMap, varsMap, varFreqMap, this.boundVars);
                    joinArgs.remove(tupleExpr);
                    orderedJoinArgs.add(tupleExpr);
                    tupleExpr.visit(this);
                    this.boundVars.addAll(tupleExpr.getBindingNames());
                }
                int i = orderedJoinArgs.size() - 1;
                TupleExpr replacement = (TupleExpr)orderedJoinArgs.get(i);
                --i;
                while (i >= 0) {
                    replacement = new Join((TupleExpr)orderedJoinArgs.get(i), replacement);
                    --i;
                }
                node.replaceWith(replacement);
            }
            finally {
                this.boundVars = origBoundVars;
            }
        }

        protected <L extends List<TupleExpr>> L getJoinArgs(TupleExpr tupleExpr, L joinArgs) {
            if (tupleExpr instanceof Join) {
                Join join = (Join)tupleExpr;
                this.getJoinArgs(join.getLeftArg(), joinArgs);
                this.getJoinArgs(join.getRightArg(), joinArgs);
            } else {
                joinArgs.add((TupleExpr)tupleExpr);
            }
            return joinArgs;
        }

        protected List<Var> getStatementPatternVars(TupleExpr tupleExpr) {
            List<StatementPattern> stPatterns = StatementPatternCollector.process(tupleExpr);
            ArrayList<Var> varList = new ArrayList<Var>(stPatterns.size() * 4);
            for (StatementPattern sp : stPatterns) {
                sp.getVars(varList);
            }
            return varList;
        }

        protected <M extends Map<Var, Integer>> M getVarFreqMap(List<Var> varList, M varFreqMap) {
            for (Var var : varList) {
                Integer freq = varFreqMap.get(var);
                freq = freq == null ? 1 : freq + 1;
                varFreqMap.put((Var)var, (Integer)freq);
            }
            return varFreqMap;
        }

        protected TupleExpr selectNextTupleExpr(List<TupleExpr> expressions, Map<TupleExpr, Double> cardinalityMap, Map<TupleExpr, List<Var>> varsMap, Map<Var, Integer> varFreqMap, Set<String> boundVars) {
            double lowestCardinality = Double.MAX_VALUE;
            TupleExpr result = null;
            for (TupleExpr tupleExpr : expressions) {
                double cardinality = this.getTupleExprCardinality(tupleExpr, cardinalityMap, varsMap, varFreqMap, boundVars);
                if (!(cardinality < lowestCardinality)) continue;
                lowestCardinality = cardinality;
                result = tupleExpr;
            }
            return result;
        }

        protected double getTupleExprCardinality(TupleExpr tupleExpr, Map<TupleExpr, Double> cardinalityMap, Map<TupleExpr, List<Var>> varsMap, Map<Var, Integer> varFreqMap, Set<String> boundVars) {
            double cardinality = cardinalityMap.get(tupleExpr);
            List<Var> vars = varsMap.get(tupleExpr);
            List<Var> unboundVars = this.getUnboundVars(vars);
            List<Var> constantVars = this.getConstantVars(vars);
            int nonConstantVarCount = vars.size() - constantVars.size();
            if (nonConstantVarCount > 0) {
                double exp = (double)unboundVars.size() / (double)nonConstantVarCount;
                cardinality = Math.pow(cardinality, exp);
            }
            if (unboundVars.isEmpty()) {
                if (nonConstantVarCount > 0) {
                    cardinality /= (double)nonConstantVarCount;
                }
            } else {
                int foreignVarFreq = this.getForeignVarFreq(unboundVars, varFreqMap);
                if (foreignVarFreq > 0) {
                    cardinality /= (double)foreignVarFreq;
                }
            }
            return cardinality;
        }

        protected List<Var> getConstantVars(Iterable<Var> vars) {
            ArrayList<Var> constantVars = new ArrayList<Var>();
            for (Var var : vars) {
                if (!var.hasValue()) continue;
                constantVars.add(var);
            }
            return constantVars;
        }

        protected List<Var> getUnboundVars(Iterable<Var> vars) {
            ArrayList<Var> unboundVars = new ArrayList<Var>();
            for (Var var : vars) {
                if (var.hasValue() || this.boundVars.contains(var.getName())) continue;
                unboundVars.add(var);
            }
            return unboundVars;
        }

        protected int getForeignVarFreq(List<Var> ownUnboundVars, Map<Var, Integer> varFreqMap) {
            int result = 0;
            HashMap ownFreqMap = this.getVarFreqMap(ownUnboundVars, new HashMap());
            for (Map.Entry entry : ownFreqMap.entrySet()) {
                Var var = (Var)entry.getKey();
                int ownFreq = (Integer)entry.getValue();
                result += varFreqMap.get(var) - ownFreq;
            }
            return result;
        }
    }
}

