/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdUpdate;
import com.hp.hpl.jena.sparql.SystemARQ;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.UpdateExecutionFactory;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import java.util.List;
import org.openjena.riot.out.NQuadsWriter;

public class update
extends CmdUpdate {
    static final ArgDecl updateArg = new ArgDecl(true, "update", "file");
    static final ArgDecl dumpArg = new ArgDecl(false, "dump");
    List<String> requestFiles = null;
    boolean dump = false;

    public static void main(String ... argv) {
        new update(argv).mainRun();
    }

    protected update(String[] argv) {
        super(argv);
        super.add(updateArg, "--update=FILE", "Update commands to execute");
        super.add(dumpArg, "--dump", "Dump the resulting graph store");
    }

    @Override
    protected void processModulesAndArgs() {
        this.requestFiles = this.getValues(updateArg);
        this.dump = this.contains(dumpArg);
        super.processModulesAndArgs();
    }

    @Override
    protected String getCommandName() {
        return Utils.className(this);
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " --desc=assembler [--dump] --update=<request file>";
    }

    @Override
    protected void execUpdate(GraphStore graphStore) {
        if (this.requestFiles.size() == 0 && this.getPositional().size() == 0) {
            throw new CmdException("Nothing to do");
        }
        for (String filename : this.requestFiles) {
            this.execOneFile(filename, graphStore);
        }
        for (String requestString : super.getPositional()) {
            requestString = this.indirect(requestString);
            this.execOne(requestString, graphStore);
        }
        SystemARQ.sync(graphStore);
        if (this.dump) {
            NQuadsWriter.write(System.out, graphStore);
        }
    }

    private void execOneFile(String filename, GraphStore store) {
        UpdateRequest req = UpdateFactory.read(filename, this.updateSyntax);
        UpdateExecutionFactory.create(req, store).execute();
    }

    private void execOne(String requestString, GraphStore store) {
        UpdateRequest req = UpdateFactory.create(requestString, this.updateSyntax);
        UpdateExecutionFactory.create(req, store).execute();
    }
}

