/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.function;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.function.Function;
import com.hp.hpl.jena.sparql.function.FunctionFactory;
import com.hp.hpl.jena.sparql.function.FunctionFactoryAuto;
import com.hp.hpl.jena.sparql.function.StandardFunctions;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.MappedLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openjena.atlas.logging.Log;

public class FunctionRegistry {
    Map<String, FunctionFactory> registry = new HashMap<String, FunctionFactory>();
    Set<String> attemptedLoads = new HashSet<String>();

    public static synchronized FunctionRegistry standardRegistry() {
        FunctionRegistry reg = new FunctionRegistry();
        StandardFunctions.loadStdDefs(reg);
        return reg;
    }

    public static synchronized FunctionRegistry get() {
        FunctionRegistry reg = FunctionRegistry.get(ARQ.getContext());
        if (reg == null) {
            reg = FunctionRegistry.standardRegistry();
            FunctionRegistry.set(ARQ.getContext(), reg);
        }
        return reg;
    }

    public static FunctionRegistry get(Context context) {
        if (context == null) {
            return null;
        }
        return (FunctionRegistry)context.get(ARQConstants.registryFunctions);
    }

    public static void set(Context context, FunctionRegistry reg) {
        context.set(ARQConstants.registryFunctions, reg);
    }

    public void put(String uri, FunctionFactory f) {
        this.registry.put(uri, f);
    }

    public void put(String uri, Class<?> funcClass) {
        if (!Function.class.isAssignableFrom(funcClass)) {
            Log.warn(this, "Class " + funcClass.getName() + " is not a Function");
            return;
        }
        this.registry.put(uri, new FunctionFactoryAuto(funcClass));
    }

    public FunctionFactory get(String uri) {
        FunctionFactory function = this.registry.get(uri);
        if (function != null) {
            return function;
        }
        if (this.attemptedLoads.contains(uri)) {
            return null;
        }
        Class<?> functionClass = MappedLoader.loadClass(uri, Function.class);
        if (functionClass == null) {
            return null;
        }
        this.put(uri, functionClass);
        this.attemptedLoads.add(uri);
        return this.registry.get(uri);
    }

    public boolean isRegistered(String uri) {
        return this.registry.containsKey(uri);
    }

    public FunctionFactory remove(String uri) {
        return this.registry.remove(uri);
    }

    public Iterator<String> keys() {
        return this.registry.keySet().iterator();
    }
}

