/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;

public class IteratorBlockingQueue<T>
implements Iterator<T> {
    private BlockingQueue<T> queue;
    private boolean finished = false;
    private T slot = null;
    private T endMarker;

    public IteratorBlockingQueue(BlockingQueue<T> queue, T endMarker) {
        this.queue = queue;
        this.endMarker = endMarker;
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.slot != null) {
            return true;
        }
        try {
            this.slot = this.queue.take();
            if (this.slot == this.endMarker) {
                this.finished = true;
                this.slot = null;
                return false;
            }
            return true;
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T item = this.slot;
        this.slot = null;
        return item;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

