/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.lib;

import java.lang.reflect.Array;

public class ArrayUtils {
    private ArrayUtils() {
    }

    public static <T> T[] alloc(Class<T> cls, int n) {
        return (Object[])Array.newInstance(cls, n);
    }

    public static <T> T[] copy(T[] array) {
        return ArrayUtils.copy(array, 0, array.length);
    }

    public static <T> T[] copy(T[] array, int start, int finish) {
        if (array.length <= start) {
            throw new IllegalArgumentException("Zero length array not supported");
        }
        Object[] array2 = (Object[])Array.newInstance(array[start].getClass(), finish - start);
        System.arraycopy(array, start, array2, 0, finish - start);
        return array2;
    }
}

