/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.lang;

import org.openjena.atlas.event.Event;
import org.openjena.atlas.event.EventManager;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.SysRIOT;
import org.openjena.riot.lang.LangEngine;
import org.openjena.riot.lang.LangRIOT;
import org.openjena.riot.system.ParserProfile;
import org.openjena.riot.tokens.Tokenizer;

public abstract class LangBase<X>
extends LangEngine
implements LangRIOT {
    protected final Sink<X> sink;

    protected LangBase(Tokenizer tokens2, ParserProfile profile, Sink<X> sink) {
        super(tokens2, profile);
        this.sink = sink;
    }

    @Override
    public void parse() {
        EventManager.send(this.sink, new Event(SysRIOT.startRead, null));
        this.runParser();
        this.sink.flush();
        EventManager.send(this.sink, new Event(SysRIOT.finishRead, null));
        this.tokens.close();
    }

    protected abstract void runParser();

    @Override
    public ParserProfile getProfile() {
        return this.profile;
    }

    @Override
    public void setProfile(ParserProfile profile) {
        this.profile = profile;
    }
}

