package org.biohackathon.SPARQLBuilder.endpointMetadata;

import java.io.File;
import java.util.ArrayList;

public class MetadataManager {


	MetadataFile[] metadataFiles = null;
	
	public MetadataManager(String metadataDirStr) throws Exception {
		init(metadataDirStr);
	}
	
	
	public void init(String metadataDirStr) throws Exception{
		File metadataDir = new File(metadataDirStr);
		File[] files = null;
		if( metadataDir.exists() ){
			if( metadataDir.isFile()){
				files = new File[]{metadataDir};
			}else{
				if( metadataDir.isDirectory()){
					files = metadataDir.listFiles();
				}else{
					throw new Exception("Inernal File/Directory error: " + metadataDirStr);
				}
			}
		}else{
			throw new Exception("File/Directory not found: " + metadataDirStr);
		}
		ArrayList<MetadataFile> aList = new ArrayList<MetadataFile>();
		for(File file: files){
			MetadataFile metadataFile = null;
			try{
				metadataFile = new MetadataFile(file);
				aList.add(metadataFile);
			}catch(Exception ex){
				// WARNING
				System.out.println("Invalid metadata file: " + file.getAbsolutePath());
			}
		}
		metadataFiles = aList.toArray(new MetadataFile[0]);
	}

	
	
}
