package hozo.sparql;


import hozo.sparql.edit.AllegroEditor;

import com.franz.agraph.jena.AGModel;
import com.franz.agraph.jena.AGQuery;
import com.franz.agraph.jena.AGQueryExecutionFactory;
import com.franz.agraph.jena.AGQueryFactory;
import com.hp.hpl.jena.query.QueryExecution;

/**
 * AllegroAccessorアクセッサ
 * @author kato
 *
 */
public class AllegroAccessor extends PlainSparqlAccessor {
	public AllegroAccessor(EndpointSettings endpoint, SparqlQueryListener queryListener){
		super(endpoint, queryListener);
}

	public AllegroAccessor(EndpointSettings endpoint){
		this(endpoint, null);
	}
	
	/**
	 * queryを叩いて結果を返す
	 * @param query
	 * @return
	 */
	protected QueryExecution makeQuery(String queryString){
		QueryExecution qe = null;
		if (this.getSetting().isEditable()){
			System.out.println("query:["+queryString+"]");
			// TODO 本来ならendpointの実装に応じてfactoryから固有のAccessorを取得する形にすべきだが、
			// 現状は「editable=true」の場合はAllegroGraphに決め打ちしている。
			AllegroEditor ae;
			try {
				ae = new AllegroEditor(this, this.getSetting().getRepositoryURL(), getSetting().getRepository(), getSetting().getUser(), getSetting().getPass());
				AGQuery sparql = AGQueryFactory.create(queryString);
				qe = AGQueryExecutionFactory.create(sparql, (AGModel)ae.getModel());
			} catch (Exception e) {
				e.printStackTrace();
			}
		} else {
			qe = super.makeQuery(queryString);
		}

		return qe;
	}
}
