package hozo.sparql;

import java.util.List;
import java.util.Map;

import com.hp.hpl.jena.rdf.model.RDFNode;

public interface SparqlAccessor {

	/** キーワード検索で、項目すべてを検索対象とする（未実装） */
	public static final int FIND_TARGET_ALL = 0;
	/** キーワード検索で、subjectを検索対象とする */
	public static final int FIND_TARGET_SUBJECT = 1;
	/** キーワード検索で、objectを検索対象とする */
	public static final int FIND_TARGET_OBJECT = 2;
	/** キーワード検索で、ラベルobjectを検索対象とする */
	public static final int FIND_TARGET_SPECIFIC_OBJECT = 3;

	/**
	 * Sparql Queryを直接指定して実行し、結果を返す
	 * @param queryString
	 * @return
	 * @throws Exception
	 */
	public List<Map<String, RDFNode>> executeQuery(String queryString) throws Exception;

	/**
	 * 文字列に該当するSubjectを検索して結果を返す
	 * @param word
	 * @param fullMatch
	 * @param limit
	 * @param offset
	 * @param type
	 * @return
	 * @throws Exception
	 */
	public SparqlResultSet findSubject(String word, boolean fullMatch, Integer limit, Integer offset, int type, String[] propList) throws Exception;

	/**
	 * SubjectにヒットするTripleを検索して結果を返す
	 * @param subject
	 * @return
	 * @throws Exception
	 */
	public List<Map<String, RDFNode>> findTripleFromSubject(String subject) throws Exception;

	/**
	 * propertyの一覧を取得する
	 * @return
	 * @throws Exception
	 */
	public List<Map<String, RDFNode>> findPropertyList() throws Exception;

}
