package hozo.sparql.gui;

import javax.swing.JPanel;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;

import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import hozo.sparql.EndpointSettings;
import hozo.sparql.EndpointSettingsManager;
import hozo.sparql.SparqlResultSet;
import hozo.sparql.SparqlUtil;
import hozo.sparql.plugin.compare.ComparePanel;
import hozo.sparql.plugin.compare.CompareSubjectPanel;

import java.awt.FlowLayout;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Map;

import javax.swing.JRadioButton;

import com.hp.hpl.jena.rdf.model.RDFNode;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class SparqlAccessorForm extends JFrame {

	private static final long serialVersionUID = 1L;
	private JPanel headerPanel = null;
	private JPanel endpointPanel = null;  //  @jve:decl-index=0:visual-constraint="301,8"
	private JComboBox endpointComboBox = null;
	private JTabbedPane searchTypeTabbedPane = null;
	private JPanel crossKeywordSearchPanel = null;
	private JPanel keywordSearchPanel = null;
	private JPanel sparqlSearchPanel = null;
	private JPanel repositoryEditPanel = null;
	private JButton addEndpointButton = null;
	private JPanel footerPanel = null;  //  @jve:decl-index=0:visual-constraint="396,293"
	private JButton saveButton = null;  //  @jve:decl-index=0:visual-constraint="630,305"

	private JPanel radioPanel = null;
	private JRadioButton tsvRadioButton = null;
	private JRadioButton csvRadioButton = null;
	private JRadioButton xlsxRadioButton = null;

	private List<Map<String, RDFNode>> results;
	private JMenuBar mainMenuBar = null;
	private JMenu fileMenu = null;
	private JMenu optionMenu = null;
	private JMenuItem exitFileMenuItem = null;
	private JMenuItem optionMenuItem = null;
	private JMenuItem saveSettingFileMenuItem = null;
	private JMenuItem compareMenuItem = null;
	private JMenuItem compareSubjectMenuItem = null;

	private String settingFile = "settings.xml";
	private JSplitPane mainPanel = null;
	private JPanel sparqlLogPanel = null;
	private JScrollPane sparqlLogScrollPane = null;
	private JTextArea sparqlLogTextArea = null;
	private JMenu helpMenu = null;
	private JMenuItem menuVersionItem = null;


	/**
	 * This is the default constructor
	 */
	public SparqlAccessorForm() {
		super();
		loadSetting();
		initialize();
	}

	/**
	 * This method initializes this
	 *
	 * @return void
	 */
	private void initialize() {
//		this.setSize(370, 251);
        this.setJMenuBar(getMainMenuBar());
        this.addWindowListener(new WindowAdapter() {
        	@Override
        	public void windowClosing(WindowEvent e) {
        		if (EndpointSettingsManager.instance.isChanged()){
        			int option = JOptionPane.showConfirmDialog(getContentPane(), "エンドポイント設定が変更されています。保存しますか？", "", JOptionPane.YES_NO_OPTION, JOptionPane.INFORMATION_MESSAGE);
        			if (option == JOptionPane.YES_OPTION){
        				saveSetting(false);
        			}
        		}
        	}
        });
        Container compo = this.getContentPane();
		compo.setLayout(new BorderLayout());
		compo.add(getHeaderPanel(), BorderLayout.NORTH);
		compo.add(getFooterPanel(), BorderLayout.SOUTH);
		compo.add(getMainPanel(), BorderLayout.CENTER);
	}

	/**
	 * This method initializes headerPanel
	 *
	 * @return javax.swing.JPanel
	 */
	private JPanel getHeaderPanel() {
		if (headerPanel == null) {
			headerPanel = new JPanel();
			headerPanel.setLayout(new BorderLayout());
			headerPanel.add(getEndpointPanel(),  BorderLayout.NORTH);

		}
		return headerPanel;
	}

	/**
	 * This method initializes endpointPanel
	 *
	 * @return javax.swing.JPanel
	 */
	private JPanel getEndpointPanel() {
		if (endpointPanel == null) {
			endpointPanel = new JPanel();
			endpointPanel.setLayout(new BorderLayout());
			endpointPanel.add(getEndpointComboBox(), BorderLayout.CENTER);
			endpointPanel.add(getAddEndpointButton(), BorderLayout.EAST);
		}
		return endpointPanel;
	}

	/**
	 * This method initializes endpointComboBox
	 *
	 * @return javax.swing.JComboBox
	 */
	private JComboBox getEndpointComboBox() {
		if (endpointComboBox == null) {
//			String[] endpoints = {"http://ja.dbpedia.org/sparql", "http://dbpedia.org/sparql", "http://www.wikipediaontology.org/query/", "http://hozoviewer.ei.sanken.osaka-u.ac.jp/endpoint/dbpedia", "http://lod.ac/species/sparql", "http://lod.ac/sparql"};
			String[] endpoints = { "http://hozoviewer.ei.sanken.osaka-u.ac.jp/endpoint/dbpedia", "http://lod.ac/species/sparql", "http://lod.ac/sparql"};
			for (String ep : endpoints){
				EndpointSettingsManager.instance.getSetting(ep);
			}
			endpointComboBox = new JComboBox(endpoints);
			endpointComboBox.setEditable(true);
			endpointComboBox.addActionListener(new ActionListener() {

				@Override
				public void actionPerformed(ActionEvent arg0) {
					setEditable();
				}
			});
		}
		return endpointComboBox;
	}

	public String getCurrentEndPoint(){
		return (String)getEndpointComboBox().getSelectedItem();
	}

	/**
	 * This method initializes searchTypeTabbedPane
	 *
	 * @return javax.swing.JTabbedPane
	 */
	private JTabbedPane getSearchTypeTabbedPane() {
		if (searchTypeTabbedPane == null) {
			searchTypeTabbedPane = new JTabbedPane();
			searchTypeTabbedPane.addTab("Keyword Search", null, getKeywordSearchPanel(), null);
			searchTypeTabbedPane.addTab("Cross Search", null, getCrossKeywordSearchPanel(), null);
			searchTypeTabbedPane.addTab("SPARQL", null, getSparqlSearchPanel(), null);
			//searchTypeTabbedPane.addTab("SPARQL Builder", null, getSparqlBuilderPanel(), null);
			searchTypeTabbedPane.addTab("Edit", null, getRepositoryEditPanel(), null);
		}
		return searchTypeTabbedPane;
	}

	private void setEditable(){
		EndpointSettings setting = EndpointSettingsManager.instance.getSetting(this.getCurrentEndPoint());

		getSearchTypeTabbedPane().setEnabledAt(getSearchTypeTabbedPane().indexOfComponent(getRepositoryEditPanel()), setting.isEditable());
	}

	/**
	 * This method initializes keywordSearchPanel
	 *
	 * @return javax.swing.JPanel
	 */
	private JPanel getKeywordSearchPanel() {
		if (keywordSearchPanel == null) {
			keywordSearchPanel = new KeywordSearchPanel(this);
		}
		return keywordSearchPanel;
	}

	/**
	 * This method initializes crossKeywordSearchPanel
	 *
	 * @return javax.swing.JPanel
	 */
	private JPanel getCrossKeywordSearchPanel() {
		if (crossKeywordSearchPanel == null) {
			crossKeywordSearchPanel = new CrossKeywordSearchPanel(this);
		}
		return crossKeywordSearchPanel;
	}

	/**
	 * This method initializes sparqlSearchPanel
	 *
	 * @return javax.swing.JPanel
	 */
	private JPanel getSparqlSearchPanel() {
		if (sparqlSearchPanel == null) {
			sparqlSearchPanel = new SparqlSearchPanel(this);
		}
		return sparqlSearchPanel;
	}
	
//	private JPanel getSparqlBuilderPanel(){
//		return new SparqlBuilderPanel(this);
//	}
	
	private JPanel getRepositoryEditPanel(){
		if (repositoryEditPanel == null){
			repositoryEditPanel = new RepositoryKeywordSearchEditPanel(this);
		}
		return repositoryEditPanel;
	}

	/**
	 * This method initializes addEndpointButton
	 *
	 * @return javax.swing.JButton
	 */
	private JButton getAddEndpointButton() {
		if (addEndpointButton == null) {
			addEndpointButton = new JButton("New");
			addEndpointButton.addActionListener(new ActionListener() {

				@Override
				public void actionPerformed(ActionEvent e) {
					boolean contains = false;
					for (int i=0; i<getEndpointComboBox().getItemCount(); i++){
						Object item = getEndpointComboBox().getItemAt(i);
						if (item.equals(getCurrentEndPoint())){
							contains = true;
							break;
						}
					}
					if (!contains){
						EndpointSettingsManager.instance.getSetting(getCurrentEndPoint());
						getEndpointComboBox().addItem(getCurrentEndPoint());
					}
				}
			});
		}
		return addEndpointButton;
	}

	/**
	 * This method initializes footerPanel
	 *
	 * @return javax.swing.JPanel
	 */
	private JPanel getFooterPanel() {
		if (footerPanel == null) {
			footerPanel = new JPanel();
			footerPanel.setLayout(new BorderLayout());
			footerPanel.add(getSaveButton(), BorderLayout.EAST);
			footerPanel.add(getRadioPanel(), BorderLayout.CENTER);
		}
		return footerPanel;
	}

	/**
	 * This method initializes saveButton
	 *
	 * @return javax.swing.JButton
	 */
	private JButton getSaveButton() {
		if (saveButton == null) {
			saveButton = new JButton("Save Result");
			saveButton.addActionListener(new ActionListener() {

				@Override
				public void actionPerformed(ActionEvent arg0) {
					save();
				}
			});
			saveButton.setEnabled(false);
		}
		return saveButton;
	}

	private int saveSetting(boolean needConfirm){
		// 出力先決定

		// 確認ダイアログ
		if (needConfirm){
			int option = JOptionPane.showConfirmDialog(getContentPane(), "エンドポイント設定を保存します", "", JOptionPane.YES_NO_OPTION, JOptionPane.INFORMATION_MESSAGE);
			if (option != JOptionPane.YES_OPTION){
				return JFileChooser.ABORT;
			}
		}


		File file = new File(settingFile);
		try {
			EndpointSettings.outputXML(new FileOutputStream(file), EndpointSettingsManager.instance.getSettings());
			EndpointSettingsManager.instance.resetChanged();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			return JFileChooser.ERROR;
		}
		return 0;

		/*
		// ファイル選択ダイアログを呼び出す
		JFileChooser fileChooser = new JFileChooser();
		fileChooser.setDialogType(JFileChooser.SAVE_DIALOG);

		// ファイル選択結果取得
		int result = fileChooser.showOpenDialog(this);
		File file = fileChooser.getSelectedFile();
		if (result == JFileChooser.CANCEL_OPTION || file == null) {
			// キャンセル押下、または、ファイル選択なしのため何もしない
			return JFileChooser.ABORT;
		}

		try {
			EndpointSettings.outputXML(new FileOutputStream(file), EndpointSettingsManager.instance.getSettings());
			return 0;
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			return JFileChooser.ERROR;
		}
		*/

	}

	private int loadSetting(){
		File file = new File(settingFile);
		try {
			EndpointSettings[] settings = EndpointSettings.inputXML(new FileInputStream(file));
			if (settings != null){
				EndpointSettingsManager.instance.setSettings(settings);
				EndpointSettingsManager.instance.resetChanged();

				for (EndpointSettings setting : settings){
					DefaultComboBoxModel model = (DefaultComboBoxModel)getEndpointComboBox().getModel();
					boolean exists = false;
					for (int i=0; i<model.getSize(); i++){
						String ep = (String)model.getElementAt(i);
						if (setting.getEndpoint().equals(ep)){
							exists = true;
							break;
						}
					}
					if (!exists){
						model.addElement(setting.getEndpoint());
					}
				}

				return 0;
			}
		} catch (FileNotFoundException e) {
			saveSetting(false);
			e.printStackTrace();
			return JFileChooser.ERROR;
		} finally {
			setEditable();
		}
		return JFileChooser.ERROR;

		/*
		// ファイル選択ダイアログを呼び出す
		JFileChooser fileChooser = new JFileChooser();
		fileChooser.setDialogType(JFileChooser.OPEN_DIALOG);

		// ファイル選択結果取得
		int result = fileChooser.showOpenDialog(this);
		File file = fileChooser.getSelectedFile();
		if (result == JFileChooser.CANCEL_OPTION || file == null) {
			// キャンセル押下、または、ファイル選択なしのため何もしない
			return JFileChooser.ABORT;
		}

		try {
			EndpointSettings[] settings = EndpointSettings.inputXML(new FileInputStream(file));
			if (settings != null){
				EndpointSettingsManager.instance.setSettings(settings);
				return 0;
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			return JFileChooser.ERROR;
		}
		return JFileChooser.ERROR;
		*/

	}


	private void save(){
		// 出力先決定
		// ファイル選択ダイアログを呼び出す
		JFileChooser fileChooser = new JFileChooser();
		fileChooser.setDialogType(JFileChooser.SAVE_DIALOG);

		// ファイル選択結果取得
		int result = fileChooser.showOpenDialog(this);
		File file = fileChooser.getSelectedFile();
		if (result == JFileChooser.CANCEL_OPTION || file == null) {
			// キャンセル押下、または、ファイル選択なしのため何もしない
			return;
		}

		try {
			SparqlUtil.saveResult(results, getSaveType(), file);
		} catch(Exception e){
			e.printStackTrace();
		}
	}

	private int getSaveType(){
		if (getTsvRadioButton().isSelected()){
			return SparqlUtil.OUTPUT_TYPE_TSV;
		}
		if (getCsvRadioButton().isSelected()){
			return SparqlUtil.OUTPUT_TYPE_CSV;
		}
		if (getXlsxRadioButton().isSelected()){
			return SparqlUtil.OUTPUT_TYPE_XLS;
		}

		// ここにくることはない
		return SparqlUtil.OUTPUT_TYPE_TSV;
	}

	void setProcessing(boolean isProcessing){
		getEndpointComboBox().setEnabled(!isProcessing);
		getAddEndpointButton().setEnabled(!isProcessing);
		getSearchTypeTabbedPane().setEnabled(!isProcessing);
		getSaveButton().setEnabled(false);
	}

	void setResults(SparqlResultSet set){
		List<Map<String, RDFNode>> results = set.getDefaultResult();
		boolean saveable = false;
		if (results != null && results.size() > 0){
			saveable = true;
		}
		getSaveButton().setEnabled(saveable);

		this.results = results;

	}

	/**
	 * This method initializes radioPanel
	 *
	 * @return javax.swing.JPanel
	 */
	private JPanel getRadioPanel() {
		if (radioPanel == null) {
			radioPanel = new JPanel();
			radioPanel.setLayout(new FlowLayout());
			radioPanel.add(getTsvRadioButton(), null);
			radioPanel.add(getCsvRadioButton(), null);
			radioPanel.add(getXlsxRadioButton(), null);
			ButtonGroup bg = new ButtonGroup();
			bg.add(getTsvRadioButton());
			bg.add(getCsvRadioButton());
			bg.add(getXlsxRadioButton());
			getTsvRadioButton().setSelected(true);
		}
		return radioPanel;
	}

	/**
	 * This method initializes tsvRadioButton
	 *
	 * @return javax.swing.JRadioButton
	 */
	private JRadioButton getTsvRadioButton() {
		if (tsvRadioButton == null) {
			tsvRadioButton = new JRadioButton("TSV");
		}
		return tsvRadioButton;
	}

	/**
	 * This method initializes csvRadioButton
	 *
	 * @return javax.swing.JRadioButton
	 */
	private JRadioButton getCsvRadioButton() {
		if (csvRadioButton == null) {
			csvRadioButton = new JRadioButton("CSV");
		}
		return csvRadioButton;
	}

	/**
	 * This method initializes xlsxRadioButton
	 *
	 * @return javax.swing.JRadioButton
	 */
	private JRadioButton getXlsxRadioButton() {
		if (xlsxRadioButton == null) {
			xlsxRadioButton = new JRadioButton("XLSX");
			xlsxRadioButton.setEnabled(false);
		}
		return xlsxRadioButton;
	}

	/**
	 * This method initializes mainMenuBar
	 *
	 * @return javax.swing.JMenuBar
	 */
	private JMenuBar getMainMenuBar() {
		if (mainMenuBar == null) {
			mainMenuBar = new JMenuBar();
			mainMenuBar.add(getFileMenu());
			mainMenuBar.add(getOptionMenu());
			mainMenuBar.add(getHelpMenu());
		}
		return mainMenuBar;
	}

	/**
	 * This method initializes fileMenu
	 *
	 * @return javax.swing.JMenu
	 */
	private JMenu getFileMenu() {
		if (fileMenu == null) {
			fileMenu = new JMenu("File");
			fileMenu.add(getSaveSettingFileMenuItem());
//			fileMenu.add(getLoadSettingMenuItem());
			fileMenu.add(getExitFileMenuItem());
		}
		return fileMenu;
	}

	/**
	 * This method initializes optionMenu
	 *
	 * @return javax.swing.JMenu
	 */
	private JMenu getOptionMenu() {
		if (optionMenu == null) {
			optionMenu = new JMenu("Option");
			optionMenu.add(getOptionMenuItem());

			// Javaはplugin化するのが面倒なのでここにベタで書く
			optionMenu.add(getCompareMenuItem());
			optionMenu.add(getCompareSubjectMenuItem());
		}
		return optionMenu;
	}

	/**
	 * This method initializes exitFileMenuItem
	 *
	 * @return javax.swing.JMenuItem
	 */
	private JMenuItem getExitFileMenuItem() {
		if (exitFileMenuItem == null) {
			exitFileMenuItem = new JMenuItem("Exit");
			exitFileMenuItem.addActionListener(new ActionListener() {

				@Override
				public void actionPerformed(ActionEvent arg0) {
					int option = JOptionPane.showConfirmDialog(getContentPane(), "終了しますか？", "", JOptionPane.YES_NO_OPTION, JOptionPane.INFORMATION_MESSAGE);
					if (option == JOptionPane.YES_OPTION){
						System.exit(0);
					}

				}
			});
		}
		return exitFileMenuItem;
	}

	private JMenuItem getCompareMenuItem() {
		if (compareMenuItem == null) {
			compareMenuItem = new JMenuItem("Compare");
			compareMenuItem.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
//					openSettingDialog();
					JFrame frame = new JFrame();
					frame.setContentPane(new ComparePanel(frame));
					frame.setSize(750, 500);

					frame.setVisible(true);
				}
			});
		}
		return compareMenuItem;
	}

	private JMenuItem getCompareSubjectMenuItem() {
		if (compareSubjectMenuItem == null) {
			compareSubjectMenuItem = new JMenuItem("Compare Subjects");
			compareSubjectMenuItem.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
//					openSettingDialog();
					JFrame frame = new JFrame();
					frame.setContentPane(new CompareSubjectPanel(frame));
					frame.setSize(750, 500);

					frame.setVisible(true);
				}
			});
		}
		return compareSubjectMenuItem;
	}


	/**
	 * This method initializes optionMenuItem
	 *
	 * @return javax.swing.JMenuItem
	 */
	private JMenuItem getOptionMenuItem() {
		if (optionMenuItem == null) {
			optionMenuItem = new JMenuItem("Option Setting");
			optionMenuItem.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent arg0) {
					openSettingDialog();
				}
			});
		}
		return optionMenuItem;
	}

	private void openSettingDialog(){
		EndpointSettings setting = EndpointSettingsManager.instance.getSetting(this.getCurrentEndPoint());
		OptionDialog od = new OptionDialog(this, setting);

		od.setModal(true);
		od.setVisible(true);
		if (od.isOk()){
			setting.setUseCustomParam(od.isUseCustom());
			setting.setQueryKey(od.getQueryKey());
			setting.setOption(od.getOption());
			setting.setNamespaces(od.getNamespaces());
			setting.setEncoding(od.getEndoding());
			setting.setResultType(od.getResultType());

			setting.setEditable(od.isEditable());
			setting.setRepositoryURL(od.getRepositoryURL());
			setting.setRepository(od.getRepository());
			setting.setUser(od.getUser());
			setting.setPass(od.getPassword());

			setEditable();
		}
	}

	/**
	 * This method initializes saveSettingFileMenuItem
	 *
	 * @return javax.swing.JMenuItem
	 */
	private JMenuItem getSaveSettingFileMenuItem() {
		if (saveSettingFileMenuItem == null) {
			saveSettingFileMenuItem = new JMenuItem("Save Settings");
			saveSettingFileMenuItem.addActionListener(new ActionListener() {

				@Override
				public void actionPerformed(ActionEvent arg0) {
					int ret = saveSetting(true);
					if (ret == JFileChooser.ABORT){
						// 中断
					} else if (ret == JFileChooser.ERROR){
						// エラー
					} else {
						// 成功
					}
				}
			});
		}
		return saveSettingFileMenuItem;
	}

	/**
	 * This method initializes loadSettingMenuItem
	 *
	 * @return javax.swing.JMenuItem
	 *//*
	private JMenuItem getLoadSettingMenuItem() {
		if (loadSettingMenuItem == null) {
			loadSettingMenuItem = new JMenuItem("Load Settings");
			loadSettingMenuItem.addActionListener(new ActionListener() {

				@Override
				public void actionPerformed(ActionEvent e) {
					int ret = loadSetting();
					if (ret == JFileChooser.ABORT){
						// 中断
					} else if (ret == JFileChooser.ERROR){
						// エラー
					} else {
						// 成功
					}
				}
			});
		}
		return loadSettingMenuItem;
	}*/

	/**
	 * This method initializes mainPanel
	 *
	 * @return javax.swing.JPanel
	 */
	private JSplitPane getMainPanel() {
		if (mainPanel == null) {
			mainPanel = new JSplitPane(JSplitPane.VERTICAL_SPLIT, getSearchTypeTabbedPane(), getSparqlLogPanel());
			mainPanel.setDividerLocation(400);
		}
		return mainPanel;
	}

	/**
	 * This method initializes sparqlLogPanel
	 *
	 * @return javax.swing.JPanel
	 */
	private JPanel getSparqlLogPanel() {
		if (sparqlLogPanel == null) {
			sparqlLogPanel = new JPanel();
			sparqlLogPanel.setLayout(new BorderLayout());
			sparqlLogPanel.add(getSparqlLogScrollPane(), BorderLayout.CENTER);
		}
		return sparqlLogPanel;
	}

	/**
	 * This method initializes sparqlLogScrollPane
	 *
	 * @return javax.swing.JScrollPane
	 */
	private JScrollPane getSparqlLogScrollPane() {
		if (sparqlLogScrollPane == null) {
			sparqlLogScrollPane = new JScrollPane(getSparqlLogTextArea(), JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
			sparqlLogScrollPane.setPreferredSize(new Dimension(200, 300));
		}
		return sparqlLogScrollPane;
	}

	/**
	 * This method initializes sparqlLogTextArea
	 *
	 * @return javax.swing.JTextArea
	 */
	private JTextArea getSparqlLogTextArea() {
		if (sparqlLogTextArea == null) {
			sparqlLogTextArea = new JTextArea();
			sparqlLogTextArea.setEditable(false);
			sparqlLogTextArea.getDocument().addDocumentListener(new DocumentListener() {

				@Override
				public void removeUpdate(DocumentEvent arg0) {
				}

				@Override
				public void changedUpdate(DocumentEvent arg0) {
				}
				@Override
				public void insertUpdate(DocumentEvent e) {
					final Document doc = sparqlLogTextArea.getDocument();
					final Element root = doc.getDefaultRootElement();
					if(root.getElementCount() <= 100){ // TODO 100はベタ書き
						return;
					}
					EventQueue.invokeLater(new Runnable() {
						@Override
						public void run() {
							removeLines(doc, root);
						}
					});
					sparqlLogTextArea.setCaretPosition(doc.getLength());
				}
				private void removeLines(Document doc, Element root) {
					Element fl = root.getElement(0);
					try{
						doc.remove(0, fl.getEndOffset());
					}catch(BadLocationException ble) {
						System.out.println(ble);
					}
				}
			});
		}
		return sparqlLogTextArea;
	}

	void addLogText(String log){
		String[] logs = log.split("\n");
		for (String l : logs){
			sparqlLogTextArea.append((sparqlLogTextArea.getDocument().getLength() > 0) ? "\n" + l : l);
		}
		sparqlLogTextArea.setCaretPosition(sparqlLogTextArea.getDocument().getLength());
	}

	/**
	 * This method initializes helpMenu
	 *
	 * @return javax.swing.JMenu
	 */
	private JMenu getHelpMenu() {
		if (helpMenu == null) {
			helpMenu = new JMenu("Help");
			helpMenu.add(getMenuVersionItem());
		}
		return helpMenu;
	}

	/**
	 * This method initializes menuVersionItem
	 *
	 * @return javax.swing.JMenuItem
	 */
	private JMenuItem getMenuVersionItem() {
		if (menuVersionItem == null) {
			menuVersionItem = new JMenuItem("Version");
			menuVersionItem.addActionListener(new ActionListener() {

				@Override
				public void actionPerformed(ActionEvent e) {
					awakeVersionDialog();
				}
			});
		}
		return menuVersionItem;
	}

	private void awakeVersionDialog(){
		// TODO
		VersionDialog vd = new VersionDialog(this);

		vd.setVisible(true);
	}

	public static void main(String args[]){
		JFrame frame = new SparqlAccessorForm();
		frame.setSize(900, 800);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setVisible(true);
	}
}  //  @jve:decl-index=0:visual-constraint="10,10"
