package hozo.sparql.util;

import java.util.ArrayList;
import java.util.List;

public class StringUtil {

	/**
	 * 文字列を読点で区切ってhtml文字列に変換する
	 * @param str
	 * @return
	 */
	public static String makeHtmlString(String str){
		return makeHtmlString(splitString(str));
	}

	/**
	 * 文字列をhtml文字列に変換する
	 * @param strs
	 * @return
	 */
	public static String makeHtmlString(String[] strs){
		StringBuilder sb = new StringBuilder();
		sb.append("<html>");
		for (int i=0; i<strs.length; i++){
			String str = strs[i];
			sb.append(str);
			if (i != strs.length-1){
				sb.append("<br>");
			}
		}
		sb.append("</html>");
		return sb.toString();
	}

	/**
	 * 文字列を読点で分割する
	 * @param str
	 * @return
	 */
	public static String[] splitString(String str){
		String[] ret;
		ret = splitString(str, "。");
		ret = splitString(ret, "\\. ");
		return ret;
	}

	private static String[] splitString(String str, String sep){
		return splitString(new String[]{str}, sep);
	}

	private static String[] splitString(String[] strs, String sep){
		List<String> ret = new ArrayList<String>();
		String sepTmp = sep.replace("\\", "");
		for (String str : strs){
			boolean endSep = str.endsWith(sepTmp);
			String[] tmps = str.split(sep);
			for (int i=0; i<tmps.length; i++){
				String tmp = tmps[i];
				if (i != tmps.length-1 || endSep){
					ret.add(tmp + sepTmp);
				} else {
					ret.add(tmp);
				}
			}
		}
		return ret.toArray(new String[0]);
	}

	/**
	 * 指定した文字列一覧の中から、指定した文字を含むものだけを返す
	 * @param list
	 * @param word
	 * @return
	 */
	public static List<String> getPartHitString(List<String> list, String word){
		List<String> ret = new ArrayList<String>();
		if (list == null){
			return ret;
		}
		for (String item : list){
			if (item.contains(word)){
				ret.add(item);
			}
		}
		return ret;
	}
}
