package org.biohackathon.SPARQLBuilder.endpointMetadata;

import java.io.File;
import java.util.HashMap;
import java.util.Set;

public class MetadataManager {

	HashMap<String,MetadataFile> metadataTable = null;
	
	
	public static void main(String[] args) throws Exception{
		String dirStr = "c:\\temp\\crawl";
		MetadataManager manager = new MetadataManager(dirStr);
		String[] uris = manager.getURIList();
		for(String uri: uris){
			System.out.println(uri);
			MetadataFile mFile = manager.getMetadataFile(uri);
			System.out.println(mFile.getStartDateTime().getTime().toString());
			System.out.println(mFile.getEndDateTime().getTime().toString());
		}
	}	

	public MetadataFile[] getMetadataFiles(){
		return metadataTable.values().toArray(new MetadataFile[0]);
	}
	public MetadataFile getMetadataFile(String uri){
		return metadataTable.get(uri);
	}

	public String[] getURIList(){
		Set<String> keySet = metadataTable.keySet();
		return keySet.toArray(new String[0]);
	}
	
	
	public MetadataManager(String metadataDirStr) throws Exception {
		init(metadataDirStr);
	}
	
	
	public void init(String metadataDirStr) throws Exception{
		metadataTable = new HashMap<String,MetadataFile>();
		File metadataDir = new File(metadataDirStr);
		File[] files = null;
		if( metadataDir.exists() ){
			if( metadataDir.isFile()){
				files = new File[]{metadataDir};
			}else{
				if( metadataDir.isDirectory()){
					files = metadataDir.listFiles();
				}else{
					throw new Exception("Inernal File/Directory error: " + metadataDirStr);
				}
			}
		}else{
			throw new Exception("File/Directory not found: " + metadataDirStr);
		}
		for(File file: files){
			MetadataFile metadataFile = null;
			try{
				metadataFile = new MetadataFile(file);
				String uri = metadataFile.getEndpointURI();
				if( uri != null ){
					metadataTable.put(uri, metadataFile);
				}
			}catch(Exception ex){
				// WARNING
				System.out.println("Invalid metadata file: " + file.getAbsolutePath());
				ex.printStackTrace();
			}
		}
	}

	
	
}
