package hozo.sparql;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.hp.hpl.jena.rdf.model.RDFNode;

public class SparqlUtil {

	/** TSV形式出力 */
	public static final int OUTPUT_TYPE_TSV = 0;
	
	public static final int OUTPUT_TYPE_CSV = 1;

	public static final int OUTPUT_TYPE_XLS = 2;

	
	private static HashMap<Integer, String> separatorMap;

	static {
		separatorMap = new HashMap<Integer, String>();
		separatorMap.put(SparqlUtil.OUTPUT_TYPE_TSV, "\t");
		separatorMap.put(SparqlUtil.OUTPUT_TYPE_CSV, ",");

	}
	
	/**
	 * 指定したストリームに結果を文字列として出力する
	 * @param results
	 * @param type
	 * @param stream
	 * @return
	 */
	public static boolean saveResult(List<Map<String, RDFNode>> results, int type, OutputStream stream){
		/**
		 * typeによってresult formatを変えて再POSTすることも考えられるが、普遍性がないので保留とし、
		 * 変換は自前で実装する。
		 */
		if (type == SparqlUtil.OUTPUT_TYPE_TSV || type == SparqlUtil.OUTPUT_TYPE_CSV){
			String separator = separatorMap.get(type);
			if (separator == null){
				return false;
			}
			SeparatedValuesExporter expo = new SeparatedValuesExporter(separator, results);
			try {
				expo.export(stream);
				return true;
			} catch (IOException e) {
				e.printStackTrace();
			}
			return true;
		}
		
		return false;
	}

	public static boolean saveResult(List<Map<String, RDFNode>> results,  int type, File file) throws FileNotFoundException{
		return saveResult(results, type, new FileOutputStream(file));
	}
}
