package hozo.sparql.gui;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;

import javax.swing.JPanel;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Dimension;
import javax.swing.JTextField;
import java.awt.GridBagConstraints;
import javax.swing.JLabel;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;

public class TripleEditDialog extends JDialog {

	/**
	 * 
	 */
	private static final long serialVersionUID = -8353265680791711240L;
	private RDFNode s;
	private RDFNode p;
	private RDFNode o;
	private Model model;
	private JPanel mainPanel = null;
	private JTextField subjectTextField = null;
	private JTextField propertyTextField = null;
	private JTextField objectTextField = null;
	private JLabel subjectLabel = null;
	private JLabel propertyLabel = null;
	private JLabel objectLabel = null;
	private JPanel buttonPanel = null;
	private JButton okButton = null;
	private JButton cancelButton = null;
	
	public boolean ok = false;
	
	public TripleEditDialog(RDFNode s, RDFNode p, RDFNode o, Model model){
		this.s = s;
		this.p = p;
		this.o = o;
		this.model = model;
		initialize();

		this.getSubjectTextField().setText(s.toString());
		this.getPropertyTextField().setText(p.toString());
		if (o != null){
			this.getObjectTextField().setText(o.toString());
		}
		this.setModal(true);
	}
	
	public RDFNode getSubject(){
		if (s == null && this.getSubjectTextField().getText().isEmpty()){
			return null;
		}

		if (s != null && s.toString().equals(this.getSubjectTextField().getText())){
			return s;
		}
		
		return getRDFNodeFromString(this.getSubjectTextField().getText());
	}

	public RDFNode getProperty(){
		if (p == null && this.getPropertyTextField().getText().isEmpty()){
			return null;
		}

		if (p != null && p.toString().equals(this.getPropertyTextField().getText())){
			return p;
		}
		
		return getRDFNodeFromString(this.getPropertyTextField().getText());
	}

	public RDFNode getObject(){
		if (o == null && this.getObjectTextField().getText().isEmpty()){
			return null;
		}
		
		if (o != null && o.toString().equals(this.getObjectTextField().getText())){
			return o;
		}
		
		return getRDFNodeFromString(this.getObjectTextField().getText());
	}

	private RDFNode getRDFNodeFromString(String str){
		if (str.startsWith("http://")){
			ResourceImpl ri = new ResourceImpl(str);
			return ri;
		}
		
		return model.createLiteral(str);
		
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
		this.setSize(new Dimension(999, 157));
		this.setContentPane(getMainPanel());
	}
	/**
	 * This method initializes mainPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getMainPanel() {
		if (mainPanel == null) {
			GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
			gridBagConstraints6.gridx = 2;
			gridBagConstraints6.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints6.gridy = 2;
			GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
			gridBagConstraints5.gridx = 2;
			gridBagConstraints5.gridy = 0;
			objectLabel = new JLabel();
			objectLabel.setText("Object");
			GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
			gridBagConstraints4.gridx = 1;
			gridBagConstraints4.gridy = 0;
			propertyLabel = new JLabel();
			propertyLabel.setText("Property");
			GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
			gridBagConstraints3.gridx = 0;
			gridBagConstraints3.gridy = 0;
			subjectLabel = new JLabel();
			subjectLabel.setText("Subject");
			GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
			gridBagConstraints2.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints2.gridy = 1;
			gridBagConstraints2.weightx = 1.0;
			gridBagConstraints2.insets = new Insets(0, 10, 0, 10);
			gridBagConstraints2.gridx = 2;
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints1.gridy = 1;
			gridBagConstraints1.weightx = 1.0;
			gridBagConstraints1.insets = new Insets(0, 10, 0, 10);
			gridBagConstraints1.gridx = 1;
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints.gridy = 1;
			gridBagConstraints.weightx = 1.0;
			gridBagConstraints.insets = new Insets(0, 10, 0, 10);
			gridBagConstraints.gridx = 0;
			mainPanel = new JPanel();
			mainPanel.setLayout(new GridBagLayout());
			mainPanel.add(getSubjectTextField(), gridBagConstraints);
			mainPanel.add(getPropertyTextField(), gridBagConstraints1);
			mainPanel.add(getObjectTextField(), gridBagConstraints2);
			mainPanel.add(subjectLabel, gridBagConstraints3);
			mainPanel.add(propertyLabel, gridBagConstraints4);
			mainPanel.add(objectLabel, gridBagConstraints5);
			mainPanel.add(getButtonPanel(), gridBagConstraints6);
		}
		return mainPanel;
	}

	/**
	 * This method initializes subjectTextField	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getSubjectTextField() {
		if (subjectTextField == null) {
			subjectTextField = new JTextField();
			subjectTextField.setEditable(false);
		}
		return subjectTextField;
	}

	/**
	 * This method initializes propertyTextField	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getPropertyTextField() {
		if (propertyTextField == null) {
			propertyTextField = new JTextField();
		}
		return propertyTextField;
	}

	/**
	 * This method initializes objectTextField	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getObjectTextField() {
		if (objectTextField == null) {
			objectTextField = new JTextField();
		}
		return objectTextField;
	}

	/**
	 * This method initializes buttonPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getButtonPanel() {
		if (buttonPanel == null) {
			buttonPanel = new JPanel();
			buttonPanel.setLayout(new BoxLayout(buttonPanel,  BoxLayout.LINE_AXIS));
			buttonPanel.setAlignmentX(Component.RIGHT_ALIGNMENT);
			buttonPanel.add(getOkButton());
			buttonPanel.add(Box.createRigidArea(new Dimension(10, 10)));
			buttonPanel.add(getCancelButton());
		}
		return buttonPanel;
	}

	/**
	 * This method initializes okButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getOkButton() {
		if (okButton == null) {
			okButton = new JButton("OK");
			okButton.addActionListener(new ActionListener() {
				
				@Override
				public void actionPerformed(ActionEvent arg0) {
					ok = true;
					setVisible(false);
				}
			});
		}
		return okButton;
	}

	/**
	 * This method initializes cancelButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getCancelButton() {
		if (cancelButton == null) {
			cancelButton = new JButton("CANCEL");
			cancelButton.addActionListener(new ActionListener() {
				
				@Override
				public void actionPerformed(ActionEvent e) {
					ok = false;
					setVisible(false);
				}
			});
		}
		return cancelButton;
	}
	
}  //  @jve:decl-index=0:visual-constraint="86,101"
