package hozo.maptool;


import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

import javax.swing.JOptionPane;

import hozo.sparql.gui.SparqlBuilderPanel;

import org.biohackathon.SPARQLBuilder.OWL.ClassLink;
import org.biohackathon.SPARQLBuilder.OWL.Direction;
import org.biohackathon.SPARQLBuilder.OWL.Path;

/***　2008/10/18　#kozaki
　MAP生成のために，法造やOWLのAPIから，マップ用のデータを作成するための
　メソッド類をこのクラスにまとめる．

***/
public class MapFactory implements Runnable{

	ExtendBP exbp;
	public ExtendFrame exbpframe;
	Vector focal_points;//最初に選択したNode(など)を保持する
	boolean isSubLung;
	static boolean isGrayView=false;
	Vector<String> checked_nodes;
	boolean search_shortest=true;//サーチパスで最短パスを検索する
	int serch_depth = 10;//サーチパスで最短パスを検索する深さ（最短パス検索をしないときは必ず使う）
	Vector<ExbpNodeTemp> temp_nodes;
	
	SparqlBuilderPanel spBuilder;
 	
	public static void main (String[] args) {
		MapFactory map = new MapFactory();
		//map.loadPathList(map.getDummyPathList());
	}
	
	public List<Path> getDummyPathList(){
		ArrayList pathlist = new ArrayList();
//		ArrayList class_link_list = new ArrayList<ClassLink>() {{
//			add(new ClassLink("propertyURI", "linkedClassURI2", Direction.forward));
//			add(new ClassLink("propertyURI2", "linkedClassURI3", Direction.forward));
//			add(new ClassLink("propertyURI3", "linkedClassURI4", Direction.forward));
//		    }};
//		Path path = new Path("StartClass1", class_link_list);
//		pathlist.add(path);
//		
		return pathlist; 
	}
	
	public void setSPARQLbuilder(SparqlBuilderPanel builder){
		this.spBuilder = builder;
	}
	
//	void setSPARQLquery(Path path){
//		this.spBuilder;
//	}
	
	public MapFactory() {
		exbpframe = new ExtendFrame(this);
		exbp = exbpframe.getExtendBP();
		focal_points = new Vector<Object>();
		temp_nodes = new Vector<ExbpNodeTemp>();
		
//		focal_points.add("TEST");
//		focal_points.add("TEST2");
		
//		isSubLung=hze.isSubLang;
//		isGrayView=hze.isGrayView;//#kozaki 2009/07/28
//		exbp.setHZEditor(hze);
//		exbpframe.select_dialog = new EtendBPSelectDialog(exbp,exbpframe);
		exbpframe.setVisible(true);
    	exbpframe.RefreshExbp();
    	
//    	if(focal_points.size()==1){
//    		exbp.cmd_dialog.setCommandOptions(exbp.exbp_node_center);
//    	}
//    	
//    	treeSelectDialog = new TreeSelectDialog(true);
//	    treeSelectDialog.setHZEditor(this.hzEditor);
//	    treeSelectDialog.setSubLang(this.isSubLung);
//	    treeSelectDialog.setSize(450, 600);
//	    
    		}
	
	public void loadPathList(Path[] pathlist){
		Path path = pathlist[0];
		
		this.exbp.exbp_node_center = new ExbpNode(path.getStartClass());

		for(int i = 0; i<pathlist.length; i++){
			addPath(pathlist[i]);
		}
		this.exbpframe.RefreshExbp();
//		this.exbp.exbp_node_center = exbpnode;
//		exbpnode= new ExbpNode("Center");;
//		exbpnode.setChildrenColor(Color.red);
//		exbpnode.key="prop1";
//		this.exbp_node_center.addChild(exbpnode);
//		this.exbp_node_center.addChild(new ExbpNode("TEST2"));
//		this.exbp_node_center.addChild(new ExbpNode("TEST3"));
//		this.exbp_node_center.addChild(new ExbpNode("TEST4"));
		
		
	}

	
	
	void addPath(Path path){
		System.out.println("addPath"+path.getStartClass()+"--->"+path.getClassLinks().size());
		String target_class = path.getStartClass();
		ExbpNode node = this.exbp.findExbpNode(target_class);
		
		
		List<ClassLink> links = path.getClassLinks();
		for(ClassLink link : links){
			String next_class = link.getLinkedClassURI();
			System.out.println("==>"+next_class);
			ExbpNode next_node = new ExbpNode(next_class);
			next_node.setOrgNode(path);

			node.addChild(next_node);
			node = next_node;
			String prop = link.getPropertyURI();
			
			if(link.getDirection().equals(Direction.reverse)){
				prop += "[<=]";
			}
			else if(link.getDirection().equals(Direction.both)){
				prop += "[<=>]";
			}
			next_node.key = prop;			
		}
			
		
	}

	//元となるEditor等でMapToolを管理しているVectorを返す【Hozo以外ではオーバーライドする】
	Vector getMapVec(){
		return null;	
	}
	
	//元となるオントロジーのファイルを返す【Hozo以外ではオーバーライドする】
	File getFile(){
		return null;	
	}
	
	//すべてのロールの一覧を返す
	Vector getRoleList(){
		Vector roles = new Vector();
/*		Enumeration en = this.hzEditor.WCEditor.browsingPanel.node_lists.elements();
		while(en.hasMoreElements()){
			Node n =(Node)en.nextElement();
			Enumeration slot_en = n.getSlots().elements();
			while(slot_en.hasMoreElements()){
				Slot slot =(Slot)slot_en.nextElement();
				if(!roles.contains(slot.getRoleName())){
					roles.addElement(slot.getRoleName());
				}
			}
		}
			*/
		return roles;
	}

	//元となるオントロジーでの選択（クリック）処理【Hozo以外ではオーバーライドする】
	void selected(ExbpNode exbpnode){
//		this.hzEditor.WCEditor.browsingPanel.Jump(exbpnode.getHozoNode());	
	}

	//元となるオントロジーでの選択（クリック）処理【Hozo以外ではオーバーライドする】
	void selectedClear(){
//		this.hzEditor.WCEditor.definitionPanel.uncursel();
//		this.hzEditor.WCEditor.browsingPanel.pick(null, false);
	}
	//OpenしたMAPとオントロジーの元データの対応づけ
	void setOrgNodes(){
		/*
		if (this.hzEditor==null) {
			System.out.println("ERROR!!:::HzEditor is NOT FOUND!");
			return;
		}
		
		Enumeration en =exbp.nodes.elements();
		while(en.hasMoreElements()){
			ExbpNode node =(ExbpNode)en.nextElement();
			String lbl = node.getLabel();
			Node org_node;
			if(lbl.endsWith("[RH]")){
				lbl=lbl.substring(0,lbl.indexOf("[RH]"));
				//System.out.println(node.getLabel()+"====>"+lbl);
				if(this.isSubLung){
					org_node = this.hzEditor.WCEditor.findNodeWithSubLang(lbl);
				}
				else{
					org_node = this.hzEditor.findRH(lbl);
				}
			}
			else{
				if(this.isSubLung){
					org_node = this.hzEditor.WCEditor.findNodeWithSubLang(lbl);
				}
				else{
					org_node = this.hzEditor.findNode(lbl);
				}
			}
			node.setOrgNode(org_node);
			if(org_node!=null){
				//System.out.println("setOrgNodes:::"+lbl+"<=>"+org_node.getLabel());
			}else{
				//System.out.println("setOrgNodes:::"+lbl+"<=>NOT FOUND!");
			}
		}
			*/
	}
	
	//元となるObjectからFocalPointとなるExbpNodeを作る【Hozo以外ではオーバーライドする】
	ExbpNode[] setFocalPoints(){
//		if (this.hzEditor==null) return null;
		
		ExbpNode[] exbpnodes = null;

		exbp.nodes.removeAllElements();
		
//		Vector<Node> chi_nodes;		
//		GraphicObject gobj=null;
//		Object ob=null;

		if (focal_points.size() == 1) {//１つのNodeを選択した際の処理
			Object gobj = focal_points.firstElement(); 
            //gobj =(GraphicObject) focal_points.firstElement(); 
            
			if(gobj instanceof String){
				exbp.exbp_node_center =new ExbpNode((String)gobj);
				exbp.exbp_node_center.setOrgNode(gobj);
				exbp.nodes.add(exbp.exbp_node_center);
				exbpnodes = new ExbpNode[1];
				exbpnodes[0]=exbp.exbp_node_center;
			}
			else if(gobj instanceof Object){
				System.out.println("*** ERROR:Nodeを選択する必要があります::" );
			}
			else{//選択なしの場合は，エラーを出して終了
				
				JOptionPane.showMessageDialog(exbpframe, 
						"You Have to select [Node]!",
						"ERROR",
						JOptionPane.ERROR_MESSAGE);
				System.out.println("ERROR:Nodeを選択する必要があります::" );
				exbpframe.dispose();
			}				
		}
        else {//複数Nodeを選択した際の処理	
			if(focal_points.size() > 1){
	            exbp.exbp_node_center = new ExbpNode("(ROOT)");
	            exbp.nodes.addElement(exbp.exbp_node_center);

	            Vector chi_nodes = new Vector();
				Enumeration node_en = focal_points.elements();
	            while(node_en.hasMoreElements()){
					Object gobj2 = node_en.nextElement();
					if(gobj2 instanceof String){
						ExbpNode chinode = new ExbpNode((String)gobj2);
						chinode.setOrgNode(gobj2);
						exbp.exbp_node_center.addChild(chinode);
						exbp.nodes.add(chinode);
					}
					
					exbpnodes = new ExbpNode[exbp.exbp_node_center.children.size()];
					for(int i=0;i<exbp.exbp_node_center.children.size();i++){
						exbpnodes[i]=(ExbpNode)exbp.exbp_node_center.children.elementAt(i);
					}
				}
			}		
		else{//Nodeを見選択の際の処理
			JOptionPane.showMessageDialog(exbpframe, 
					"You Have to select [Node]!",
					"ERROR",
					JOptionPane.ERROR_MESSAGE);
			System.out.println("ERROR:Nodeを選択する必要があります");
			exbpframe.dispose();			
			}			
       }
		
		return exbpnodes;
	}
	
	/*
	//元となるObjectからExbpNodeを作る【Hozo以外ではオーバーライドする】
	ExbpNode makeExbpNode(Object obj){
		if(!(obj instanceof String)){
			//System.out.println("ERROR@makeChildNodes():obj is NOT Node!");
			return null;
		}
		
		Node node =(Node)obj;
		ExbpNode exbpnode;
		
		
		//#kozaki 2009/08/19　Slotの処理を追加
		if(node instanceof hozo.oe.gobj.Slot){
			if(!((Slot)node).getRHname().equals("")){
				node = this.hzEditor.findRH(((Slot)node).getRHname());
			}
			else{
				
			}	
		}
		
		if(node instanceof hozo.oe.gobj.NodeRH){
			if(this.isSubLung){
				exbpnode= new ExbpNode(node.getSubLabel()+"[RH]");
				}
			else{
				exbpnode= new ExbpNode(node.getLabel()+"[RH]");
			}			
		}
		else{
			if(this.isSubLung){
				exbpnode= new ExbpNode(node.getSubLabel());
				}
			else{
				exbpnode= new ExbpNode(node.getLabel());
			}			
		}
		
		exbpnode.setOrgNode(obj);
		//exbp.nodes.add(exbpnode);
		
		return exbpnode;
	}*/
	
	
	//１つのExbpNodeにコマンドを適応して下位ExbpNodeを追加する【Hozo以外でのオーバーライドは必要なし】
	//　コマンド毎にメソッドをオーバーライドする
	void makeChildNodes(ExbpNode exbpnode, String command){
	/*	if(!(exbpnode.getOrgNode() instanceof Node)){
			//System.out.println("ERROR@makeChildNodes():orgnode is NOT Node!");
			return;
		}
		
//		exbpnode.children.removeAllElements();	
//		System.out.println("makeChildNodes():::command="+command);
		removeAllChildren(exbpnode);	
		
			
		if(command.equals("isa")){ // ?　下位概念の抽出 is-a
			makeChildNodeISA(exbpnode);
			}
		else if(command.equals("super")){// ?上位概念の抽出
			makeChildNodeSuper(exbpnode);
			}			
		else if(command.startsWith(":")){// 参照元の抽出　Refereed to
			makeChildNodeRefered(exbpnode,command);
			}
		// #hirota 08/08/19 コマンド結合
		else if(command.startsWith(";")){ // (old)ロール指定あり　＋　下位概念指定あり
			makeChildNodeRoleSub(exbpnode,command);
			}
		else if(command.equals("any-h")){ // ? depend-on →  #hirota 11/26  現在の視点がNodeのとき、NodeのスロットのRHを表示
			makeChildNodeDependOnRH(exbpnode,command); 
			}
		else if(command.equals("++s")){// ?　depend on 　←コンテキストを取り出す
			makeChildNodeDependOnContext(exbpnode,command); 	
			}
		else if(command.equals("++P")){//  playable 関係 ?　→ all
			makeChildNodePlayable(exbpnode);
		}
		else if(command.startsWith("++p")){// playable 関係 ?　→ label 指定
			makeChildNodePlayableByLabel(exbpnode, command);
			}
		else if(command.equals("++c")){ // ?　playable → プレイヤーの取り出し
			makeChildNodePlayer(exbpnode);
			}
		else if(command.startsWith("++r:")){// ?関係概念の取り出し  ++r:Lable 
			makeChildNodeRelationConcept(exbpnode,command); 
		}
		else if(command.equals("++R")){ // ++R  全部取り出し
			makeChildNodeRelationAll(exbpnode);
			}	
		else if(command.startsWith("super_isa")){ // #hirota 08/09/03 兄弟概念の取り出し(super+isa)
			makeChildNodeBrothers(exbpnode);
			}
		else if(command.startsWith("_")){//		クラス制約を辿る処理　only RH
			makeChildNodeCConlyRH(exbpnode,command);
			}
		else{
			makeChildNodeReferringTo(exbpnode,command);// クラス制約を辿る処理
			}
			*/
		}
	
	public void run(){
		//SerachPath(target_nodes,target_cls); 
	}
	
	public void stop(){
//		pbar_frame.stop();
//		pbar_frame=null;			
	}
	
	ExbpNode[] target_nodes;
//	Node[] target_cls;
	int[] match_num;
//	ProgressFrame pbar_frame;
	
/*	
	public void SearchPathAsThread(ExbpNode[] nodes, Node[] cls){
		pbar_frame = new ProgressFrame("Serach Path","Now,Searching..., Please wait.");
		pbar_frame.frame.setAlwaysOnTop(true);
		pbar_frame.frame.setLocation(exbp.cmd_dialog.getWidth(),100);
		
		
		target_nodes = nodes;
		target_cls =cls;
		match_num = new int[cls.length];
		for(int i=0;i<match_num.length;i++){
			match_num[i]=0;
		}
		
		Thread thread = new Thread(this);
		thread.start();	
		

	}*/
	/*
	
	void checkMatchCount(){
		match_num = new int[target_cls.length];
		for(int i=0;i<match_num.length;i++){
			match_num[i]=0;
		}
		
		Enumeration en = this.exbp.nodes.elements();
		while(en.hasMoreElements()){
			ExbpNode node = (ExbpNode)en.nextElement();
			Object obj = node.getOrgNode();
			if(obj instanceof Node){
				Node hozonode=(Node)obj;
				for(int i=0;i<target_cls.length;i++){
					if(target_cls[i] instanceof Node){
						if(hozonode.isSubclassOf((Node)target_cls[i])
								|| hozonode.equals(target_cls[i])){
							match_num[i]++;
						}
					}
				}
			}
		}
		
		for(int i=0;i<target_cls.length;i++){
			System.out.println(
					target_cls[i].getLabel()+" = "+
					match_num[i]);
		}
	}
	*/
	
	//#kozaki　2009/02/13　対象ノードを複数に拡張	
//	public void SerachPath(ExbpNode[] nodes, Node[] target_cls/*String[] cls_lists*/){}

//	private Vector<ExbpNode> SerachPath(Vector<ExbpNode> nodes,
//			Node[] cls_lists,Vector<ExbpNode> match_nodes){}
	
	void removeAllChildren(ExbpNode exbpnode){
		this.exbp.nodes.removeAll(exbpnode.children);
		exbpnode.children.removeAllElements();	
	}

	//次にたどるノードのリストを取得する
	//※一度たどったことのあるデータは，temp_nodesに保持され，そちらを返す
//	Vector<ExbpNode> getChildNodeFromTemp(ExbpNode exbpnode, String cmd){}

	
	void explore(ExbpNode exbpnode, boolean all, String cmd){
	/*	ExbpNode[] exbpnodes=new ExbpNode[1];
		
		if(!all){
			exbpnodes=new ExbpNode[1];
			exbpnodes[0]=exbpnode;
		}
		else{
			int layer = exbpnode.getLocatedLayer();
			exbpnodes=exbp.getExbpNodesAtLear(layer,true);
		}
		
		for(int l=0;l<exbpnodes.length;l++){
			if(exbpnodes[l].visible){
				this.makeChildNodeReferringToDirectly(exbpnodes[l], cmd);
				this.makeChildNodeRefered(exbpnodes[l], ":Any");
				
				//exbpnodes[l].children.removeAllElements();
//				Vector temp_children = getChildNodeFromTemp(exbpnodes[l],cmd);
//				Enumeration en = temp_children.elements();
//				while(en.hasMoreElements()){
//					ExbpNode chi = (ExbpNode)en.nextElement();
//					exbpnodes[l].addChild(chi);
//					chi.setVisible(true);
//				}
			}
		}*/
		
	}

	void clearSubPath(ExbpNode exbpnode){
		ExbpNode[] exbpnodes=new ExbpNode[1];
		
		int layer = exbpnode.getLocatedLayer();
		exbpnodes=exbp.getExbpNodesAtLear(layer,true);
		
		
		for(int l=0;l<exbpnodes.length;l++){
			if(exbpnodes[l].visible){
				this.removeAllChildren(exbpnodes[l]);
			}
		}
		
	}

	
	//各コマンドを適用したときにたどるノードをしらべて，Treeのコマンドリストに入れる．
//	void setCommandsTree(ExbpNode[] exbpnodes){}
	
public void makeChildNodeSuper(ExbpNode exbpnode) {}


private void makeSlotRelatedExbpNode(ExbpNode exbpnode, String command) {}

//	#kozaki 2008/08/17　スロットで関連した概念を辿る処理への分岐
//	private void makeSlotRelatedExbpNode(ExbpNode par_exbpnode, Node node, String command){}
	
	
	//#kozaki 2008/08/12　クラス制約を辿る処理を独立
//	private void makeExbpNodeCC(ExbpNode par_exbpnode,	//親となるExbpNode
//								Slot slot,				//辿る対象となるスロット
//								Node slot_node,			//クラス制約として参照しているノード
//								Node node,				//辿るスロットを持つノード
//								String command,		//辿るコマンド
//								String match_key		//一致したコマンド（上位スロットの処理用）
//								){}
	
//	public void makeChildNodeISA(ExbpNode exbpnode){}

	
	// ?
//	private void makeChildNodeRefered(ExbpNode exbpnode, String command) {}

	//	?’ (old)ロール指定あり　＋　下位概念指定あり
//	public void makeChildNodeRoleSub(ExbpNode exbpnode,String command) {}

	// ? depend-on →  #hirota 11/26  現在の視点がNodeのとき、NodeのスロットのRHを表示
//	public void makeChildNodeDependOnRH(ExbpNode exbpnode,String NodeCC) {}
	
	
	
	// ?　depend on 　←コンテキストを取り出す #hirota add 09/11/09
//	public void makeChildNodeDependOnContext(ExbpNode exbpnode,String command) {}
	
//  playable 関係 ?　→ all
//	public void makeChildNodePlayable(ExbpNode exbpnode) {}

	// playable 関係 ?　→ label 指定
//	private void makeChildNodePlayableByLabel(ExbpNode exbpnode,String command) {}

	 // ?　playable → プレイヤーの取り出し
//	public void makeChildNodePlayer(ExbpNode exbpnode) {}	
//	private void makeChildNodeRelationConcept(ExbpNode exbpnode,String command) {}	
	
//	 ++R  全部取り出し(継承オプションありのとき）
//	public void makeChildNodeRelationAllToDirectry(ExbpNode exbpnode) {}
	// ++R  全部取り出し
//	public void makeChildNodeRelationAll(ExbpNode exbpnode) {}	
	
	// #hirota 08/09/03 兄弟概念の取り出し(super+isa)
//	private void makeChildNodeBrothers(ExbpNode exbpnode) {}	
	
	//	クラス制約を辿る処理　only RH
//	private void makeChildNodeCConlyRH(ExbpNode exbpnode,String command) {}	
	
	//	クラス制約を辿る処理　
//	private void makeChildNodeReferringTo(ExbpNode exbpnode,String command) {}	

//	クラス制約を辿る処理★サブスロットを含まない　#kozaki　2009/08/19
//	private void makeChildNodeReferringToDirectly(ExbpNode exbpnode,String command) {}	

	
//	String[] getOtionLists(Vector<ExbpNode> exbpnodes){}
	
	
/*	public String[] getSelectedClass(String[] labels){
		TreeSelectDialog treeSelectDialog = new TreeSelectDialog(true);
	    treeSelectDialog.setHZEditor(this.hzEditor);
	    treeSelectDialog.setSubLang(this.isSubLung);
	    treeSelectDialog.updateTree();
	    //treeSelectDialog.setSize(320, 450);
	    if(labels.length>0){
		   	String label = labels[0];
		   	for(int i=1;i<labels.length;i++){
		   		label +=" "+"\\" + Slot.OR_DELIMITER+" "+labels[i];
		   	}
		   	treeSelectDialog.setSelectedTreeDialog(labels, label);
	    }
	    treeSelectDialog.setVisible(true);
        if (treeSelectDialog.isOK()) {
        	String[] cls_lists = treeSelectDialog.getSelectedHozoNodesByLabel();
//        	String opt = treeSelectDialog.getSelected();
//        	if(opt==null){
//				opt="Any";
//			}
//	    	String[] cls_lists = opt.split(" "+"\\" + Slot.OR_DELIMITER+" ");
            return cls_lists;
        }
        return null;
	}*/
	
//	public Object[] getSelectedClasses(String target_cls){}
	
//	public Node[] getSelectedClassesAsNode(String target_cls){}

//	public Node getHozoNode(String lbl){}	
	
//	public boolean isSubClassOfSelectedClasses(Object node, Object[] target_classes){}
	
//	public boolean isSubClass(Object node, Object target){}

	//#kozaki 2009/02/13　Node[]をString[]に変換
//	public String[] NodesToStrings(Node[] nodes){}
	
	//#kozaki 2009/02/13　クラス一覧をNode[]で取得
//	public Node[] getSelectedClassNodes(Node[] nodes){}

	//#hirota 2009/05/18　関係概念一覧をNode[]で取得
//	public Node[] getSelectedClassNodes2(Node[] nodes){
//	 return null;	
//	}
	
	//#kozaki 09/02/15
//	public void setSubLang(boolean b){}
	
}


